/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.taobao.weex.ui.view.listview.IRefreshLayout;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;

public class RefreshAdapterWrapper
extends RecyclerView.Adapter<ListBaseViewHolder> {
    private static final int ITEM_TYPE_REFRESH = 0xFFFFFF;
    private static final int ITEM_TYPE_LOADMORE = 0x1000000;
    private Status mStatus = Status.NORMAL;
    private RecyclerViewBaseAdapter mInnerRecyclerViewAdapter;
    private IRefreshLayout mRefreshLayout;
    private IRefreshLayout mLoadMoreLayout;

    public RefreshAdapterWrapper(Context context, RecyclerViewBaseAdapter adapter) {
        this.mInnerRecyclerViewAdapter = adapter;
        this.init(context);
    }

    public void refreshing() {
        this.mStatus = Status.REFRESH;
        if (this.mRefreshLayout != null) {
            this.mRefreshLayout.refreshing();
        }
        this.notifyDataSetChanged();
    }

    public void resetRefreshing() {
        this.mStatus = Status.NORMAL;
        if (this.mRefreshLayout != null) {
            this.mRefreshLayout.resetRefreshing();
        }
        if (this.mLoadMoreLayout != null) {
            this.mLoadMoreLayout.resetRefreshing();
        }
        this.notifyDataSetChanged();
    }

    public void loadingMore() {
        this.mStatus = Status.LOADMORE;
        if (this.mLoadMoreLayout != null) {
            this.mLoadMoreLayout.refreshing();
        }
        this.notifyDataSetChanged();
    }

    public boolean isRefreshing() {
        return this.mStatus == Status.REFRESH;
    }

    public boolean isLoadingMore() {
        return this.mStatus == Status.LOADMORE;
    }

    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (this.mStatus) {
            case REFRESH: {
                if (viewType != 0xFFFFFF || this.mRefreshLayout == null) break;
                return new ListBaseViewHolder(this.mRefreshLayout.getView(), viewType);
            }
            case LOADMORE: {
                if (viewType != 0x1000000 || this.mLoadMoreLayout == null) break;
                return new ListBaseViewHolder(this.mLoadMoreLayout.getView(), viewType);
            }
        }
        return this.mInnerRecyclerViewAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        if (position == 0) {
            switch (this.mStatus) {
                case REFRESH: {
                    return;
                }
            }
        } else if (position == this.getItemCount() - 1) {
            switch (this.mStatus) {
                case LOADMORE: {
                    return;
                }
            }
        }
        this.mInnerRecyclerViewAdapter.onBindViewHolder(holder, position);
    }

    public int getItemCount() {
        return this.mInnerRecyclerViewAdapter.getItemCount();
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            switch (this.mStatus) {
                case REFRESH: {
                    return 0xFFFFFF;
                }
            }
        } else if (position == this.getItemCount() - 1) {
            switch (this.mStatus) {
                case LOADMORE: {
                    return 0x1000000;
                }
            }
        }
        return this.mInnerRecyclerViewAdapter.getItemViewType(position);
    }

    public long getItemId(int position) {
        return this.mInnerRecyclerViewAdapter.getItemId(position);
    }

    public void onViewRecycled(ListBaseViewHolder holder) {
        this.mInnerRecyclerViewAdapter.onViewRecycled(holder);
    }

    public void onViewDetachedFromWindow(ListBaseViewHolder holder) {
        this.mInnerRecyclerViewAdapter.onViewDetachedFromWindow(holder);
    }

    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        return this.mInnerRecyclerViewAdapter.onFailedToRecycleView(holder);
    }

    private void init(Context context) {
        this.mRefreshLayout = new IRefreshLayout.Adapter((View)new Refreshlayout(context));
        this.mLoadMoreLayout = new IRefreshLayout.Adapter((View)new Refreshlayout(context));
    }

    private class Refreshlayout
    extends FrameLayout {
        public Refreshlayout(Context context) {
            super(context);
            this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
            ProgressBar pb = new ProgressBar(context);
            FrameLayout.LayoutParams pbLp = new FrameLayout.LayoutParams(-2, -2);
            pbLp.gravity = 1;
            this.addView((View)pb, (ViewGroup.LayoutParams)pbLp);
        }
    }

    private static enum Status {
        NORMAL,
        REFRESH,
        LOADMORE;

    }
}

