/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.content.Context;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.BounceRecyclerView;
import com.taobao.weex.ui.view.listview.IRefreshLayout;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WXListComponent
extends WXVContainer
implements IRecyclerAdapterListener<ListBaseViewHolder>,
IOnLoadMoreListener {
    public static final String TRANSFORM = "transform";
    private String TAG = "WXListComponent";
    private int mListCellCount = 0;
    private String mLoadMoreRetry = "";
    private WXRefresh mRefresh;
    private WXLoading mLoading;
    private ArrayList<ListBaseViewHolder> recycleViewList = new ArrayList();
    private static final Pattern transformPattern = Pattern.compile("([a-z]+)\\(([0-9\\.]+),?([0-9\\.]+)?\\)");
    private SparseArray<WXComponent> mAppearComponents = new SparseArray();
    private HashMap<String, Long> mRefToViewType;

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, boolean lazy) {
        super(instance, node, parent, lazy);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(this.mInstanceId);
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.mAbsoluteY : height;
        return super.measure(width, outHeight);
    }

    protected int getOrientation() {
        return 1;
    }

    private RecyclerView.ItemDecoration parseTransforms(String raw) {
        if (raw == null) {
            return null;
        }
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        int translateX = 0;
        int translateY = 0;
        float opacity = 0.0f;
        int rotate = 0;
        Matcher matcher = transformPattern.matcher(raw);
        while (matcher.find()) {
            String match = matcher.group();
            String name = matcher.group(1);
            try {
                switch (name) {
                    case "scale": {
                        scaleX = Float.parseFloat(matcher.group(2));
                        scaleY = Float.parseFloat(matcher.group(3));
                        break;
                    }
                    case "translate": {
                        translateX = Integer.parseInt(matcher.group(2));
                        translateY = Integer.parseInt(matcher.group(3));
                        break;
                    }
                    case "opacity": {
                        opacity = Float.parseFloat(matcher.group(2));
                        break;
                    }
                    case "rotate": {
                        rotate = Integer.parseInt(matcher.group(2));
                        break;
                    }
                    default: {
                        WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                WXLogUtils.e(this.TAG, "Invaild transform expression:" + match);
            }
        }
        return new BounceRecyclerView.TransformItemDecoration(this.getOrientation() == 1, opacity, translateX, translateY, rotate, scaleX, scaleY);
    }

    @Override
    protected void initView() {
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        BounceRecyclerView view = new BounceRecyclerView(this.mContext, this.getOrientation());
        WXRecyclerView bounceview = (WXRecyclerView)((Object)view.getBounceView());
        String transforms = (String)this.mDomObj.attr.get(TRANSFORM);
        if (transforms != null) {
            ((WXRecyclerView)((Object)view.getBounceView())).addItemDecoration(this.parseTransforms(transforms));
        }
        bounceview.setOverScrollMode(2);
        view.setAdapter(recyclerViewBaseAdapter);
        bounceview.clearOnScrollListeners();
        bounceview.addOnScrollListener(new WXRecyclerViewOnScrollListener(this));
        bounceview.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                List<OnWXScrollListener> listeners;
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    for (ListBaseViewHolder holder : WXListComponent.this.recycleViewList) {
                        if (holder == null || holder.getComponent() == null || holder.getComponent().isUsing()) continue;
                        WXListComponent.this.recycleImage(holder.getView());
                    }
                    WXListComponent.this.recycleViewList.clear();
                }
                if ((listeners = WXListComponent.this.mInstance.getWXScrollListeners()) != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        View topView;
                        if (listener == null || (topView = recyclerView.getChildAt(0)) == null || listener == null) continue;
                        int y = topView.getTop();
                        listener.onScrollStateChanged((View)recyclerView, 0, y, newState);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = WXListComponent.this.mInstance.getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        if (listener == null) continue;
                        listener.onScrolled((View)recyclerView, dx, dy);
                    }
                }
            }
        });
        this.mHost = view;
    }

    @Override
    public BounceRecyclerView getView() {
        return (BounceRecyclerView)super.getView();
    }

    @Override
    public BounceRecyclerView getRealView() {
        return (BounceRecyclerView)super.getView();
    }

    @Override
    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        int adapterPosition = index == -1 ? this.mChildren.size() - 1 : index;
        BounceRecyclerView view = this.getView();
        if (view != null) {
            view.getAdapter().notifyItemInserted(adapterPosition);
        }
        if (child.getDomObject().containsEvent("appear") || child.getDomObject().containsEvent("disappear")) {
            this.mAppearComponents.put(adapterPosition, (Object)child);
            child.registerAppearEvent = true;
        }
        this.checkRefreshOrLoading(child);
    }

    @Override
    protected void addSubView(View child, int index) {
        BounceRecyclerView view = this.getView();
        if (view == null) {
            return;
        }
        int pos = index == -1 ? view.getAdapter().getItemCount() - 1 : index;
    }

    @Override
    public void remove(WXComponent child) {
        this.remove(child, true);
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        int index = this.mChildren.indexOf(child);
        if (destroy) {
            child.detachViewAndClearPreInfo();
        }
        this.getView().getAdapter().notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "removeChild child at " + index);
        }
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        RecyclerView view = (RecyclerView)this.getView().getBounceView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        long begin = System.currentTimeMillis();
        holder.setComponentUsing(false);
        this.recycleViewList.add(holder);
        WXLogUtils.d(this.TAG, "Recycle holder " + (System.currentTimeMillis() - begin) + "  Thread:" + Thread.currentThread().getName());
    }

    @Override
    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        long begin = System.currentTimeMillis();
        if (holder == null) {
            return;
        }
        holder.setComponentUsing(true);
        WXComponent component = this.getChild(position);
        if (component == null || component instanceof WXRefresh || component instanceof WXLoading || component.mDomObj != null && component.mDomObj.isFixed()) {
            WXLogUtils.d(this.TAG, "Bind WXRefresh & WXLoading " + (Object)((Object)holder));
            return;
        }
        if (component != null && holder.getComponent() != null && holder.getComponent() instanceof WXCell) {
            holder.getComponent().applyLayoutAndEvent(component);
            holder.getComponent().bindData(component);
        }
        WXLogUtils.d(this.TAG, "Bind holder " + (System.currentTimeMillis() - begin) + "  Thread:" + Thread.currentThread().getName());
    }

    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        WXLogUtils.d(this.TAG, "onCreateViewHolder");
        if (this.mChildren != null) {
            for (int i = 0; i < this.childCount(); ++i) {
                WXComponent component = this.getChild(i);
                if (component == null || component.isUsing() || this.getItemViewType(i) != viewType) continue;
                if (component instanceof WXRefresh) {
                    return this.createVHForWXRefresh(component, viewType);
                }
                if (component instanceof WXLoading) {
                    return this.createVHForWXLoading(component, viewType);
                }
                if (component.mDomObj != null && component.mDomObj.isFixed()) {
                    return this.createVHForFakeComponent(viewType);
                }
                if (component.getRealView() != null) {
                    return new ListBaseViewHolder(component, viewType);
                }
                long begin = System.currentTimeMillis();
                component.lazy(false);
                component.createView(this, -1);
                WXLogUtils.d(this.TAG, "onCreateViewHolder lazy create:" + (System.currentTimeMillis() - begin) + "  Thread:" + Thread.currentThread().getName());
                return new ListBaseViewHolder(component, viewType);
            }
        }
        WXLogUtils.e(this.TAG, "Cannot find request viewType: " + viewType);
        throw new WXRuntimeException("mChildren is null");
    }

    @Override
    public int getItemViewType(int position) {
        long id;
        try {
            id = Integer.parseInt(this.getChild((int)position).getDomObject().ref);
            String type = ((WXComponent)this.mChildren.get((int)position)).getDomObject().attr.getScope();
            if (!TextUtils.isEmpty((CharSequence)type)) {
                if (this.mRefToViewType == null) {
                    this.mRefToViewType = new HashMap();
                }
                if (!this.mRefToViewType.containsKey(type)) {
                    this.mRefToViewType.put(type, id);
                }
                id = this.mRefToViewType.get(type);
            }
        }
        catch (RuntimeException e) {
            WXLogUtils.e(this.TAG, WXLogUtils.getStackTrace(e));
            id = -1L;
            WXLogUtils.e(this.TAG, "getItemViewType: NO ID, this will crash the whole render system of WXListRecyclerView");
        }
        return (int)id;
    }

    @Override
    public int getItemCount() {
        if (this.mChildren != null) {
            return this.mChildren.size();
        }
        return 0;
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        WXLogUtils.d(this.TAG, "Failed to recycle " + (Object)((Object)holder));
        return false;
    }

    @Override
    public long getItemId(int position) {
        return 0L;
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            String offset = this.mDomObj.attr.getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            if (offScreenY < Integer.parseInt(offset)) {
                String loadMoreRetry = this.mDomObj.attr.getLoadMoreRetry();
                if (this.mListCellCount != this.mChildren.size() || this.mLoadMoreRetry == null || !this.mLoadMoreRetry.equals(loadMoreRetry)) {
                    WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, "loadmore");
                    this.mListCellCount = this.mChildren.size();
                    this.mLoadMoreRetry = loadMoreRetry;
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d(this.TAG, "onLoadMore :" + WXLogUtils.getStackTrace(e));
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible, int directionX, int directionY) {
        int i;
        ArrayList<Integer> unRegisterKeys = new ArrayList<Integer>();
        int len = this.mAppearComponents.size();
        for (i = 0; i < len; ++i) {
            String direction;
            int key = this.mAppearComponents.keyAt(i);
            WXComponent value = (WXComponent)this.mAppearComponents.get(key);
            if (!value.registerAppearEvent) {
                unRegisterKeys.add(key);
                continue;
            }
            if (key >= firstVisible && key <= lastVisible && !value.appearState) {
                direction = directionY > 0 ? "up" : "down";
                value.notifyAppearStateChange("appear", direction);
                value.appearState = true;
            } else if ((key < firstVisible || key > lastVisible) && value.appearState) {
                direction = directionY > 0 ? "up" : "down";
                value.notifyAppearStateChange("disappear", direction);
                value.appearState = false;
            }
            WXLogUtils.d(this.TAG, "key:" + key + " " + "appear:" + value.appearState);
        }
        len = unRegisterKeys.size();
        for (i = 0; i < len; ++i) {
            this.mAppearComponents.remove(((Integer)unRegisterKeys.get(i)).intValue());
        }
    }

    public void unbindAppearComponents(WXComponent component) {
        this.mAppearComponents.remove(this.mAppearComponents.indexOfValue((Object)component));
    }

    private void checkRefreshOrLoading(WXComponent child) {
        if (child instanceof WXRefresh) {
            this.getView().setOnRefreshListener((WXRefresh)child);
            this.mRefresh = (WXRefresh)child;
        }
        if (child instanceof WXLoading) {
            this.getView().setOnLoadMoreListener((WXLoading)child);
            this.mLoading = (WXLoading)child;
        }
    }

    private void recycleImage(View view) {
        if (view instanceof ImageView) {
            if (this.mInstance.getImgLoaderAdapter() != null) {
                this.mInstance.getImgLoaderAdapter().setImage(null, (ImageView)view, null, null);
            } else {
                if (WXEnvironment.isApkDebugable()) {
                    throw new WXRuntimeException("getImgLoaderAdapter() == null");
                }
                WXLogUtils.e("Error getImgLoaderAdapter() == null");
            }
        } else if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.recycleImage(((ViewGroup)view).getChildAt(i));
            }
        }
    }

    @NonNull
    private ListBaseViewHolder createVHForFakeComponent(int viewType) {
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(-1);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
        return new ListBaseViewHolder((View)view, viewType);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXLoading(WXComponent component, int viewType) {
        this.getView().setBounceFooterView(new IRefreshLayout.Adapter(component.getView()){

            @Override
            public void onPull(float scale) {
                super.onPull(scale);
                WXListComponent.this.mLoading.onPullLoadingIndicator((int)scale);
            }
        });
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(0);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder((View)view, viewType);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXRefresh(WXComponent component, int viewType) {
        this.getView().setBounceHeaderView(new IRefreshLayout.Adapter(component.getView()){

            @Override
            public void onPull(float scale) {
                super.onPull(scale);
                WXListComponent.this.mRefresh.onPullLoadingIndicator((int)scale);
            }
        });
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(0);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder((View)view, viewType);
    }
}

