/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.ui.ComponentHolder;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WXComponentRegistry {
    private static Map<String, ComponentHolder> sTypeComponentMap = new HashMap<String, ComponentHolder>();
    private static Map<String, String> sClassTypeMap = new HashMap<String, String>();

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz, boolean appendTree) throws WXException {
        if (clazz == null || TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        HashMap<String, String> componentInfo = new HashMap<String, String>();
        componentInfo.put("type", type);
        if (appendTree) {
            componentInfo.put("append", "tree");
        }
        WXComponentRegistry.registerInternal(type, clazz, componentInfo);
        return true;
    }

    private static void registerInternal(final String type, final Class<? extends WXComponent> clazz, final Map<String, String> componentInfo) {
        WXBridgeManager.getInstance().getJSHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    WXComponentRegistry.registerNativeComponent(type, clazz);
                    WXComponentRegistry.registerJSComponent(componentInfo);
                }
                catch (WXException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static boolean registerNativeComponent(String type, Class<? extends WXComponent> clazz) throws WXException {
        ComponentHolder holder;
        if (type == null) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXException("Component name required.");
            }
            WXLogUtils.e("Component name required." + type);
            return false;
        }
        if (sClassTypeMap.get(clazz.getName()) == null) {
            holder = new ComponentHolder(clazz);
            sClassTypeMap.put(clazz.getName(), type);
        } else {
            holder = sTypeComponentMap.get(sClassTypeMap.get(clazz.getName()));
        }
        sTypeComponentMap.put(type, holder);
        return true;
    }

    private static boolean registerJSComponent(Map<String, String> componentInfo) throws WXException {
        ArrayList<Map<String, String>> coms = new ArrayList<Map<String, String>>();
        coms.add(componentInfo);
        WXSDKManager.getInstance().registerComponents(coms);
        return true;
    }

    public static boolean registerComponent(Map<String, String> componentInfo, Class<? extends WXComponent> clazz) throws WXException {
        if (componentInfo == null || clazz == null) {
            return false;
        }
        String type = componentInfo.get("type");
        if (type == null) {
            return false;
        }
        WXComponentRegistry.registerInternal(type, clazz, componentInfo);
        return true;
    }

    public static ComponentHolder getComponent(String type) {
        return sTypeComponentMap.get(type);
    }
}

