/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.appfram.navigator.IActivityNavBarSetter;
import com.taobao.weex.appfram.navigator.WXNavigatorModule;
import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.common.TypeModuleFactory;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXInstanceWrap;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomModule;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXDomRegistry;
import com.taobao.weex.dom.WXSwitchDomObject;
import com.taobao.weex.dom.WXTextDomObject;
import com.taobao.weex.dom.module.WXModalUIModule;
import com.taobao.weex.http.WXStreamModule;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.WXA;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXInput;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXLoadingIndicator;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXSwitch;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVideo;
import com.taobao.weex.ui.component.WXWeb;
import com.taobao.weex.ui.component.list.HorizontalListComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.module.WXWebViewModule;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXSoInstallMgrSdk;
import java.lang.reflect.Method;
import java.util.Map;

public class WXSDKEngine {
    private static final String V8_SO_NAME = "weexcore";
    private static volatile boolean init;
    private static final Object mLock;
    private static final String TAG = "WXSDKEngine";

    @Deprecated
    public static void init(Application application) {
        WXSDKEngine.init(application, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter) {
        WXSDKEngine.init(application, utAdapter, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter, String framework) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = mLock;
        synchronized (object) {
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Application application, InitConfig config) {
        Object object = mLock;
        synchronized (object) {
            if (init) {
                return;
            }
            long start = System.currentTimeMillis();
            WXSDKEngine.doInitInternal(application, config);
            WXEnvironment.sSDKInitInvokeTime = System.currentTimeMillis() - start;
            init = true;
        }
    }

    private static void doInitInternal(final Application application, final InitConfig config) {
        WXEnvironment.sApplication = application;
        WXEnvironment.JsFrameworkInit = false;
        WXBridgeManager.getInstance().getJSHandler().post(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXSDKManager sm = WXSDKManager.getInstance();
                if (config != null) {
                    sm.setIWXHttpAdapter(config.getHttpAdapter());
                    sm.setIWXImgLoaderAdapter(config.getImgAdapter());
                    sm.setIWXUserTrackAdapter(config.getUtAdapter());
                    sm.setIWXDebugAdapter(config.getDebugAdapter());
                    if (config.getDebugAdapter() != null) {
                        config.getDebugAdapter().initDebug(application);
                    }
                }
                WXSoInstallMgrSdk.init((Context)application);
                boolean isSoInitSuccess = WXSoInstallMgrSdk.initSo(WXSDKEngine.V8_SO_NAME, 1, config != null ? config.getUtAdapter() : null);
                if (!isSoInitSuccess) {
                    return;
                }
                sm.initScriptsFramework(null);
                WXEnvironment.sSDKInitExecuteTime = System.currentTimeMillis() - start;
                WXLogUtils.renderPerformanceLog("SDKInitInvokeTime", WXEnvironment.sSDKInitInvokeTime);
                WXLogUtils.renderPerformanceLog("SDKInitExecuteTime", WXEnvironment.sSDKInitExecuteTime);
            }
        });
        WXSDKEngine.register();
    }

    @Deprecated
    public static void init(Application application, String framework, IWXUserTrackAdapter utAdapter, IWXImgLoaderAdapter imgLoaderAdapter, IWXHttpAdapter httpAdapter) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).setHttpAdapter(httpAdapter).setImgAdapter(imgLoaderAdapter).build());
    }

    private static void register() {
        try {
            WXSDKEngine.registerComponent("text", WXText.class, false);
            WXSDKEngine.registerComponent("img", WXImage.class, false);
            WXSDKEngine.registerComponent("div", WXDiv.class, false);
            WXSDKEngine.registerComponent("image", WXImage.class, false);
            WXSDKEngine.registerComponent("container", WXDiv.class, false);
            WXSDKEngine.registerComponent("scroller", WXScroller.class, false);
            WXSDKEngine.registerComponent("slider", WXSlider.class, true);
            WXSDKEngine.registerComponent(WXListComponent.class, false, "list", "vlist");
            WXSDKEngine.registerComponent(HorizontalListComponent.class, false, "hlist");
            WXSDKEngine.registerComponent("cell", WXCell.class, true);
            WXSDKEngine.registerComponent("indicator", WXIndicator.class, true);
            WXSDKEngine.registerComponent("video", WXVideo.class, false);
            WXSDKEngine.registerComponent("input", WXInput.class, false);
            WXSDKEngine.registerComponent("switch", WXSwitch.class, false);
            WXSDKEngine.registerComponent("a", WXA.class, false);
            WXSDKEngine.registerComponent("embed", WXEmbed.class, true);
            WXSDKEngine.registerComponent("web", WXWeb.class);
            WXSDKEngine.registerComponent("refresh", WXRefresh.class);
            WXSDKEngine.registerComponent("loading", WXLoading.class);
            WXSDKEngine.registerComponent("loading-indicator", WXLoadingIndicator.class);
            WXSDKEngine.registerModule("dom", WXDomModule.class, true);
            WXSDKEngine.registerModule("modal", WXModalUIModule.class, false);
            WXSDKEngine.registerModule("instanceWrap", WXInstanceWrap.class, true);
            WXSDKEngine.registerModule("animation", WXAnimationModule.class, true);
            WXSDKEngine.registerModule("webview", WXWebViewModule.class, true);
            WXSDKEngine.registerModule("navigator", WXNavigatorModule.class);
            WXSDKEngine.registerModule("stream", WXStreamModule.class);
            WXSDKEngine.registerDomObject("text", WXTextDomObject.class);
            WXSDKEngine.registerDomObject("input", WXTextDomObject.class);
            WXSDKEngine.registerDomObject("switch", WXSwitchDomObject.class);
        }
        catch (WXException e) {
            WXLogUtils.e("[WXSDKEngine] register:" + WXLogUtils.getStackTrace(e));
        }
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz, boolean appendTree) throws WXException {
        return WXSDKEngine.registerComponent(clazz, appendTree, type);
    }

    public static boolean registerComponent(Class<? extends WXComponent> clazz, boolean appendTree, String ... names) throws WXException {
        boolean result = true;
        for (String name : names) {
            result = result && WXComponentRegistry.registerComponent(name, clazz, appendTree);
        }
        return result;
    }

    public static <T extends WXModule> boolean registerModule(String moduleName, Class<T> moduleClass, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, new TypeModuleFactory<T>(moduleClass), global);
    }

    public static <T extends WXModule> boolean registerModuleWithFactory(String moduleName, DestroyableModuleFactory factory, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, factory, global);
    }

    private static <T extends WXModule> boolean registerModule(String moduleName, ModuleFactory factory, boolean global) throws WXException {
        return WXModuleManager.registerModule(moduleName, factory, global);
    }

    public static boolean registerModule(String moduleName, Class<? extends WXModule> moduleClass) throws WXException {
        return WXSDKEngine.registerModule(moduleName, moduleClass, false);
    }

    public static boolean registerDomObject(String type, Class<? extends WXDomObject> clazz) throws WXException {
        return WXDomRegistry.registerDomObject(type, clazz);
    }

    public static void callback(String instanceId, String funcId, Map<String, Object> data) {
        WXSDKManager.getInstance().callback(instanceId, funcId, data);
    }

    public static void restartBridge(boolean debug) {
        WXEnvironment.sDebugMode = debug;
        WXSDKManager.getInstance().restartBridge();
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz) throws WXException {
        return WXComponentRegistry.registerComponent(type, clazz, true);
    }

    public static boolean registerComponent(Map<String, String> componentInfo, Class<? extends WXComponent> clazz) throws WXException {
        return WXComponentRegistry.registerComponent(componentInfo, clazz);
    }

    public static void addCustomOptions(String key, String value) {
        WXEnvironment.addCustomOptions(key, value);
    }

    public static IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return WXSDKManager.getInstance().getIWXUserTrackAdapter();
    }

    public static void setIWXUserTrackAdapter(IWXUserTrackAdapter IWXUserTrackAdapter2) {
        WXSDKManager.getInstance().setIWXUserTrackAdapter(IWXUserTrackAdapter2);
    }

    public static IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public static void setIWXImgLoaderAdapter(IWXImgLoaderAdapter IWXImgLoaderAdapter2) {
        if (IWXImgLoaderAdapter2 == null) {
            if (WXEnvironment.isApkDebugable()) {
                throw new IllegalStateException("ImageLoaderAdapter can not be set to null");
            }
            return;
        }
        WXSDKManager.getInstance().setIWXImgLoaderAdapter(IWXImgLoaderAdapter2);
    }

    public static IWXHttpAdapter getIWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public static void setIWXHttpAdapter(IWXHttpAdapter IWXHttpAdapter2) {
        WXSDKManager.getInstance().setIWXHttpAdapter(IWXHttpAdapter2);
    }

    public static IActivityNavBarSetter getActivityNavBarSetter() {
        return WXSDKManager.getInstance().getActivityNavBarSetter();
    }

    public static void setActivityNavBarSetter(IActivityNavBarSetter activityNavBarSetter) {
        WXSDKManager.getInstance().setActivityNavBarSetter(activityNavBarSetter);
    }

    public static void show3DLayer(boolean show) {
        WXEnvironment.sShow3DLayer = show;
    }

    public static void switchDebugModel(boolean debug, String debugUrl) {
        if (!WXEnvironment.isApkDebugable()) {
            return;
        }
        if (debug) {
            WXEnvironment.sDebugMode = true;
            WXEnvironment.sDebugWsUrl = debugUrl;
            try {
                Class<?> cls = Class.forName("com.taobao.weex.WXDebugTool");
                Method m = cls.getMethod("connect", String.class);
                m.invoke(cls, debugUrl);
            }
            catch (Exception e) {
                Log.d((String)"weex", (String)"WXDebugTool not found!");
            }
        } else {
            WXEnvironment.sDebugMode = false;
            WXEnvironment.sDebugWsUrl = null;
            try {
                Class<?> cls = Class.forName("com.taobao.weex.WXDebugTool");
                Method m = cls.getMethod("close", new Class[0]);
                m.invoke(cls, new Object[0]);
            }
            catch (Exception e) {
                Log.d((String)"weex", (String)"WXDebugTool not found!");
            }
        }
    }

    static {
        mLock = new Object();
    }

    public static abstract class DestroyableModuleFactory<T extends DestroyableModule>
    extends TypeModuleFactory<T> {
        public DestroyableModuleFactory(Class<T> clz) {
            super(clz);
        }
    }

    public static abstract class DestroyableModule
    extends WXModule
    implements Destroyable {
    }
}

