/**
 * Apache License Version 2.0, January 2004 http://www.apache.org/licenses/ TERMS AND CONDITIONS FOR
 * USE, REPRODUCTION, AND DISTRIBUTION 1. Definitions. "License" shall mean the terms and conditions
 * for use, reproduction, and distribution as defined by Sections 1 through 9 of this document.
 * "Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is
 * granting the License. "Legal Entity" shall mean the union of the acting entity and all other
 * entities that control, are controlled by, or are under common control with that entity. For the
 * purposes of this definition, "control" means (i) the power, direct or indirect, to cause the
 * direction or management of such entity, whether by contract or otherwise, or (ii) ownership of
 * fifty percent (50%) or more of the outstanding shares, or (iii) beneficial ownership of such
 * entity. "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted
 * by this License. "Source" form shall mean the preferred form for making modifications, including
 * but not limited to software source code, documentation source, and configuration files. "Object"
 * form shall mean any form resulting from mechanical transformation or translation of a Source
 * form, including but not limited to compiled object code, generated documentation, and conversions
 * to other media types. "Work" shall mean the work of authorship, whether in Source or Object form,
 * made available under the License, as indicated by a copyright notice that is included in or
 * attached to the work (an example is provided in the Appendix below). "Derivative Works" shall
 * mean any work, whether in Source or Object form, that is based on (or derived from) the Work and
 * for which the editorial revisions, annotations, elaborations, or other modifications represent,
 * as a whole, an original work of authorship. For the purposes of this License, Derivative Works
 * shall not include works that remain separable from, or merely link (or bind by name) to the
 * interfaces of, the Work and Derivative Works thereof. "Contribution" shall mean any work of
 * authorship, including the original version of the Work and any modifications or additions to that
 * Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in
 * the Work by the copyright owner or by an individual or Legal Entity authorized to submit on
 * behalf of the copyright owner. For the purposes of this definition, "submitted" means any form of
 * electronic, verbal, or written communication sent to the Licensor or its representatives,
 * including but not limited to communication on electronic mailing lists, source code control
 * systems, and issue tracking systems that are managed by, or on behalf of, the Licensor for the
 * purpose of discussing and improving the Work, but excluding communication that is conspicuously
 * marked or otherwise designated in writing by the copyright owner as "Not a Contribution."
 * "Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a
 * Contribution has been received by Licensor and subsequently incorporated within the Work. 2.
 * Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor
 * hereby grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 * copyright license to reproduce, prepare Derivative Works of, publicly display, publicly perform,
 * sublicense, and distribute the Work and such Derivative Works in Source or Object form. 3. Grant
 * of Patent License. Subject to the terms and conditions of this License, each Contributor hereby
 * grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable (except
 * as stated in this section) patent license to make, have made, use, offer to sell, sell, import,
 * and otherwise transfer the Work, where such license applies only to those patent claims
 * licensable by such Contributor that are necessarily infringed by their Contribution(s) alone or
 * by combination of their Contribution(s) with the Work to which such Contribution(s) was
 * submitted. If You institute patent litigation against any entity (including a cross-claim or
 * counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within the Work
 * constitutes direct or contributory patent infringement, then any patent licenses granted to You
 * under this License for that Work shall terminate as of the date such litigation is filed. 4.
 * Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof
 * in any medium, with or without modifications, and in Source or Object form, provided that You
 * meet the following conditions: (a) You must give any other recipients of the Work or Derivative
 * Works a copy of this License; and (b) You must cause any modified files to carry prominent
 * notices stating that You changed the files; and (c) You must retain, in the Source form of any
 * Derivative Works that You distribute, all copyright, patent, trademark, and attribution notices
 * from the Source form of the Work, excluding those notices that do not pertain to any part of the
 * Derivative Works; and (d) If the Work includes a "NOTICE" text file as part of its distribution,
 * then any Derivative Works that You distribute must include a readable copy of the attribution
 * notices contained within such NOTICE file, excluding those notices that do not pertain to any
 * part of the Derivative Works, in at least one of the following places: within a NOTICE text file
 * distributed as part of the Derivative Works; within the Source form or documentation, if provided
 * along with the Derivative Works; or, within a display generated by the Derivative Works, if and
 * wherever such third-party notices normally appear. The contents of the NOTICE file are for
 * informational purposes only and do not modify the License. You may add Your own attribution
 * notices within Derivative Works that You distribute, alongside or as an addendum to the NOTICE
 * text from the Work, provided that such additional attribution notices cannot be construed as
 * modifying the License. You may add Your own copyright statement to Your modifications and may
 * provide additional or different license terms and conditions for use, reproduction, or
 * distribution of Your modifications, or for any such Derivative Works as a whole, provided Your
 * use, reproduction, and distribution of the Work otherwise complies with the conditions stated in
 * this License. 5. Submission of Contributions. Unless You explicitly state otherwise, any
 * Contribution intentionally submitted for inclusion in the Work by You to the Licensor shall be
 * under the terms and conditions of this License, without any additional terms or conditions.
 * Notwithstanding the above, nothing herein shall supersede or modify the terms of any separate
 * license agreement you may have executed with Licensor regarding such Contributions. 6.
 * Trademarks. This License does not grant permission to use the trade names, trademarks, service
 * marks, or product names of the Licensor, except as required for reasonable and customary use in
 * describing the origin of the Work and reproducing the content of the NOTICE file. 7. Disclaimer
 * of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the
 * Work (and each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied, including, without limitation, any warranties
 * or conditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE.
 * You are solely responsible for determining the appropriateness of using or redistributing the
 * Work and assume any risks associated with Your exercise of permissions under this License. 8.
 * Limitation of Liability. In no event and under no legal theory, whether in tort (including
 * negligence), contract, or otherwise, unless required by applicable law (such as deliberate and
 * grossly negligent acts) or agreed to in writing, shall any Contributor be liable to You for
 * damages, including any direct, indirect, special, incidental, or consequential damages of any
 * character arising as a result of this License or out of the use or inability to use the Work
 * (including but not limited to damages for loss of goodwill, work stoppage, computer failure or
 * malfunction, or any and all other commercial damages or losses), even if such Contributor has
 * been advised of the possibility of such damages. 9. Accepting Warranty or Additional Liability.
 * While redistributing the Work or Derivative Works thereof, You may choose to offer, and charge a
 * fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or rights
 * consistent with this License. However, in accepting such obligations, You may act only on Your
 * own behalf and on Your sole responsibility, not on behalf of any other Contributor, and only if
 * You agree to indemnify, defend, and hold each Contributor harmless for any liability incurred by,
 * or claims asserted against, such Contributor by reason of your accepting any such warranty or
 * additional liability. END OF TERMS AND CONDITIONS APPENDIX: How to apply the Apache License to
 * your work. To apply the Apache License to your work, attach the following boilerplate notice,
 * with the fields enclosed by brackets "[]" replaced with your own identifying information. (Don't
 * include the brackets!)  The text should be enclosed in the appropriate comment syntax for the
 * file format. We also recommend that a file or class name and description of purpose be included
 * on the same "printed page" as the copyright notice for easier identification within third-party
 * archives. Copyright 2016 Alibaba Group Licensed under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable
 * law or agreed to in writing, software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License
 * for the specific language governing permissions and limitations under the License.
 */
package com.taobao.weex.ui.component;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.FrameLayout.LayoutParams;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXDomPropConstant;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.WXScrollView.WXScrollViewListener;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

//import com.taobao.weex.ui.WXRecycleImageManager;

/**
 * Component for scroller. It also support features like
 * "appear", "disappear" and "sticky"
 */
public class WXScroller extends WXVContainer implements WXScrollViewListener {

  /**
   * Map for storing appear information
   **/
  private Map<String, ConcurrentHashMap<String, AppearData>> mAppearMap = new ConcurrentHashMap<>();
  /**
   * Map for storing component that is sticky.
   **/
  private Map<String, HashMap<String, WXComponent>> mStickyMap = new HashMap<>();
  private FrameLayout mRealView;
  /**
   * Location of scrollView
   **/
  private Rect mScrollRect;

  private int mContentHeight = 0;

  public WXScroller(WXSDKInstance instance, WXDomObject node,
                    WXVContainer parent, boolean lazy) {
    super(instance, node, parent, lazy);
  }

  @Override
  public ViewGroup getRealView() {
    return mRealView;
  }

  @Override
  public ViewGroup getView() {
    return super.getView();
  }

  @Override
  public void destroy() {
    super.destroy();
    if (mAppearMap != null) {
      mAppearMap.clear();
    }
    if (mStickyMap != null) {
      mStickyMap.clear();
    }
    if (getView() != null && getView() instanceof IWXScroller) {
      ((IWXScroller) getView()).destroy();
    }
  }

  @Override
  protected MeasureOutput measure(int width, int height) {
    MeasureOutput measureOutput = new MeasureOutput();
    if (this.mOrientation == WXVContainer.HORIZONTAL) {
      int screenW = WXViewUtils.getScreenWidth(WXEnvironment.sApplication);
      int weexW = WXViewUtils.getWeexWidth(mInstanceId);
      measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? FrameLayout.LayoutParams.MATCH_PARENT
                                                                         : width;
      measureOutput.height = height;
    } else {
      int screenH = WXViewUtils.getScreenHeight(WXEnvironment.sApplication);
      int weexH = WXViewUtils.getWeexHeight(mInstanceId);
      measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? FrameLayout.LayoutParams.MATCH_PARENT
                                                                           : height;
      measureOutput.width = width;
    }
    return measureOutput;
  }

  @Override
  protected void initView() {
    String scroll;
//    if (mDomObj != null && mDomObj.attr != null) {
//      mInstance.getRecycleImageManager().setIfRecycleImage(mDomObj.attr.getIsRecycleImage());
//    }
    if (mDomObj == null || mDomObj.attr == null) {
      scroll = "vertical";
    } else {
      scroll = mDomObj.attr.getScrollDirection();
    }
    if(("horizontal").equals(scroll)){
      mOrientation = HORIZONTAL;
      mHost = new WXHorizontalScrollView(mContext);
      mRealView = new FrameLayout(mContext);
      WXHorizontalScrollView scrollView = (WXHorizontalScrollView) getView();
      scrollView.setScrollViewListener(new WXHorizontalScrollView.ScrollViewListener() {
        @Override
        public void onScrollChanged(WXHorizontalScrollView scrollView, int x, int y, int oldx, int oldy) {
          procAppear(scrollView,x,y,oldx,oldy);
        }
      });
      FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(
          LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
      scrollView.addView(mRealView, layoutParams);
      mHost.setHorizontalScrollBarEnabled(false);
    }else{
      mOrientation = VERTICAL;
      mHost = new WXScrollView(mContext, this);
      mRealView = new FrameLayout(mContext);
      WXScrollView scrollView = (WXScrollView) getView();
      scrollView.addScrollViewListener(this);
      FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(
          LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
      scrollView.addView(mRealView, layoutParams);
      mHost.setVerticalScrollBarEnabled(true);
      scrollView.addScrollViewListener(new WXScrollViewListener() {
        @Override
        public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {

        }

        @Override
        public void onScrollToBottom(WXScrollView scrollView, int x, int y) {

        }

        @Override
        public void onScrollStopped(WXScrollView scrollView, int x, int y) {
          List<OnWXScrollListener> listeners = mInstance.getWXScrollListeners();
          if(listeners!=null && listeners.size()>0){
            for (OnWXScrollListener listener : listeners) {
              if (listener != null) {
                listener.onScrollStateChanged(scrollView,x,y,OnWXScrollListener.IDLE);
              }
            }
          }
        }

        @Override
        public void onScroll(WXScrollView scrollView, int x, int y) {
          List<OnWXScrollListener> listeners = mInstance.getWXScrollListeners();
          if(listeners!=null && listeners.size()>0){
            for (OnWXScrollListener listener : listeners) {
              if (listener != null) {
                listener.onScrolled(scrollView, x, y);
              }
            }
          }
        }
      });
    }

  }

  public int getScrollY() {
    return getView() == null ? 0 : getView().getScrollY();
  }

  public int getScrollX() {
    return getView() == null ? 0 : getView().getScrollX();
  }

  public Map<String, HashMap<String, WXComponent>> getStickMap() {
    return mStickyMap;
  }

  @WXComponentProp(name = WXDomPropConstant.WX_ATTR_SHOWSCROLLBAR)
  public void setShowScrollbar(boolean show) {
    if (show) {
      if (mOrientation == VERTICAL) {
        mHost.setVerticalScrollBarEnabled(true);
      } else {
        mHost.setHorizontalScrollBarEnabled(true);
      }
    } else {
      if (mOrientation == VERTICAL) {
        mHost.setVerticalScrollBarEnabled(false);
      } else {
        mHost.setHorizontalScrollBarEnabled(false);
      }
    }
  }

  // TODO Need constrain, each container can only have one sticky child
  public void bindStickStyle(WXComponent component) {
    WXScroller scroller = component.getParentScroller();
    if (scroller == null) {
      return;
    }
    HashMap<String, WXComponent> stickyMap = mStickyMap.get(scroller
                                                                .getRef());
    if (stickyMap == null) {
      stickyMap = new HashMap<>();
    }
    if (stickyMap.containsKey(component.getRef())) {
      return;
    }
    stickyMap.put(component.getRef(), component);
    mStickyMap.put(scroller.getRef(), stickyMap);
  }

  public void unbindStickStyle(WXComponent component) {
    WXScroller scroller = component.getParentScroller();
    if (scroller == null) {
      return;
    }
    HashMap<String, WXComponent> stickyMap = mStickyMap.get(scroller
                                                                .getRef());
    if (stickyMap == null) {
      return;
    }
    stickyMap.remove(component.getRef());
  }

  /**
   * Bind appear event
   */
  public void bindAppearEvent(WXComponent component) {
    ConcurrentHashMap<String, AppearData> appearMap = mAppearMap
        .get(getRef());
    if (appearMap == null) {
      appearMap = new ConcurrentHashMap<>();
    }

    AppearData appearData = appearMap.get(component.getRef());
    if (appearData == null) {
      appearData = new AppearData();
    }
    appearData.mAppearComponent = component;
    appearData.hasAppear = true;
    appearMap.put(component.getRef(), appearData);
    mAppearMap.put(getRef(), appearMap);
  }

  /**
   * Bind disappear event
   */
  public void bindDisappearEvent(WXComponent component) {
    ConcurrentHashMap<String, AppearData> appearMap = mAppearMap
        .get(getRef());
    if (appearMap == null) {
      appearMap = new ConcurrentHashMap<>();
    }

    AppearData appearData = appearMap.get(component.getRef());
    if (appearData == null) {
      appearData = new AppearData();
    }
    appearData.mAppearComponent = component;
    appearData.hasDisappear = true;
    appearMap.put(component.getRef(), appearData);
    mAppearMap.put(getRef(), appearMap);
  }

  /**
   * Remove appear event
   */
  public void unbindAppearEvent(WXComponent component) {
    ConcurrentHashMap<String, AppearData> appearMap = mAppearMap
        .get(getView());
    if (appearMap == null) {
      return;
    }
    AppearData appearData = appearMap.get(component.getRef());
    if (appearData == null) {
      return;
    }
    appearData.hasAppear = false;
    if (!appearData.hasDisappear) {
      appearMap.remove(component.getRef());
    }
  }

  /**
   * Remove disappear event
   */
  public void unbindDisappearEvent(WXComponent component) {
    ConcurrentHashMap<String, AppearData> appearMap = mAppearMap
        .get(getView());
    if (appearMap == null) {
      return;
    }
    AppearData appearData = appearMap.get(component.getRef());
    if (appearData == null) {
      return;
    }
    appearData.hasDisappear = false;
    if (!appearData.hasAppear) {
      appearMap.remove(component.getRef());
    }
  }

  /**
   * Scroll by specified distance. Horizontal scroll is not supported now.
   * @param x horizontal distance, not support
   * @param y vertical distance. Negative for scroll to top
   */
  public void scrollBy(final int x, final int y) {
    if (getView() == null) {
      return;
    }

    getView().postDelayed(new Runnable() {

      @Override
      public void run() {
        if(mOrientation==VERTICAL){
          ((WXScrollView) getView()).smoothScrollBy(0, -y);
        }else{
          ((WXHorizontalScrollView)getView()).smoothScrollBy(-x,0);
        }
        getView().invalidate();
      }
    }, 16);

//    final WXRecycleImageManager recycleImageManager = mInstance
//        .getRecycleImageManager();
//
//    if (recycleImageManager != null && recycleImageManager.isRecycleImage()) {
//      getView().postDelayed(new Runnable() {
//
//        @Override
//        public void run() {
//          if (recycleImageManager != null && recycleImageManager.isRecycleImage()) {
//            recycleImageManager.loadImage();
//          }
//        }
//      }, 250);
//
//    }
  }

  @Override
  public void onScrollChanged(WXScrollView scrollView, int x, int y,
                              int oldx, int oldy) {
    procAppear(scrollView, x, y, oldx, oldy);
  }

  /**
   * Process event like appear and disappear
   */
  private void procAppear(View scrollView, int x, int y, int oldx,
                          int oldy) {

    String direction="";
    if(mOrientation==VERTICAL){
       direction=y-oldy>0?"up":"down";
    }else if(mOrientation==HORIZONTAL){
      direction= x-oldx>0?"right":"left";
    }


    ConcurrentHashMap<String, AppearData> appearMap = mAppearMap
        .get(mDomObj.ref);
    if (appearMap == null) {
      return;
    }
    Iterator<Entry<String, AppearData>> iterator = appearMap.entrySet()
        .iterator();
    Entry<String, AppearData> entry = null;
    AppearData appearData;
    if (mScrollRect == null) {
      mScrollRect = new Rect();
      getView().getHitRect(mScrollRect);
    }
    while (iterator.hasNext()) {
      entry = iterator.next();
      appearData = entry.getValue();
      if (!appearData.mAppear && appearData.mAppearComponent.getView().getLocalVisibleRect(mScrollRect)) {
        appearData.mAppear = true;
        if (appearData.hasAppear) {
          Map<String, Object> params = new HashMap<>();
          params.put("direction", direction);
          WXSDKManager.getInstance().fireEvent(mInstanceId, appearData.mAppearComponent.getRef(), WXEventType.APPEAR, params);
        }

      }else if(appearData.mAppear && !appearData.mAppearComponent.getView().getLocalVisibleRect(mScrollRect)){
        appearData.mAppear=false;
        if (appearData.hasDisappear) {
          Map<String, Object> params = new HashMap<>();
          params.put("direction", direction);
          WXSDKManager.getInstance().fireEvent(mInstanceId, appearData.mAppearComponent.getRef(), WXEventType.DISAPPEAR, params);
        }
      }
    }
  }

  @Override
  public void onScrollToBottom(WXScrollView scrollView, int x, int y) {

  }

  @Override
  public void onScrollStopped(WXScrollView scrollView, int x, int y) {
//    WXRecycleImageManager recycleImageManager = mInstance
//        .getRecycleImageManager();
//    if (recycleImageManager != null) {
//      recycleImageManager.loadImage();
//    }
  }

  @Override
  public void onScroll(WXScrollView scrollView, int x, int y) {

    this.onLoadMore(scrollView, x, y);
  }

  /**
   * Handle loadMore Event.when Scroller has bind loadMore Event and set the attr of loadMoreOffset
   * it will tell the JS to handle the event of onLoadMore;
   * @param scrollView  the WXScrollView
   * @param x the X direction
   * @param y the Y direction
   */
  protected void onLoadMore(WXScrollView scrollView, int x, int y) {
    try {
      String offset = mDomObj.attr.getLoadMoreOffset();

      if (TextUtils.isEmpty(offset)) {
        return;
      }

      int contentH = scrollView.getChildAt(0).getHeight();
      int scrollerH = scrollView.getHeight();
      int offScreenY = contentH - y - scrollerH;
      if (offScreenY < Integer.parseInt(offset)) {
        if (WXEnvironment.isApkDebugable()) {
          WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
        }

        if (mContentHeight != contentH) {
          WXSDKManager.getInstance().fireEvent(mInstanceId, mDomObj.ref, WXEventType.LIST_LOAD_MORE);
          mContentHeight = contentH;
        }
      }
    } catch (Exception e) {
      WXLogUtils.d("[WXScroller-onScroll] " + WXLogUtils.getStackTrace(e));
    }

  }

  static class AppearData {

    public WXComponent mAppearComponent;
    public boolean hasAppear;
    public boolean hasDisappear;
    public boolean mAppear;
  }
}
