/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import java.util.ArrayList;

public abstract class WXVContainer
extends WXComponent {
    protected ArrayList<WXComponent> mChildren;

    public WXVContainer(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected void bindImpl(View view) {
        super.bindImpl(view);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            if (view == null) {
                this.getChild(i).bindImpl(null);
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            this.getChild(i).bindImpl(((ViewGroup)view).getChildAt(i));
        }
    }

    public ViewGroup getRealView() {
        return (ViewGroup)super.getRealView();
    }

    @Override
    public void createViewImpl(WXVContainer parent, int index) {
        super.createViewImpl(parent, index);
        this.getOrCreateBorder().attachView(this.mHost);
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).createViewImpl(this, i);
        }
        this.getView().setClipToPadding(false);
    }

    public ViewGroup getView() {
        return (ViewGroup)super.getView();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mChildren != null) {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).destroy();
            }
            this.mChildren.clear();
        }
    }

    @Override
    public View detachViewAndClearPreInfo() {
        View original = super.detachViewAndClearPreInfo();
        if (this.mChildren != null) {
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                this.mChildren.get(i).detachViewAndClearPreInfo();
            }
        }
        return original;
    }

    public int childCount() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    public WXComponent getChild(int index) {
        return this.mChildren.get(index);
    }

    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    public void addChild(WXComponent child, int index) {
        int count;
        if (child == null || index < -1) {
            return;
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        int n = index = index >= (count = this.mChildren.size()) ? -1 : index;
        if (index == -1) {
            this.mChildren.add(child);
        } else {
            this.mChildren.add(index, child);
        }
        this.mDomObj.add(child.getDomObject(), index);
    }

    protected void addSubView(View child, int index) {
        if (child == null || this.getRealView() == null) {
            return;
        }
        int count = this.getRealView().getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            this.getRealView().addView(child);
        } else {
            this.getRealView().addView(child, index);
        }
    }

    public void remove(WXComponent child) {
        if (child == null || this.mChildren == null || this.mChildren.size() == 0) {
            return;
        }
        this.mChildren.remove(child);
        this.mDomObj.remove(child.mDomObj);
        if (this.getRealView() != null) {
            this.getRealView().removeView(child.getView());
        }
        child.destroy();
    }

    @Override
    public void flushView() {
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            this.getChild(i).flushView();
        }
        super.flushView();
    }
}

