/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;

public class WXShapeFeature {
    public static final int RoundShape = 0;
    public static final int RoundRectShape = 1;
    private final Matrix mMatrix = new Matrix();
    private WXDomObject mDom;
    private Shape mShape;
    private float[] mCornerRadiusArray;
    private boolean mIsRound = true;
    private volatile boolean mStrokeEnable;
    private float mStrokeWidth;
    private Paint mStrokePaint;
    private Path mStrokePath;
    private RectF mRectF;
    private View mHost;
    private boolean mHasRadius = false;

    public WXShapeFeature(Context context, View view, WXDomObject dom) {
        if (dom == null) {
            return;
        }
        this.mDom = dom;
        int strokeColor = -7829368;
        this.mHost = view;
        int type = 1;
        this.initCornerRadius();
        this.setShape(type);
        this.mStrokePaint = new Paint();
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setAntiAlias(true);
        if (this.mDom.style != null) {
            String realBgColor = this.mDom.style.getBorderColor();
            if (!TextUtils.isEmpty((CharSequence)realBgColor)) {
                strokeColor = WXResourceUtils.getColor(realBgColor);
            }
            if (strokeColor == -1) {
                strokeColor = -7829368;
            }
            this.mStrokeWidth = this.mDom.style.getBorderWidth();
            if (!WXUtils.isUndefined(this.mStrokeWidth) && this.mStrokeWidth > 0.0f) {
                this.mStrokeEnable = true;
                this.mStrokeWidth = WXViewUtils.getRealPxByWidth(this.mStrokeWidth);
                this.mStrokePaint.setStrokeWidth(this.mStrokeWidth);
            }
        }
        this.mStrokePaint.setColor(strokeColor);
        this.mStrokePath = new Path();
        this.mRectF = new RectF();
    }

    private void initCornerRadius() {
        float radius = 0.0f;
        if (this.mDom.style != null) {
            radius = this.mDom.style.getBorderRadius();
        }
        if (WXUtils.isUndefined(radius) || radius <= 0.0f) {
            this.mCornerRadiusArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            return;
        }
        this.mHasRadius = true;
        float tl = radius = WXViewUtils.getRealPxByWidth(radius);
        float bl = radius;
        float tr = radius;
        float br = radius;
        this.mCornerRadiusArray = new float[]{tl, tl, tr, tr, br, br, bl, bl};
    }

    private void setShape(int shapeType) {
        if (0 == shapeType) {
            this.mShape = new OvalShape();
            if (this.mHost instanceof ImageView) {
                ((ImageView)this.mHost).setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            }
            this.mIsRound = true;
        } else if (1 == shapeType) {
            this.mShape = new RoundRectShape(this.mCornerRadiusArray, null, null);
            this.mIsRound = false;
        }
    }

    void updateDom(WXDomObject domObject) {
        this.mDom = domObject;
    }

    public Drawable wrapDrawable(Drawable drawable) {
        int width = (int)this.mDom.getLayoutWidth();
        int height = (int)this.mDom.getLayoutHeight();
        if (0 >= width && 0 >= height || !this.hasRadius()) {
            return drawable;
        }
        Drawable innerDrawable = this.mHost instanceof ImageView ? ((ImageView)this.mHost).getDrawable() : this.mHost.getBackground();
        WrapShapeDrawable wrapShapeDrawable = innerDrawable instanceof WrapShapeDrawable ? (WrapShapeDrawable)innerDrawable : new WrapShapeDrawable(this.mShape);
        int vWidth = width;
        int vHeight = height;
        if (0 >= wrapShapeDrawable.getIntrinsicHeight() && 0 >= wrapShapeDrawable.getIntrinsicWidth()) {
            if (this.mIsRound) {
                vWidth = vHeight = Math.min(vWidth, vHeight);
            }
            wrapShapeDrawable.setIntrinsicWidth(vWidth);
            wrapShapeDrawable.setIntrinsicHeight(vHeight);
        }
        if (drawable instanceof BitmapDrawable) {
            Bitmap bm = this.getBitmap(drawable);
            if (null != bm) {
                float scale;
                int bmWidth = bm.getWidth();
                int bmHeight = bm.getHeight();
                BitmapShader bitmapShader = new BitmapShader(bm, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                float translateX = 0.0f;
                float translateY = 0.0f;
                if (bmWidth * vHeight > bmHeight * vWidth) {
                    scale = (float)vHeight / (float)bmHeight;
                    translateX = ((float)vWidth - (float)bmWidth * scale) * 0.5f;
                } else {
                    scale = (float)vWidth / (float)bmWidth;
                    translateY = ((float)vHeight - (float)bmHeight * scale) * 0.5f;
                }
                this.mMatrix.reset();
                this.mMatrix.setScale(scale, scale);
                this.mMatrix.postTranslate(translateX + 0.5f, translateY + 0.5f);
                bitmapShader.setLocalMatrix(this.mMatrix);
                wrapShapeDrawable.getPaint().setShader((Shader)bitmapShader);
            } else {
                wrapShapeDrawable.getPaint().setShader(null);
            }
        } else if (drawable instanceof ColorDrawable) {
            wrapShapeDrawable.getPaint().setShader(null);
            wrapShapeDrawable.getPaint().setColor(((ColorDrawable)drawable).getColor());
        } else {
            return drawable;
        }
        wrapShapeDrawable.invalidateSelf();
        return wrapShapeDrawable;
    }

    private boolean hasRadius() {
        return this.mHasRadius || this.mIsRound;
    }

    private Bitmap getBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        return null;
    }

    public void beforeOnLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    public void afterOnLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            if (this.mIsRound) {
                float centerX = (float)(right - left) * 0.5f;
                float centerY = (float)(bottom - top) * 0.5f;
                float radius = ((float)Math.min(right - left, bottom - top) - this.mStrokeWidth) * 0.5f;
                this.mStrokePath.addCircle(centerX, centerY, radius, Path.Direction.CCW);
            } else {
                float offset = this.mStrokeWidth * 0.5f;
                this.mRectF.set(offset, offset, (float)(right - left) - offset, (float)(bottom - top) - offset);
                this.mStrokePath.addRoundRect(this.mRectF, this.mCornerRadiusArray, Path.Direction.CCW);
            }
            if (this.mHost instanceof ImageView) {
                ((ImageView)this.mHost).setImageDrawable(((ImageView)this.mHost).getDrawable());
            } else {
                this.mHost.setBackgroundDrawable(this.mHost.getBackground());
            }
        }
    }

    public void beforeOnDraw(Canvas canvas) {
    }

    public void afterOnDraw(Canvas canvas) {
        if (this.mStrokeEnable) {
            canvas.drawPath(this.mStrokePath, this.mStrokePaint);
        }
    }

    private static class WrapShapeDrawable
    extends ShapeDrawable {
        public WrapShapeDrawable() {
        }

        public WrapShapeDrawable(Shape s) {
            super(s);
        }
    }
}

