/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.IWXUpdateComponent;
import com.taobao.weex.ui.view.WXShapeFeature;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;

public class WXImageView
extends ImageView
implements IWXUpdateComponent,
WXGestureObservable {
    private WXShapeFeature mImageShapeFeature;
    private WXGesture wxGesture;

    public WXImageView(Context context, WXDomObject element) {
        super(context);
        this.mImageShapeFeature = new WXShapeFeature(this.getContext(), (View)this, element);
    }

    @Override
    public void updateDom(WXDomObject domObject) {
        this.mImageShapeFeature.updateDom(domObject);
    }

    public void setImageResource(int resId) {
        Drawable drawable = this.getResources().getDrawable(resId);
        drawable = this.mImageShapeFeature.wrapDrawable(drawable);
        super.setImageDrawable(drawable);
    }

    public void setImageDrawable(Drawable drawable) {
        drawable = this.mImageShapeFeature.wrapDrawable(drawable);
        super.setImageDrawable(drawable);
    }

    protected void onDraw(Canvas canvas) {
        this.mImageShapeFeature.beforeOnDraw(canvas);
        super.onDraw(canvas);
        this.mImageShapeFeature.afterOnDraw(canvas);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mImageShapeFeature.beforeOnLayout(changed, left, top, right, bottom);
        super.onLayout(changed, left, top, right, bottom);
        this.mImageShapeFeature.afterOnLayout(changed, left, top, right, bottom);
    }

    public void setBackgroundResource(int resid) {
        Drawable drawable = this.getResources().getDrawable(resid);
        drawable = this.mImageShapeFeature.wrapDrawable(drawable);
        super.setBackgroundDrawable(drawable);
    }

    public void setBackgroundDrawable(Drawable d) {
        Drawable drawable = d;
        if (this.mImageShapeFeature != null) {
            this.mImageShapeFeature.wrapDrawable(d);
        }
        super.setBackgroundDrawable(drawable);
    }
}

