/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.view.View;
import com.taobao.weex.ui.view.WXBackgroundDrawable;

public class WXBorder {
    private WXBackgroundDrawable mBackgroundDrawable;
    private View mHost;

    public void attachView(View host) {
        this.mHost = host;
    }

    public void detachView() {
        this.mHost = null;
    }

    public void setBackgroundColor(int color) {
        if (this.mHost == null) {
            return;
        }
        if (color != 0 || this.mBackgroundDrawable != null) {
            this.getOrCreateViewBackground().setColor(color);
        }
    }

    private WXBackgroundDrawable getOrCreateViewBackground() {
        if (this.mBackgroundDrawable == null) {
            this.mBackgroundDrawable = new WXBackgroundDrawable();
            Drawable backgroundDrawable = this.mHost.getBackground();
            this.mHost.setBackgroundDrawable(null);
            if (backgroundDrawable == null) {
                this.mHost.setBackgroundDrawable((Drawable)this.mBackgroundDrawable);
            } else {
                LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, backgroundDrawable});
                this.mHost.setBackgroundDrawable((Drawable)layerDrawable);
            }
        }
        return this.mBackgroundDrawable;
    }

    public void setTranslucentBackgroundDrawable(Drawable background) {
        if (this.mHost == null) {
            return;
        }
        this.mHost.setBackgroundDrawable(null);
        if (this.mBackgroundDrawable != null && background != null) {
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{this.mBackgroundDrawable, background});
            this.mHost.setBackgroundDrawable((Drawable)layerDrawable);
        } else if (background != null) {
            this.mHost.setBackgroundDrawable(background);
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mHost == null) {
            return;
        }
        this.getOrCreateViewBackground().setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color) {
        if (this.mHost == null) {
            return;
        }
        this.getOrCreateViewBackground().setBorderColor(position, color);
    }

    public void setBorderRadius(int position, float borderRadius) {
        if (this.mHost == null) {
            return;
        }
        this.getOrCreateViewBackground().setRadius(borderRadius, position);
    }

    public void setBorderRadius(float borderRadius) {
        if (this.mHost == null) {
            return;
        }
        this.getOrCreateViewBackground().setRadius(borderRadius);
    }

    public void setBorderStyle(String style) {
        if (this.mHost == null) {
            return;
        }
        this.getOrCreateViewBackground().setBorderStyle(style);
    }
}

