/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.WXTagSpan;
import com.taobao.weex.dom.flex.CSSConstants;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.dom.flex.MeasureOutput;
import com.taobao.weex.ui.component.WXTextDecoration;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WXTextDomObject
extends WXDomObject {
    public static final int UNSET = -1;
    private static final String XIAO_MI = "xiaomi";
    private static final int XIAOMI_ABOVE_750_WIDTH_DELTA = 14;
    private static final int XIAOMI_BELOW_750_WIDTH_DELTA = 8;
    private static final int XIAOMI_HEIGHT_THRESHOLD = 6;
    private static final TextPaint sTextPaintInstance = new TextPaint();
    private static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

        @Override
        public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
            float desiredWidth;
            WXTextDomObject textDomObject = (WXTextDomObject)node;
            TextPaint textPaint = sTextPaintInstance;
            Spanned text = textDomObject.mPreparedSpannedText;
            if (text == null) {
                return;
            }
            BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
            float f = desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
            if (CSSConstants.isUndefined(width)) {
                width = node.cssstyle.maxWidth;
            }
            Object layout = boring == null && (CSSConstants.isUndefined(width) || !CSSConstants.isUndefined(desiredWidth) && desiredWidth <= width) ? new StaticLayout((CharSequence)text, textPaint, (int)Math.ceil(desiredWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true) : (boring != null && (CSSConstants.isUndefined(width) || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)true) : new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true));
            measureOutput.height = layout.getHeight();
            measureOutput.width = layout.getWidth();
            if (textDomObject.mNumberOfLines != -1 && textDomObject.mNumberOfLines < layout.getLineCount()) {
                measureOutput.height = layout.getLineBottom(textDomObject.mNumberOfLines - 1);
            }
            if (textDomObject.mLineHeight != -1) {
                int lines = textDomObject.mNumberOfLines != -1 ? Math.min(textDomObject.mNumberOfLines, layout.getLineCount()) : layout.getLineCount();
                float lineHeight = textDomObject.mLineHeight;
                measureOutput.height = lineHeight * (float)lines;
            }
            measureOutput.height = measureOutput.height + (float)layout.getTopPadding() - (float)layout.getBottomPadding();
            this.processXiaoMiModel(measureOutput, width, layout.getLineCount() == 0 ? 0.0f : measureOutput.height / (float)layout.getLineCount(), layout.getLineCount());
        }

        private void processXiaoMiModel(MeasureOutput measureOutput, float outerWidth, float lineHeight, float lineCount) {
            String manufacturer = Build.MANUFACTURER.toLowerCase();
            if (TextUtils.equals((CharSequence)WXTextDomObject.XIAO_MI, (CharSequence)manufacturer)) {
                this.processXiaoMiHeight(lineHeight, lineCount, measureOutput);
                if (WXViewUtils.getScreenWidth() < WXEnvironment.sDeafultWidth) {
                    this.processXiaoMiWidth(measureOutput, outerWidth, 8);
                } else {
                    this.processXiaoMiWidth(measureOutput, outerWidth, 14);
                }
            }
        }

        private void processXiaoMiHeight(float lineHeight, float lineCount, MeasureOutput measureOutput) {
            if (lineHeight != 0.0f && lineCount != 0.0f) {
                measureOutput.height = lineCount < 6.0f ? (measureOutput.height += lineCount / 6.0f * lineHeight) : (measureOutput.height += lineHeight);
            }
        }

        private void processXiaoMiWidth(MeasureOutput measureOutput, float outerWidth, int widthDelta) {
            float width_pixel = measureOutput.width + (float)widthDelta;
            measureOutput.width = Float.isNaN(outerWidth) ? width_pixel : (outerWidth > width_pixel ? width_pixel : outerWidth);
        }
    };
    public Spanned mPreparedSpannedText;
    protected int mNumberOfLines = -1;
    protected int mFontSize = -1;
    private int mLineHeight = -1;
    private boolean mIsColorSet = false;
    private int mColor;
    private boolean mIsBackgroundColorSet = false;
    private int mBackgroundColor;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    private String mFontFamily = null;
    private String mText = null;
    private WXTextDecoration mTextDecoration = WXTextDecoration.NONE;

    public WXTextDomObject() {
        this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
    }

    @Override
    public void layoutBefore() {
        this.initData();
        this.mPreparedSpannedText = WXTextDomObject.fromTextCSSNode(this);
        super.dirty();
        super.layoutBefore();
    }

    @Override
    public Object getExtra() {
        return this.mPreparedSpannedText;
    }

    @Override
    public void updateAttr(Map<String, Object> attrs) {
        super.updateAttr(attrs);
        if (attrs.containsKey("value")) {
            this.mText = WXAttr.getValue(attrs);
        }
    }

    @Override
    public void updateStyle(Map<String, Object> styles) {
        super.updateStyle(styles);
        this.update(styles);
    }

    @Override
    public WXTextDomObject clone() {
        WXTextDomObject dom;
        block4: {
            dom = null;
            try {
                dom = new WXTextDomObject();
                if (this.cssstyle != null) {
                    dom.cssstyle.copy(this.cssstyle);
                }
                dom.ref = this.ref;
                dom.type = this.type;
                dom.style = this.style;
                dom.attr = this.attr;
                WXEvent wXEvent = dom.event = this.event == null ? null : this.event.clone();
                if (this.csslayout != null) {
                    dom.csslayout.copy(this.csslayout);
                }
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("WXTextDomObject clone error: " + WXLogUtils.getStackTrace(e));
            }
        }
        dom.mPreparedSpannedText = this.mPreparedSpannedText;
        return dom;
    }

    private void initData() {
        this.update(this.style);
        if (this.attr != null) {
            this.mText = WXAttr.getValue(this.attr);
        }
    }

    protected static final Spanned fromTextCSSNode(WXTextDomObject textCSSNode) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        WXTextDomObject.buildSpannedFromTextCSSNode(textCSSNode, sb, ops);
        if (textCSSNode.mFontSize == -1) {
            sb.setSpan((Object)new AbsoluteSizeSpan(32), 0, sb.length(), 17);
        }
        for (int i = ops.size() - 1; i >= 0; --i) {
            SetSpanOperation op = (SetSpanOperation)ops.get(i);
            op.execute(sb);
        }
        return sb;
    }

    private void update(Map<String, Object> style) {
        if (style != null) {
            int lines;
            if (style.containsKey("lines") && (lines = WXStyle.getLines(style)) > 0) {
                this.mNumberOfLines = lines;
            }
            if (style.containsKey("fontSize")) {
                this.mFontSize = WXStyle.getFontSize(style);
            }
            if (style.containsKey("fontWeight")) {
                this.mFontWeight = WXStyle.getFontWeight(style);
            }
            if (style.containsKey("fontStyle")) {
                this.mFontStyle = WXStyle.getFontStyle(style);
            }
            if (style.containsKey("color")) {
                this.mColor = WXResourceUtils.getColor(WXStyle.getTextColor(style));
                boolean bl = this.mIsColorSet = this.mColor != Integer.MIN_VALUE;
            }
            if (style.containsKey("textDecoration")) {
                this.mTextDecoration = WXStyle.getTextDecoration(style);
            }
            if (style.containsKey("fontFamily")) {
                this.mFontFamily = WXStyle.getFontFamily(style);
            }
        }
    }

    private static final void buildSpannedFromTextCSSNode(WXTextDomObject textCSSNode, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int end;
        int start = sb.length();
        if (textCSSNode.mText != null) {
            sb.append((CharSequence)textCSSNode.mText);
        }
        if ((end = sb.length()) >= start) {
            if (textCSSNode.mTextDecoration == WXTextDecoration.UNDERLINE) {
                ops.add(new SetSpanOperation(start, end, new UnderlineSpan()));
            }
            if (textCSSNode.mTextDecoration == WXTextDecoration.LINETHROUGH) {
                ops.add(new SetSpanOperation(start, end, new StrikethroughSpan()));
            }
            if (textCSSNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(textCSSNode.mColor)));
            }
            if (textCSSNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new BackgroundColorSpan(textCSSNode.mBackgroundColor)));
            }
            if (textCSSNode.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(textCSSNode.mFontSize)));
            }
            if (textCSSNode.mFontStyle != -1 || textCSSNode.mFontWeight != -1 || textCSSNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new WXCustomStyleSpan(textCSSNode.mFontStyle, textCSSNode.mFontWeight, textCSSNode.mFontFamily)));
            }
            ops.add(new SetSpanOperation(start, end, new WXTagSpan(textCSSNode.ref)));
        }
    }

    static {
        sTextPaintInstance.setFlags(1);
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected Object what;

        SetSpanOperation(int start, int end, Object what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            sb.setSpan(this.what, this.start, this.end, spanFlags);
        }
    }
}

