/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.utils;

import com.taobao.weex.utils.WXHack.HackDeclaration.HackAssertionException;
import com.taobao.weex.utils.WXInterception.InterceptionHandler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class WXHack {

  private static AssertionFailureHandler sFailureHandler;

  private WXHack() {
  }

  public static <T> HackedClass<T> into(final Class<T> clazz) {
    return new HackedClass<T>(clazz);
  }

  @SuppressWarnings({"rawtypes", "unchecked"})
  public static <T> HackedClass<T> into(final String class_name) throws HackAssertionException {
    try {
      return new HackedClass(Class.forName(class_name));
    } catch (final ClassNotFoundException e) {
      fail(new HackAssertionException(e));
      return new HackedClass(null);    // TODO: Better solution to avoid null?
    }
  }

  private static void fail(HackAssertionException e) throws HackAssertionException {
    if (sFailureHandler == null || !sFailureHandler.onAssertionFailure(e)) {
      throw e;
    }
  }

  /**
   * Specify a handler to deal with assertion failure, and decide whether the failure should be thrown.
   */
  public static void setAssertionFailureHandler(AssertionFailureHandler handler) {
    sFailureHandler = handler;
  }

  /**
   * Use {@link WXHack#setAssertionFailureHandler(AssertionFailureHandler) } to set the global handler
   */
  public interface AssertionFailureHandler {

    /**
     * @return whether the failure is handled and no need to throw out, return false to let it thrown
     */
    boolean onAssertionFailure(HackAssertionException failure);
  }


  public static abstract class HackDeclaration {

    /**
     * This exception is purposely defined as "protected" and not extending Exception to avoid
     * developers unconsciously catch it outside the centralized hacks declaration, which results
     * in potentially pre-checked usage of hacks.
     */
    public static class HackAssertionException extends Throwable {

      private static final long serialVersionUID = 1L;
      private Class<?> mHackedClass;
      private String mHackedFieldName;
      private String mHackedMethodName;

      public HackAssertionException(final String e) {
        super(e);
      }

      public HackAssertionException(final Exception e) {
        super(e);
      }

      @Override
      public String toString() {
        return getCause() != null ? getClass().getName() + ": " + getCause() : super.toString();
      }

      public Class<?> getHackedClass() {
        return mHackedClass;
      }

      public void setHackedClass(Class<?> mHackedClass) {
        this.mHackedClass = mHackedClass;
      }

      public String getHackedMethodName() {
        return mHackedMethodName;
      }

      public void setHackedMethodName(String methodName) {
        this.mHackedMethodName = methodName;
      }

      public String getHackedFieldName() {
        return mHackedFieldName;
      }

      public void setHackedFieldName(String fieldName) {
        this.mHackedFieldName = fieldName;
      }
    }
  }


  public static class HackedField<C, T> {

    private final Field mField;


    HackedField(final Class<C> clazz, final String name, int modifiers) throws HackAssertionException {
      Field field = null;
      try {
        if (clazz == null) {
          return;
        }
        field = clazz.getDeclaredField(name);
        if (modifiers > 0 && (field.getModifiers() & modifiers) != modifiers) {
          fail(new HackAssertionException(field + " does not match modifiers: " + modifiers));
        }
        field.setAccessible(true);
      } catch (final NoSuchFieldException e) {
        HackAssertionException hae = new HackAssertionException(e);
        hae.setHackedClass(clazz);
        hae.setHackedFieldName(name);
        fail(hae);
      } finally {
        mField = field;
      }
    }

    @SuppressWarnings("unchecked")        // TODO: Add more check
    public <T2> HackedField<C, T2> ofGenericType(final Class<?> type) throws HackAssertionException {
      if (mField != null && !type.isAssignableFrom(mField.getType())) {
        fail(new HackAssertionException(new ClassCastException(mField + " is not of type " + type)));
      }
      return (HackedField<C, T2>) this;
    }

    @SuppressWarnings("unchecked")
    public HackedField<C, T> ofType(final String type_name) throws HackAssertionException {
      try {
        return (HackedField<C, T>) ofType(Class.forName(type_name));
      } catch (final ClassNotFoundException e) {
        fail(new HackAssertionException(e));
        return this;
      }
    }

    @SuppressWarnings("unchecked")
    public <T2> HackedField<C, T2> ofType(final Class<T2> type) throws HackAssertionException {
      if (mField != null && !type.isAssignableFrom(mField.getType())) {
        fail(new HackAssertionException(new ClassCastException(mField + " is not of type " + type)));
      }
      return (HackedField<C, T2>) this;
    }


    public void hijack(final C instance, final InterceptionHandler<?> handler) {
      final Object delegatee = get(instance);
      if (delegatee == null) {
        throw new IllegalStateException("Cannot hijack null");
      }
      final Class<?>[] interfaces = delegatee.getClass().getInterfaces();
      set(instance, WXInterception.proxy(delegatee, handler, interfaces));
    }

    /**
     * Get current value of this field
     */
    public T get(final C instance) {
      try {
        @SuppressWarnings("unchecked") final T value = (T) mField.get(instance);
        return value;
      } catch (final IllegalAccessException e) {
        e.printStackTrace();
        //TBS.Ext.commitEvent("AtlasRuntimeException", AtlasConstant.ATLAS_RUNTIME_EXCEPTION, e.toString());
        return null; /* Should never happen */
      }
    }


    public void set(final C instance, final Object value) {
      try {
        mField.set(instance, value);
      } catch (final IllegalAccessException e) {
        e.printStackTrace();
        //                if(value instanceof DelegateClassLoader){
        //                    throw new RuntimeException("set DelegateClassLoader fail",e);
        //                }
                /* Should never happen */
      }
    }

    public Field getField() {
      return mField;
    }
  }

  public static class HackedMethod {

    protected final Method mMethod;

    HackedMethod(final Class<?> clazz, final String name, final Class<?>[] arg_types, int modifiers) throws HackAssertionException {
      Method method = null;
      try {
        if (clazz == null) {
          return;
        }
        method = clazz.getDeclaredMethod(name, arg_types);
        if (modifiers > 0 && (method.getModifiers() & modifiers) != modifiers) {
          fail(new HackAssertionException(method + " does not match modifiers: " + modifiers));
        }
        method.setAccessible(true);
      } catch (final NoSuchMethodException e) {
        HackAssertionException hae = new HackAssertionException(e);
        hae.setHackedClass(clazz);
        hae.setHackedMethodName(name);
        fail(hae);
      } finally {
        mMethod = method;
      }
    }

    public Object invoke(final Object receiver, final Object... args) throws IllegalArgumentException, InvocationTargetException {
      Object obj = null;
      try {
        obj = mMethod.invoke(receiver, args);
        return obj;
      } catch (final IllegalAccessException e) { /* Should never happen */
        e.printStackTrace();
      }
      return obj;
    }

    public Method getMethod() {
      return mMethod;
    }
  }

  public static class HackedConstructor {

    protected Constructor<?> mConstructor;

    HackedConstructor(final Class<?> clazz, final Class<?>[] arg_types) throws HackAssertionException {
      try {
        if (clazz == null) {
          return;
        }
        mConstructor = clazz.getDeclaredConstructor(arg_types);
      } catch (NoSuchMethodException e) {
        HackAssertionException hae = new HackAssertionException(e);
        hae.setHackedClass(clazz);
        fail(hae);
      }
    }

    public Object getInstance(final Object... arg_types) throws IllegalArgumentException {
      Object obj = null;
      mConstructor.setAccessible(true);
      try {
        obj = mConstructor.newInstance(arg_types);
      } catch (Exception e) {
        e.printStackTrace();
      }
      return obj;
    }
  }

  public static class HackedClass<C> {

    protected Class<C> mClass;

    public HackedClass(final Class<C> clazz) {
      mClass = clazz;
    }

    public HackedField<C, Object> staticField(final String name) throws HackAssertionException {
      return new HackedField<C, Object>(mClass, name, Modifier.STATIC);
    }

    public HackedField<C, Object> field(final String name) throws HackAssertionException {
      return new HackedField<C, Object>(mClass, name, 0);
    }

    public HackedMethod staticMethod(final String name, final Class<?>... arg_types) throws HackAssertionException {
      return new HackedMethod(mClass, name, arg_types, Modifier.STATIC);
    }

    public HackedMethod method(final String name, final Class<?>... arg_types) throws HackAssertionException {
      return new HackedMethod(mClass, name, arg_types, 0);
    }

    public HackedConstructor constructor(final Class<?>... arg_types) throws HackAssertionException {
      return new HackedConstructor(mClass, arg_types);
    }

    public Class<C> getmClass() {
      return mClass;
    }
  }
}
