/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.utils.WXLogUtils;

public class WXViewUtils {
    public static final int TRANSLUCENT = -3;
    public static final int TRANSPARENT = -2;
    public static final int OPAQUE = -1;
    private static final boolean mUseWebPx = false;
    private static int mScreenHeight = 0;
    private static int mScreenWidth = 0;

    public static int getWeexHeight(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexHeight = instance.getWeexHeight();
            if (weexHeight >= 0 || weexHeight == -2) {
                return weexHeight;
            }
            return WXViewUtils.getScreenHeight();
        }
        return -3;
    }

    public static int getScreenHeight() {
        return mScreenHeight > 0 ? mScreenHeight : WXEnvironment.sApplication.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getWeexWidth(String instanceId) {
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            int weexWidth = instance.getWeexWidth();
            if (weexWidth >= 0 || weexWidth == -2) {
                return weexWidth;
            }
            return WXViewUtils.getScreenWidth();
        }
        return -3;
    }

    public static int getScreenWidth() {
        return mScreenWidth > 0 ? mScreenWidth : WXEnvironment.sApplication.getResources().getDisplayMetrics().widthPixels;
    }

    public static float getRealPxByWidth(float pxValue) {
        if (Float.isNaN(pxValue)) {
            return pxValue;
        }
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)WXEnvironment.sDeafultWidth;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : (float)Math.rint(realPx);
    }

    public static int getRealPxByWidth2(float pxValue) {
        float realPx = pxValue * (float)WXViewUtils.getScreenWidth() / (float)WXEnvironment.sDeafultWidth;
        return (double)realPx > 0.005 && realPx < 1.0f ? 1 : (int)realPx - 1;
    }

    public static float getWebPxByWidth(float pxValue) {
        if ((double)pxValue < -1.9999 && (double)pxValue > -2.005) {
            return Float.NaN;
        }
        float realPx = pxValue * (float)WXEnvironment.sDeafultWidth / (float)WXViewUtils.getScreenWidth();
        return (double)realPx > 0.005 && realPx < 1.0f ? 1.0f : realPx;
    }

    public static int dip2px(float dpValue) {
        float scale = 2.0f;
        try {
            scale = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
        }
        catch (Exception e) {
            WXLogUtils.e("[WXViewUtils] dip2px:" + WXLogUtils.getStackTrace(e));
        }
        float finalPx = dpValue * scale + 0.5f;
        return finalPx > 0.0f && finalPx < 1.0f ? 1 : (int)finalPx;
    }

    public static boolean onScreenArea(View view) {
        if (view == null || view.getVisibility() != 0) {
            return false;
        }
        int[] p = new int[2];
        view.getLocationOnScreen(p);
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        int viewH = 0;
        viewH = lp != null ? lp.height : view.getHeight();
        return p[1] > 0 && p[1] - WXViewUtils.getScreenHeight() < 0 || viewH + p[1] > 0 && p[1] <= 0;
    }

    public static int multiplyColorAlpha(int color, int alpha) {
        if (alpha == 255) {
            return color;
        }
        if (alpha == 0) {
            return color & 0xFFFFFF;
        }
        alpha += alpha >> 7;
        int colorAlpha = color >>> 24;
        int multipliedAlpha = colorAlpha * alpha >> 8;
        return multipliedAlpha << 24 | color & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int color) {
        int colorAlpha = color >>> 24;
        if (colorAlpha == 255) {
            return -1;
        }
        if (colorAlpha == 0) {
            return -2;
        }
        return -3;
    }
}

