/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.listview.BounceRecyclerView;
import com.taobao.weex.ui.view.listview.IRefreshLayout;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;

public class WXListComponent
extends WXVContainer
implements IRecyclerAdapterListener<ListBaseViewHolder>,
IOnLoadMoreListener {
    private String TAG = "WXListComponent";
    private ArrayList<Integer> indoreCells;
    private int listCellCount = 0;
    private WXRefresh mRefresh;
    private WXLoading mLoading;
    private SparseArray<WXComponent> mAppearComponents = new SparseArray();

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight();
        int weexH = WXViewUtils.getWeexHeight(this.mInstanceId);
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.mAbsoluteY : height;
        return super.measure(width, outHeight);
    }

    @Override
    protected void initView() {
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        this.mHost = new BounceRecyclerView(this.mContext);
        this.mHost.setOverScrollMode(2);
        this.getView().setAdapter(recyclerViewBaseAdapter);
        ((RecyclerView)this.getView().getBounceView()).clearOnScrollListeners();
        ((RecyclerView)this.getView().getBounceView()).addOnScrollListener((RecyclerView.OnScrollListener)new WXRecyclerViewOnScrollListener(this));
    }

    @Override
    public BounceRecyclerView getView() {
        return (BounceRecyclerView)super.getView();
    }

    @Override
    public void addChild(WXComponent child) {
        super.addChild(child);
        int index = this.mChildren.indexOf(child);
        this.getView().getAdapter().notifyItemInserted(index);
        this.checkRefreshOrLoading(child);
        if (child.getDomObject().containsEvent("appear") || child.getDomObject().containsEvent("disappear")) {
            this.mAppearComponents.put(index, (Object)child);
            child.registerAppearEvent = true;
        }
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        int adapterPosition = index == -1 ? this.getView().getAdapter().getItemCount() - 1 : index;
        this.getView().getAdapter().notifyItemInserted(adapterPosition);
        this.checkRefreshOrLoading(child);
        if (child.getDomObject().containsEvent("appear") || child.getDomObject().containsEvent("disappear")) {
            this.mAppearComponents.put(adapterPosition, (Object)child);
            child.registerAppearEvent = true;
        }
    }

    @Override
    protected void addSubView(View child, int index) {
    }

    @Override
    public void remove(WXComponent child) {
        int index = this.mChildren.indexOf(child);
        child.detachViewAndClearPreInfo();
        super.remove(child);
        this.getView().getAdapter().notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "removeChild child at " + index);
        }
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        RecyclerView view = (RecyclerView)this.getView().getBounceView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        this.recycleImage(holder.itemView);
        WXLogUtils.d(this.TAG, "Recycle holder " + (Object)((Object)holder));
    }

    @Override
    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        WXComponent component = this.getChild(position);
        if (this.indoreCells != null && this.indoreCells.contains(this.getItemViewType(position))) {
            return;
        }
        if (component != null) {
            component.bind(null);
        }
        WXLogUtils.d(this.TAG, "Bind holder " + (Object)((Object)holder));
    }

    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.indoreCells != null && this.indoreCells.contains(viewType)) {
            return this.createVHForFixedComponent();
        }
        if (this.mChildren != null) {
            for (int i = 0; i < this.childCount(); ++i) {
                WXComponent component = this.getChild(i);
                if (component == null || this.getItemViewType(i) != viewType) continue;
                if (component.isLazy()) {
                    component.lazy(false);
                    component.createView(this, -1);
                    return new ListBaseViewHolder(component.getView());
                }
                if (component instanceof WXRefresh) {
                    return this.createVHForWXRefresh(component);
                }
                if (component instanceof WXLoading) {
                    return this.createVHForWXLoading(component);
                }
                if (this.getChild(i).getView() == null) continue;
                return new ListBaseViewHolder(component.getView());
            }
            WXLogUtils.e(this.TAG, "Cannot find request viewType: " + viewType);
        }
        throw new WXRuntimeException("mChildren is null");
    }

    @Override
    public int getItemViewType(int position) {
        int itemViewType = (int)this.getView().getAdapter().getItemId(position);
        if ((long)itemViewType == -1L) {
            WXLogUtils.e(this.TAG, "getItemViewType: NO ID, this will crash the whole render system of WXListRecyclerView");
        }
        this.prepareFixedComponent(position, itemViewType);
        return itemViewType;
    }

    @Override
    public int getItemCount() {
        if (this.mChildren != null) {
            return this.mChildren.size();
        }
        return 0;
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        WXLogUtils.d(this.TAG, "Failed to recycle " + (Object)((Object)holder));
        return false;
    }

    @Override
    public long getItemId(int position) {
        long id;
        try {
            id = Long.parseLong(this.getChild((int)position).getDomObject().ref);
        }
        catch (RuntimeException e) {
            WXLogUtils.e(this.TAG, WXLogUtils.getStackTrace(e));
            id = -1L;
        }
        return id;
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            String offset = this.mDomObj.attr.getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            if (offScreenY < Integer.parseInt(offset) && this.listCellCount != this.mChildren.size()) {
                WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, "loadmore");
                this.listCellCount = this.mChildren.size();
            }
        }
        catch (Exception e) {
            WXLogUtils.d(this.TAG, "onLoadMore :" + WXLogUtils.getStackTrace(e));
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible) {
        int i;
        ArrayList<Integer> unRegisterKeys = new ArrayList<Integer>();
        int len = this.mAppearComponents.size();
        for (i = 0; i < len; ++i) {
            int key = this.mAppearComponents.keyAt(i);
            WXComponent value = (WXComponent)this.mAppearComponents.get(key);
            if (!value.registerAppearEvent) {
                unRegisterKeys.add(key);
                continue;
            }
            if (key >= firstVisible && key <= lastVisible && !value.appearState) {
                value.notifyApppearStateChange("appear");
                value.appearState = true;
            } else if ((key < firstVisible || key > lastVisible) && value.appearState) {
                value.notifyApppearStateChange("disappear");
                value.appearState = false;
            }
            WXLogUtils.d(this.TAG, "key:" + key + " " + "appear:" + value.appearState);
        }
        len = unRegisterKeys.size();
        for (i = 0; i < len; ++i) {
            this.mAppearComponents.remove(((Integer)unRegisterKeys.get(i)).intValue());
        }
    }

    public void unbindAppearComponents(WXComponent component) {
        this.mAppearComponents.remove(this.mAppearComponents.indexOfValue((Object)component));
    }

    private void checkRefreshOrLoading(WXComponent child) {
        if (child instanceof WXRefresh) {
            this.getView().setOnRefreshListener((WXRefresh)child);
            this.mRefresh = (WXRefresh)child;
        }
        if (child instanceof WXLoading) {
            this.getView().setOnLoadMoreListener((WXLoading)child);
            this.mLoading = (WXLoading)child;
        }
    }

    private void recycleImage(View view) {
        if (view instanceof ImageView) {
            this.mInstance.getImgLoaderAdapter().setImage(null, (ImageView)view, null, null);
        } else if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.recycleImage(((ViewGroup)view).getChildAt(i));
            }
        }
    }

    @NonNull
    private ListBaseViewHolder createVHForFixedComponent() {
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(-1);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
        return new ListBaseViewHolder((View)view);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXLoading(WXComponent component) {
        this.getView().setBounceFooterView(new IRefreshLayout.Adapter(component.getView()){

            @Override
            public void onPull(float scale) {
                super.onPull(scale);
                WXListComponent.this.mLoading.onPullLoadingIndicator((int)scale);
            }
        });
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(0);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder((View)view);
    }

    @NonNull
    private ListBaseViewHolder createVHForWXRefresh(WXComponent component) {
        this.getView().setBounceHeaderView(new IRefreshLayout.Adapter(component.getView()){

            @Override
            public void onPull(float scale) {
                super.onPull(scale);
                WXListComponent.this.mRefresh.onPullLoadingIndicator((int)scale);
            }
        });
        FrameLayout view = new FrameLayout(this.mContext);
        view.setBackgroundColor(0);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
        return new ListBaseViewHolder((View)view);
    }

    private void prepareFixedComponent(int position, int viewType) {
        if (((WXComponent)this.mChildren.get(position)).getDomObject().isFixed()) {
            if (this.indoreCells == null) {
                this.indoreCells = new ArrayList();
            }
            if (!this.indoreCells.contains(viewType)) {
                this.indoreCells.add(viewType);
            }
        }
    }
}

