/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.taobao.weex.ui.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;

import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXModuleAnno;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXBackgroundDrawable;
import com.taobao.weex.utils.FunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXAnimationModule extends WXModule {

  public static void applyTransformStyle(@Nullable Map<String, Object> style, WXComponent component) {
    if (component != null) {
      View target = component.getRealView();
      if (style != null && target != null) {
        Object transform = style.get("transform");
        if (transform instanceof String && !TextUtils.isEmpty((String) transform) && target.getLayoutParams() != null) {
          String transformOrigin;
          try {
            transformOrigin = (String) component.mDomObj.style.get(
                "transformOrigin");
          } catch (NullPointerException e) {
            transformOrigin = null;
          }
          WXAnimationBean animationBean = new WXAnimationBean();
          animationBean.styles = new WXAnimationBean.Style();
          animationBean.styles.setPivot(
              WXAnimationModule.parsePivot(transformOrigin, target.getLayoutParams()));
          animationBean.styles.setTransformMap(
              WXAnimationModule.parseTransForm((String) transform, target.getLayoutParams()));
          Animator animator = WXAnimationModule.createAnimator(animationBean, target);
          if (animator != null) {
            animator.setDuration(0);
            animator.start();
          }
        }
      }
    }
  }

  public static
  @Nullable
  WXAnimationBean parseAnimation(@Nullable String animation,
                                 ViewGroup.LayoutParams layoutParams) {
    try {
      WXAnimationBean animationBean =
          JSONObject.parseObject(animation, WXAnimationBean.class);
      if (animationBean != null && animationBean.styles != null) {
        WXAnimationBean.Style style = animationBean.styles;
        style.setTransformMap(parseTransForm(style.transform, layoutParams));
        style.setPivot(parsePivot(style.transformOrigin, layoutParams));
      }
      return animationBean;
    } catch (RuntimeException e) {
      WXLogUtils.e(WXLogUtils.getStackTrace(e));
      return null;
    }
  }

  public static
  @Nullable
  ObjectAnimator createAnimator(@NonNull WXAnimationBean animation, @NonNull View target) {
    WXAnimationBean.Style style = animation.styles;
    if (style != null) {
      ObjectAnimator animator;
      List<PropertyValuesHolder> holders = new LinkedList<>();
      if (style.getTransformMap() != null) {
        if (style.getTransformMap().isEmpty()) {
          holders.addAll(moveBackToOrigin());
        } else {
          for (Map.Entry<String, Float> entry : style.getTransformMap().entrySet()) {
            holders.add(PropertyValuesHolder.ofFloat(entry.getKey(), entry.getValue()));
          }
        }
      }
      if (!TextUtils.isEmpty(style.opacity)) {
        holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ALPHA,
                                                 Float.valueOf(style.opacity)));
      }
      //TODO add a wrapper class of view to not flush out the border
      if (!TextUtils.isEmpty(style.backgroundColor)) {
        if (target.getBackground() instanceof WXBackgroundDrawable) {
          holders.add(PropertyValuesHolder.ofObject(
              WXAnimationBean.Style.BACKGROUND_COLOR, new ArgbEvaluator(),
              ((WXBackgroundDrawable) target.getBackground()).getColor(),
              WXResourceUtils.getColor(style.backgroundColor)));
        } else if (target.getBackground() instanceof ColorDrawable) {
          holders.add(PropertyValuesHolder.ofObject(
              WXAnimationBean.Style.BACKGROUND_COLOR, new ArgbEvaluator(),
              ((ColorDrawable) target.getBackground()).getColor(),
              WXResourceUtils.getColor(style.backgroundColor)));
        }
      }
      if (style.getPivot() != null) {
        Pair<Float, Float> pair = style.getPivot();
        target.setPivotX(pair.first);
        target.setPivotY(pair.second);
      }
      animator = ObjectAnimator.ofPropertyValuesHolder(
          target, holders.toArray(new PropertyValuesHolder[holders.size()]));
      animator.setStartDelay(animation.delay);
      return animator;
    } else {
      return null;
    }
  }

  public static
  @Nullable
  Animator.AnimatorListener createAnimatorListener(final WXSDKInstance mWXSDKInstance, @Nullable final String callBack) {
    if (!TextUtils.isEmpty(callBack)) {
      return new AnimatorListenerAdapter() {
        @Override
        public void onAnimationEnd(Animator animation) {
          if (mWXSDKInstance == null) {
            WXLogUtils.e("WXRenderStatement-onAnimationEnd mWXSDKInstance == null NPE");
          } else {
            WXSDKManager.getInstance().callback(mWXSDKInstance.getInstanceId(),
                                                callBack,
                                                new HashMap<String, Object>());
          }
        }
      };
    } else {
      return null;
    }
  }

  public static
  @Nullable
  Interpolator createTimeInterpolator(@NonNull WXAnimationBean animation) {
    String interpolator = animation.timingFunction;
    if (!TextUtils.isEmpty(interpolator)) {
      switch (interpolator) {
        case WXAnimationBean.EASE_IN:
          return new AccelerateInterpolator();
        case WXAnimationBean.EASE_OUT:
          return new DecelerateInterpolator();
        case WXAnimationBean.EASE_IN_OUT:
          return new AccelerateDecelerateInterpolator();
        case WXAnimationBean.LINEAR:
          return new LinearInterpolator();
        //TODO Add PathInterpolator to support cubic-bezier curve
      }
    }
    return null;
  }

  private static Map<String, Float> parseTransForm(@Nullable String rawTransform, final ViewGroup.LayoutParams layoutParams) {
    if (!TextUtils.isEmpty(rawTransform)) {
      FunctionParser<Float> parser = new FunctionParser<>
          (rawTransform, new FunctionParser.Mapper<Float>() {
            @Override
            public Map<String, Float> map(String functionName, List<String> raw) {
              Map<String, Float> result = new HashMap<>();
              if (raw != null && !raw.isEmpty()) {
                if (WXAnimationBean.Style.wxToAndroidMap.containsKey(functionName)) {
                  result.putAll(convertParam(
                      layoutParams, WXAnimationBean.Style.wxToAndroidMap.get(functionName),
                      raw));
                }
              }
              return result;
            }

          });
      return parser.parse();
    }
    return new LinkedHashMap<>();
  }

  private static String parsePercentOrPx(String raw, int unit) {
    String lower = raw.toLowerCase();
    if (lower.endsWith("%")) {
      return parsePercent(raw, unit);
    } else if (lower.endsWith("px")) {
      return Float.toString(WXViewUtils.getRealPxByWidth(Float.parseFloat(raw.replace("px", ""))));
    }
    return Float.toString(WXViewUtils.getRealPxByWidth(Float.parseFloat(raw)));
  }

  private static String parsePercent(String percent, int unit) {
    return Float.toString(Float.parseFloat(percent.replace("%", "")) / 100 * unit);
  }

  private static Pair<Float, Float> parsePivot(@Nullable String transformOrigin,
                                               ViewGroup.LayoutParams layoutParams) {
    String[] split;
    List<String> list;
    if (!TextUtils.isEmpty(transformOrigin) &&
        ((split = transformOrigin.split("\\s+")).length >= 2)) {
      list = Arrays.asList(split).subList(0, 2);
      return parsePivot(list, layoutParams);
    } else {
      return parsePivot(Arrays.asList(WXAnimationBean.Style.CENTER,
                                      WXAnimationBean.Style.CENTER), layoutParams);
    }
  }

  private static Pair<Float, Float> parsePivot(@NonNull List<String> list, ViewGroup.LayoutParams layoutParams) {
    return new Pair<>(
        parsePivotX(list.get(0), layoutParams), parsePivotY(list.get(1), layoutParams));
  }

  private static float parsePivotX(String x, ViewGroup.LayoutParams layoutParams) {
    String value = x;
    if (TextUtils.equals(x, WXAnimationBean.Style.LEFT)) {
      value = "0%";
    } else if (TextUtils.equals(x, WXAnimationBean.Style.RIGHT)) {
      value = "100%";
    } else if (TextUtils.equals(x, WXAnimationBean.Style.CENTER)) {
      value = "50%";
    }
    value = parsePercentOrPx(value, layoutParams.width);
    return Float.parseFloat(value);
  }

  private static float parsePivotY(String y, ViewGroup.LayoutParams layoutParams) {
    String value = y;
    if (TextUtils.equals(y, WXAnimationBean.Style.TOP)) {
      value = "0%";
    } else if (TextUtils.equals(y, WXAnimationBean.Style.BOTTOM)) {
      value = "100%";
    } else if (TextUtils.equals(y, WXAnimationBean.Style.CENTER)) {
      value = "50%";
    }
    value = parsePercentOrPx(value, layoutParams.height);
    return Float.parseFloat(value);
  }

  private static Map<String, Float> convertParam(ViewGroup.LayoutParams layoutParams,
                                                 @NonNull List<String> nameSet,
                                                 @NonNull List<String> rawValue) {
    Map<String, Float> result = new HashMap<>();
    List<String> convertedList = new ArrayList<>();
    if (nameSet.contains(WXAnimationBean.Style.ANDROID_ROTATION)) {
      convertedList.addAll(parseRotation(rawValue));
    } else if (nameSet.contains(WXAnimationBean.Style.ANDROID_TRANSLATION_X) ||
               nameSet.contains(WXAnimationBean.Style.ANDROID_TRANSLATION_Y)) {
      convertedList.addAll(parseTranslation(nameSet, layoutParams, rawValue));
    } else if (nameSet.contains(WXAnimationBean.Style.ANDROID_SCALE_X) ||
               nameSet.contains(WXAnimationBean.Style.ANDROID_SCALE_Y)) {
      convertedList.addAll(parseScale(nameSet.size(), rawValue));
    }
    if (nameSet.size() == convertedList.size()) {
      for (int i = 0; i < nameSet.size(); i++) {
        result.put(nameSet.get(i), Float.parseFloat(convertedList.get(i)));
      }
    }
    return result;
  }

  private static List<String> parseTranslation(List<String> nameSet, ViewGroup.LayoutParams layoutParams,
                                               @NonNull List<String> rawValue) {
    List<String> convertedList = new ArrayList<>();
    String first = rawValue.get(0);
    if (nameSet.size() == 1) {
      parseSingleTranslation(nameSet, layoutParams, convertedList, first);
    } else {
      parseDoubleTranslation(layoutParams, rawValue, convertedList, first);
    }
    return convertedList;
  }

  private static void parseSingleTranslation(List<String> nameSet, ViewGroup.LayoutParams layoutParams,
                                             List<String> convertedList, String first) {
    if (nameSet.contains(WXAnimationBean.Style.ANDROID_TRANSLATION_X)) {
      convertedList.add(parsePercentOrPx(first, layoutParams.width));
    } else if (nameSet.contains(WXAnimationBean.Style.ANDROID_TRANSLATION_Y)) {
      convertedList.add(parsePercentOrPx(first, layoutParams.height));
    }
  }

  private static void parseDoubleTranslation(ViewGroup.LayoutParams layoutParams,
                                             @NonNull List<String> rawValue,
                                             List<String> convertedList, String first) {
    String second;
    if (rawValue.size() == 1) {
      second = first;
    } else {
      second = rawValue.get(1);
    }
    if (layoutParams != null) {
      convertedList.add(parsePercentOrPx(first, layoutParams.width));
      convertedList.add(parsePercentOrPx(second, layoutParams.height));
    }
  }

  private static List<String> parseScale(int size, @NonNull List<String> rawValue) {
    List<String> convertedList = new ArrayList<>();
    convertedList.addAll(rawValue);
    if (size != 1 && rawValue.size() == 1) {
      convertedList.addAll(rawValue);
    }
    return convertedList;
  }

  private static List<String> parseRotation(@NonNull List<String> rawValue) {
    List<String> convertedList = new ArrayList<>();
    String lower;
    for (String raw : rawValue) {
      lower = raw.toLowerCase();
      if (lower.endsWith("deg")) {
        convertedList.add(lower.replace("deg", ""));
      } else {
        convertedList.add(Double.valueOf(Math.toDegrees(Double.parseDouble(raw))).toString());
      }
    }
    return convertedList;
  }

  private static List<PropertyValuesHolder> moveBackToOrigin() {
    List<PropertyValuesHolder> holders = new LinkedList<>();
    holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ANDROID_TRANSLATION_X, 0));
    holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ANDROID_TRANSLATION_Y, 0));
    holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ANDROID_SCALE_X, 1));
    holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ANDROID_SCALE_Y, 1));
    holders.add(PropertyValuesHolder.ofFloat(WXAnimationBean.Style.ANDROID_ROTATION, 0));
    return holders;
  }

  @WXModuleAnno
  public void transition(String ref, String animation, String callBack) {
    WXSDKManager.getInstance().getWXRenderManager().
        startAnimation(mWXSDKInstance.getInstanceId(), ref, animation, callBack);
  }
}
