/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.WXRecycleImageManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXScroller
extends WXVContainer
implements WXScrollView.WXScrollViewListener {
    private Map<String, ConcurrentHashMap<String, AppearData>> mAppearMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, AppearData>>();
    private Map<String, HashMap<String, WXComponent>> mStickyMap = new HashMap<String, HashMap<String, WXComponent>>();
    private FrameLayout mRealView;
    private Rect mScrollRect;
    private int mContentHeight = 0;

    public WXScroller(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    public ViewGroup getRealView() {
        return this.mRealView;
    }

    @Override
    public ViewGroup getView() {
        return super.getView();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mAppearMap != null) {
            this.mAppearMap.clear();
        }
        if (this.mStickyMap != null) {
            this.mStickyMap.clear();
        }
        if (this.getView() != null && this.getView() instanceof IWXScroller) {
            ((IWXScroller)this.getView()).destroy();
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        WXComponent.MeasureOutput measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int screenW = WXViewUtils.getScreenWidth();
            int weexW = WXViewUtils.getWeexWidth(this.mInstanceId);
            measureOutput.width = width > (weexW >= screenW ? screenW : weexW) ? -1 : width;
            measureOutput.height = height;
        } else {
            int screenH = WXViewUtils.getScreenHeight();
            int weexH = WXViewUtils.getWeexHeight(this.mInstanceId);
            measureOutput.height = height > (weexH >= screenH ? screenH : weexH) ? -1 : height;
            measureOutput.width = width;
        }
        return measureOutput;
    }

    @Override
    protected void initView() {
        String scroll = this.mDomObj == null || this.mDomObj.attr == null ? "vertical" : this.mDomObj.attr.getScrollDirection();
        if (scroll.equals("vertical")) {
            this.mOrientation = 1;
            this.mHost = new WXScrollView(this.mContext, this);
            this.mRealView = new FrameLayout(this.mContext);
            WXScrollView scrollView = (WXScrollView)this.getView();
            scrollView.addScrollViewListener(this);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            this.mHost.setVerticalScrollBarEnabled(true);
        } else {
            this.mOrientation = 0;
            this.mHost = new WXHorizontalScrollView(this.mContext);
            this.mRealView = new FrameLayout(this.mContext);
            WXHorizontalScrollView scrollView = (WXHorizontalScrollView)this.getView();
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            scrollView.addView((View)this.mRealView, (ViewGroup.LayoutParams)layoutParams);
            this.mHost.setHorizontalScrollBarEnabled(true);
        }
    }

    public int getScrollY() {
        return this.getView() == null ? 0 : this.getView().getScrollY();
    }

    public int getScrollX() {
        return this.getView() == null ? 0 : this.getView().getScrollX();
    }

    public Map<String, HashMap<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (show) {
            if (this.mOrientation == 1) {
                this.mHost.setVerticalScrollBarEnabled(true);
            } else {
                this.mHost.setHorizontalScrollBarEnabled(true);
            }
        } else if (this.mOrientation == 1) {
            this.mHost.setVerticalScrollBarEnabled(false);
        } else {
            this.mHost.setHorizontalScrollBarEnabled(false);
        }
    }

    public void bindStickStyle(WXComponent component) {
        WXScroller scroller = component.getParentScroller();
        if (scroller == null) {
            return;
        }
        HashMap<String, WXComponent> stickyMap = this.mStickyMap.get(scroller.getRef());
        if (stickyMap == null) {
            stickyMap = new HashMap();
        }
        if (stickyMap.containsKey(component.getRef())) {
            return;
        }
        stickyMap.put(component.getRef(), component);
        this.mStickyMap.put(scroller.getRef(), stickyMap);
    }

    public void unbindStickStyle(WXComponent component) {
        WXScroller scroller = component.getParentScroller();
        if (scroller == null) {
            return;
        }
        HashMap<String, WXComponent> stickyMap = this.mStickyMap.get(scroller.getRef());
        if (stickyMap == null) {
            return;
        }
        stickyMap.remove(component.getRef());
    }

    public void bindAppearEvent(WXComponent component) {
        AppearData appearData;
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getRef());
        if (appearMap == null) {
            appearMap = new ConcurrentHashMap();
        }
        if ((appearData = appearMap.get(component.getRef())) == null) {
            appearData = new AppearData();
        }
        appearData.mAppearComponent = component;
        appearData.hasAppear = true;
        appearMap.put(component.getRef(), appearData);
        this.mAppearMap.put(this.getRef(), appearMap);
    }

    public void bindDisappearEvent(WXComponent component) {
        AppearData appearData;
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getRef());
        if (appearMap == null) {
            appearMap = new ConcurrentHashMap();
        }
        if ((appearData = appearMap.get(component.getRef())) == null) {
            appearData = new AppearData();
        }
        appearData.mAppearComponent = component;
        appearData.hasDisappear = true;
        appearMap.put(component.getRef(), appearData);
        this.mAppearMap.put(this.getRef(), appearMap);
    }

    public void unbindAppearEvent(WXComponent component) {
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getView());
        if (appearMap == null) {
            return;
        }
        AppearData appearData = appearMap.get(component.getRef());
        if (appearData == null) {
            return;
        }
        appearData.hasAppear = false;
        if (!appearData.hasDisappear) {
            appearMap.remove(component.getRef());
        }
    }

    public void unbindDisappearEvent(WXComponent component) {
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.getView());
        if (appearMap == null) {
            return;
        }
        AppearData appearData = appearMap.get(component.getRef());
        if (appearData == null) {
            return;
        }
        appearData.hasDisappear = false;
        if (!appearData.hasAppear) {
            appearMap.remove(component.getRef());
        }
    }

    public void scrollBy(int x, final int y) {
        if (this.getView() == null || this.mOrientation != 1) {
            return;
        }
        this.getView().postDelayed(new Runnable(){

            @Override
            public void run() {
                ((WXScrollView)WXScroller.this.getView()).smoothScrollBy(0, -y);
                WXScroller.this.getView().invalidate();
            }
        }, 16L);
        this.getView().postDelayed(new Runnable(){

            @Override
            public void run() {
                WXRecycleImageManager recycleImageManager = WXScroller.this.mInstance.getRecycleImageManager();
                if (recycleImageManager != null) {
                    recycleImageManager.loadImage();
                }
            }
        }, 250L);
    }

    @Override
    public void onScrollChanged(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
        this.procAppear(scrollView, x, y, oldx, oldy);
    }

    private void procAppear(WXScrollView scrollView, int x, int y, int oldx, int oldy) {
        int[] appearComponentLoc = new int[2];
        Rect appearRect = new Rect();
        ConcurrentHashMap<String, AppearData> appearMap = this.mAppearMap.get(this.mDomObj.ref);
        if (appearMap == null) {
            return;
        }
        Iterator<Map.Entry<String, AppearData>> iterator = appearMap.entrySet().iterator();
        Map.Entry<String, AppearData> entry = null;
        if (this.mScrollRect == null) {
            this.mScrollRect = new Rect();
            this.getView().getGlobalVisibleRect(this.mScrollRect);
        }
        int scrollerCenterP = (this.mScrollRect.top + this.mScrollRect.bottom) / 2;
        while (iterator.hasNext()) {
            HashMap<String, Object> params;
            entry = iterator.next();
            AppearData appearData = entry.getValue();
            appearData.mAppearComponent.getView().getGlobalVisibleRect(appearRect);
            appearData.mAppearComponent.getView().getLocationOnScreen(appearComponentLoc);
            if (appearRect.left == 0 && appearRect.top == 0 && appearRect.left == 0 && appearRect.bottom == 0) continue;
            int appearComponentH = (int)appearData.mAppearComponent.getDomObject().getLayoutHeight();
            int appearComponentBottom = appearComponentLoc[1] + appearComponentH;
            int appearComponentTop = appearComponentLoc[1];
            if (appearData.mAppear && (appearComponentTop > this.mScrollRect.top && appearComponentTop < this.mScrollRect.bottom || appearComponentBottom > this.mScrollRect.top && appearComponentBottom < this.mScrollRect.bottom)) continue;
            if (!appearData.mAppear && appearComponentTop < this.mScrollRect.bottom && appearComponentTop > scrollerCenterP) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("procAppear", appearData.mAppearComponent.getRef() + "  appear up");
                }
                appearData.mAppear = true;
                if (!appearData.hasAppear) continue;
                params = new HashMap<String, Object>();
                params.put("direction", "up");
                WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "appear", params);
                continue;
            }
            if (!appearData.mAppear && appearComponentBottom > this.mScrollRect.top && appearComponentBottom < scrollerCenterP) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("procAppear", appearData.mAppearComponent.getRef() + "  appear down");
                }
                appearData.mAppear = true;
                if (!appearData.hasAppear) continue;
                params = new HashMap();
                params.put("direction", "down");
                WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "appear", params);
                continue;
            }
            if (appearData.mAppear && appearComponentTop > this.mScrollRect.bottom && appearComponentBottom > this.mScrollRect.bottom) {
                appearData.mAppear = false;
                if (!appearData.hasDisappear) continue;
                params = new HashMap();
                params.put("direction", "down");
                WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "disappear", params);
                continue;
            }
            if (!appearData.mAppear || appearComponentBottom >= this.mScrollRect.top || appearComponentTop >= this.mScrollRect.top) continue;
            appearData.mAppear = false;
            if (!appearData.hasDisappear) continue;
            params = new HashMap();
            params.put("direction", "up");
            WXSDKManager.getInstance().fireEvent(this.mInstanceId, appearData.mAppearComponent.getRef(), "disappear", params);
        }
    }

    @Override
    public void onScrollToBottom(WXScrollView scrollView, int x, int y) {
    }

    @Override
    public void onScrollStopped(WXScrollView scrollView, int x, int y) {
        WXRecycleImageManager recycleImageManager = this.mInstance.getRecycleImageManager();
        if (recycleImageManager != null) {
            recycleImageManager.loadImage();
        }
    }

    @Override
    public void onScroll(WXScrollView scrollView, int x, int y) {
        this.onLoadMore(scrollView, x, y);
    }

    protected void onLoadMore(WXScrollView scrollView, int x, int y) {
        try {
            int scrollerH;
            String offset = this.mDomObj.attr.getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            int contentH = scrollView.getChildAt(0).getHeight();
            int offScreenY = contentH - y - (scrollerH = scrollView.getHeight());
            if (offScreenY < Integer.parseInt(offset)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + offScreenY);
                }
                if (this.mContentHeight != contentH) {
                    WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, "loadmore");
                    this.mContentHeight = contentH;
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d("[WXScroller-onScroll] " + WXLogUtils.getStackTrace(e));
        }
    }

    static class AppearData {
        public WXComponent mAppearComponent;
        public boolean hasAppear;
        public boolean hasDisappear;
        public boolean mAppear;

        AppearData() {
        }
    }
}

