/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.inputmethod.InputMethodManager;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.IWXRecyclerViewChild;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXResourceUtils;
import java.util.HashMap;

public class WXInput
extends WXComponent
implements IWXRecyclerViewChild {
    private final InputMethodManager mInputMethodManager;
    private String mBeforeText;
    private boolean mAutoFocus;
    private String mType;
    private int mTextAlign;

    public WXInput(WXSDKInstance instance, WXDomObject dom, WXVContainer parent, String instanceId, boolean isLazy) {
        super(instance, dom, parent, instanceId, isLazy);
        this.mInputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        this.mBeforeText = "";
        this.mType = "text";
        this.mTextAlign = 3;
    }

    @Override
    protected void initView() {
        super.initView();
        this.mHost = new WXEditText(this.mContext);
        this.mTextAlign = 3;
        int colorInt = WXResourceUtils.getColor("#999999");
        if (colorInt != Integer.MIN_VALUE) {
            ((WXEditText)this.mHost).setHintTextColor(colorInt);
        }
        ((WXEditText)this.mHost).setTextSize(0, WXStyle.getFontSize(this.mDomObj.style));
    }

    public WXEditText getView() {
        return (WXEditText)super.getView();
    }

    @Override
    public void flushView() {
        super.flushView();
        if (this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setRawInputType(this.getInputType(this.mType));
        if (this.mAutoFocus) {
            this.mHost.setFocusable(true);
            this.mHost.requestFocus();
            this.mHost.setFocusableInTouchMode(true);
            this.mHost.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WXInput.this.showSoftKeyboard();
                }
            }, 16L);
        } else {
            this.mHost.postDelayed(new Runnable(){

                @Override
                public void run() {
                    WXInput.this.hideSoftKeyboard();
                }
            }, 16L);
        }
        if (this.mTextAlign > 0) {
            this.getView().setGravity(this.mTextAlign | 0x10);
        }
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (this.mHost == null || TextUtils.isEmpty((CharSequence)type)) {
            return;
        }
        ((WXEditText)this.mHost).addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                HashMap<String, Object> params;
                if (WXInput.this.mBeforeText.equals(s.toString())) {
                    return;
                }
                if (WXInput.this.mDomObj.event.contains("input")) {
                    params = new HashMap<String, Object>(2);
                    params.put("value", s.toString());
                    params.put("timeStamp", System.currentTimeMillis());
                    WXSDKManager.getInstance().fireEvent(WXInput.this.mInstanceId, WXInput.this.mDomObj.ref, "input", params);
                }
                if (WXInput.this.mDomObj.event.contains("change")) {
                    params = new HashMap(2);
                    params.put("value", s.toString());
                    params.put("timeStamp", System.currentTimeMillis());
                    WXSDKManager.getInstance().fireEvent(WXInput.this.mInstanceId, WXInput.this.mDomObj.ref, "change", params);
                }
                WXInput.this.mBeforeText = s.toString();
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private int getInputType(String type) {
        int inputType;
        switch (type) {
            case "text": {
                inputType = 1;
                break;
            }
            case "date": {
                inputType = 20;
                break;
            }
            case "datetime": {
                inputType = 4;
                break;
            }
            case "email": {
                inputType = 33;
                break;
            }
            case "password": {
                inputType = 129;
                this.getView().setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                break;
            }
            case "tel": {
                inputType = 3;
                break;
            }
            case "time": {
                inputType = 36;
                break;
            }
            case "url": {
                inputType = 17;
                break;
            }
            default: {
                inputType = 1;
            }
        }
        return inputType;
    }

    private boolean showSoftKeyboard() {
        if (this.mHost == null) {
            return false;
        }
        return this.mInputMethodManager.showSoftInput(this.mHost, 1);
    }

    private void hideSoftKeyboard() {
        if (this.mHost != null) {
            this.mInputMethodManager.hideSoftInputFromWindow(this.mHost.getWindowToken(), 0);
        }
    }

    @WXComponentProp(name="value")
    public void setValue(String value) {
        if (value == null || this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setText(value);
    }

    @WXComponentProp(name="placeholder")
    public void setPlaceholder(String placeholder) {
        if (placeholder == null || this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setHint(placeholder);
    }

    @WXComponentProp(name="placeholderColor")
    public void setPlaceholderColor(String color) {
        int colorInt;
        if (this.mHost != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.mHost).setHintTextColor(colorInt);
        }
    }

    @WXComponentProp(name="color")
    public void setColor(String color) {
        int colorInt;
        if (this.mHost != null && !TextUtils.isEmpty((CharSequence)color) && (colorInt = WXResourceUtils.getColor(color)) != Integer.MIN_VALUE) {
            ((WXEditText)this.mHost).setTextColor(colorInt);
        }
    }

    @WXComponentProp(name="fontSize")
    public void setFontSize(String fontSize) {
        if (this.mHost != null && fontSize != null && this.mDomObj.style != null) {
            ((WXEditText)this.mHost).setTextSize(0, WXStyle.getFontSize(this.mDomObj.style));
        }
    }

    @WXComponentProp(name="autofocus")
    public void setAutofocus(boolean autofocus) {
        if (this.mHost == null) {
            return;
        }
        this.mAutoFocus = autofocus;
    }

    @WXComponentProp(name="singleline")
    public void setSingleLine(boolean singleLine) {
        if (this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setSingleLine(singleLine);
    }

    @WXComponentProp(name="lines")
    public void setLines(int lines) {
        if (this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setLines(lines);
    }

    @WXComponentProp(name="maxlength")
    public void setMaxLength(int maxLength) {
        if (this.mHost == null) {
            return;
        }
        ((WXEditText)this.mHost).setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
    }

    @WXComponentProp(name="type")
    public void setType(String type) {
        if (type == null || this.mHost == null) {
            return;
        }
        this.mType = type;
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(String textAlign) {
        this.mTextAlign = this.getTextAlign(textAlign);
    }

    private int getTextAlign(String textAlign) {
        int align = 3;
        if (TextUtils.isEmpty((CharSequence)textAlign)) {
            return align;
        }
        if (textAlign.equals("left")) {
            align = 3;
        } else if (textAlign.equals("center")) {
            align = 17;
        } else if (textAlign.equals("right")) {
            align = 5;
        }
        return align;
    }
}

