/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.animation.WXAnimationModule;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentFactory;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;
import java.util.Map;

class WXRenderStatement {
    private String mInstanceId;
    private Map<String, WXComponent> mRegistry;
    private WXSDKInstance mWXSDKInstance;
    private WXVContainer mGodComponent;

    public WXRenderStatement(WXSDKInstance instance, String instaceId) {
        this.mWXSDKInstance = instance;
        this.mInstanceId = instaceId;
        this.mRegistry = new HashMap<String, WXComponent>();
    }

    public void destroy() {
        this.mWXSDKInstance = null;
        if (this.mGodComponent != null) {
            this.mGodComponent.destroy();
        }
        this.mRegistry.clear();
    }

    public WXSDKInstance getWXSDKInstance() {
        return this.mWXSDKInstance;
    }

    public void flushView(String ref) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.flushView();
    }

    void createBody(WXComponent component) {
        WXScroller scroller;
        long start = System.currentTimeMillis();
        component.createView(this.mGodComponent, -1);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("createView", System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        component.bind(null);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.renderPerformanceLog("bind", System.currentTimeMillis() - start);
        }
        if (component instanceof WXScroller && (scroller = (WXScroller)component).getView() instanceof ScrollView) {
            this.mWXSDKInstance.setRootScrollView((ScrollView)scroller.getView());
        }
        this.mWXSDKInstance.setRootView(this.mGodComponent.getRealView());
        if (this.mWXSDKInstance.getRenderStrategy() != WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onViewCreated(this.mGodComponent);
        }
    }

    WXComponent createBodyOnDomThread(WXDomObject dom) {
        if (this.mWXSDKInstance == null) {
            return null;
        }
        WXDomObject domObject = new WXDomObject();
        domObject.type = "div";
        domObject.ref = "god";
        this.mGodComponent = (WXVContainer)WXComponentFactory.newInstance(this.mWXSDKInstance, domObject, null, this.mInstanceId);
        this.mGodComponent.createView(null, -1);
        if (this.mGodComponent == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("rootView failed!");
            }
            return null;
        }
        FrameLayout frameLayout = (FrameLayout)this.mGodComponent.getView();
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        frameLayout.setLayoutParams(layoutParams);
        WXComponent component = this.generateComponentTree(dom, this.mGodComponent);
        this.mGodComponent.addChild(component);
        this.mRegistry.put(component.getRef(), component);
        return component;
    }

    void setPadding(String ref, Spacing padding, Spacing border) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setPadding(padding, border);
    }

    void setLayout(String ref, WXDomObject domObject) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.setLayout(domObject);
    }

    void setExtra(String ref, Object extra) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateExtra(extra);
    }

    void addComponent(WXDomObject dom, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        WXComponent component = this.generateComponentTree(dom, parent);
        parent.addChild(component, index);
        WXAnimationModule.applyTransformStyle(dom.style, component);
    }

    WXComponent createComponentOnDomThread(WXDomObject dom, String parentRef, int index) {
        return this.generateComponentTree(dom, (WXVContainer)this.mRegistry.get(parentRef));
    }

    void addComponent(WXComponent component, String parentRef, int index) {
        WXVContainer parent = (WXVContainer)this.mRegistry.get(parentRef);
        if (parent == null || component == null) {
            return;
        }
        component.createView(parent, index);
        component.bind(null);
        parent.addChild(component, index);
        WXAnimationModule.applyTransformStyle(component.mDomObj.style, component);
    }

    WXComponent removeComponent(String ref) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null || component.getParent() == null) {
            return component;
        }
        WXVContainer parent = component.getParent();
        parent.remove(component);
        this.clearRegistryForComponent(component);
        component.destroy();
        return component;
    }

    private void clearRegistryForComponent(WXComponent component) {
        WXComponent removedComponent = this.mRegistry.remove(component.getDomObject().ref);
        if (removedComponent != null) {
            removedComponent.removeAllEvent();
            removedComponent.removeStickyStyle();
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = count - 1; i >= 0; --i) {
                this.clearRegistryForComponent(container.getChild(i));
            }
        }
    }

    void move(String ref, String parentRef, int index) {
        WXComponent component = this.mRegistry.get(ref);
        WXComponent newParent = this.mRegistry.get(parentRef);
        if (component == null || component.getParent() == null || newParent == null || !(newParent instanceof WXVContainer)) {
            return;
        }
        WXVContainer oldParent = component.getParent();
        oldParent.remove(component);
        ((WXVContainer)newParent).addChild(component, index);
    }

    void addEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.addEvent(type);
    }

    void removeEvent(String ref, String type) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.removeEvent(type);
    }

    void updateAttrs(String ref, Map<String, Object> attrs) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(attrs);
    }

    void updateStyle(String ref, Map<String, Object> style) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        component.updateProperties(style);
        WXAnimationModule.applyTransformStyle(style, component);
    }

    void scrollTo(String ref, Map<String, Object> options) {
        WXScroller scroller;
        WXComponent component = this.mRegistry.get(ref);
        if (component == null) {
            return;
        }
        int offsetInt = 0;
        if (options != null) {
            String offset;
            String string = offset = options.get("offset") == null ? "0" : options.get("offset").toString();
            if (offset != null) {
                offsetInt = Integer.parseInt(offset);
            }
        }
        if ((scroller = component.getParentScroller()) == null) {
            return;
        }
        int offsetIntF = (int)WXViewUtils.getRealPxByWidth(offsetInt);
        int[] scrollerP = new int[2];
        scroller.getView().getLocationOnScreen(scrollerP);
        if (scrollerP[1] == component.getAbsoluteY()) {
            return;
        }
        int viewYInScroller = component.getAbsoluteY();
        if (component.getParent() != null) {
            viewYInScroller -= component.getParent().getAbsoluteY();
        }
        scroller.scrollBy(0, scroller.getView().getScrollY() - viewYInScroller - offsetIntF);
    }

    void createFinish(int width, int height) {
        if (this.mWXSDKInstance.getRenderStrategy() == WXRenderStrategy.APPEND_ONCE) {
            this.mWXSDKInstance.onViewCreated(this.mGodComponent);
        }
        this.mWXSDKInstance.onRenderSuccess(width, height);
    }

    void refreshFinish(int width, int height) {
        this.mWXSDKInstance.onRefreshSuccess(width, height);
    }

    private WXComponent generateComponentTree(WXDomObject dom, WXVContainer parent) {
        if (dom == null || parent == null) {
            return null;
        }
        WXComponent component = WXComponentFactory.newInstance(this.mWXSDKInstance, dom, parent, this.mInstanceId, parent.isLazy());
        this.mRegistry.put(dom.ref, component);
        if (component instanceof WXVContainer) {
            WXVContainer parentC = (WXVContainer)component;
            int count = dom.childCount();
            WXDomObject child = null;
            for (int i = 0; i < count; ++i) {
                child = dom.getChild(i);
                if (child == null) continue;
                parentC.addChild(this.generateComponentTree(child, parentC));
            }
        }
        return component;
    }

    void startAnimation(String ref, String animation, String callBack) {
        WXComponent component = this.mRegistry.get(ref);
        if (component == null || component.getRealView() == null) {
            return;
        }
        try {
            ObjectAnimator animator;
            WXAnimationBean animationBean = WXAnimationModule.parseAnimation(animation, component.getRealView().getLayoutParams());
            if (animationBean != null && (animator = WXAnimationModule.createAnimator(animationBean, component.getRealView())) != null) {
                Animator.AnimatorListener animatorListener = WXAnimationModule.createAnimatorListener(this.mWXSDKInstance, callBack);
                Interpolator interpolator = WXAnimationModule.createTimeInterpolator(animationBean);
                if (animatorListener != null) {
                    animator.addListener(animatorListener);
                }
                if (interpolator != null) {
                    animator.setInterpolator((TimeInterpolator)interpolator);
                }
                animator.setDuration(animationBean.duration);
                animator.start();
            }
        }
        catch (RuntimeException e) {
            WXLogUtils.e(WXLogUtils.getStackTrace(e));
        }
    }
}

