/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.view.View;
import android.widget.ImageView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXImageSharpen;
import com.taobao.weex.common.WXImageStrategy;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.List;

public class WXRecycleImageManager {
    public static final int VISIBLE_TOP_SPACE = -WXViewUtils.getScreenHeight() * 3 / 5;
    public static final int VISIBLE_BOTTOM_SPACE = -VISIBLE_TOP_SPACE;
    int[] mImgPos = new int[2];
    private WXSDKInstance mInstance;
    private List<ImageInfo> mAllImages = new ArrayList<ImageInfo>();

    public WXRecycleImageManager(WXSDKInstance instance) {
        this.mInstance = instance;
    }

    public List<ImageInfo> getAllImages() {
        return this.mAllImages;
    }

    public boolean addImage(WXComponent view) {
        if (this.mAllImages != null && !this.mAllImages.contains(view) && this.mInstance != null) {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.image = view;
            imageInfo.isRecycle = true;
            this.mAllImages.add(imageInfo);
            return true;
        }
        return false;
    }

    public void loadImage() {
        int count = this.mAllImages.size();
        int screenH = WXViewUtils.getScreenHeight();
        for (int i = 0; i < count; ++i) {
            boolean in;
            View view;
            ImageInfo imageInfo = this.mAllImages.get(i);
            WXComponent component = imageInfo.image;
            if (component == null || component.getDomObject() == null || component.getDomObject().attr == null || (view = component.getView()) == null) continue;
            view.getLocationOnScreen(this.mImgPos);
            boolean bl = in = this.mImgPos[1] > VISIBLE_TOP_SPACE && this.mImgPos[1] - screenH < VISIBLE_BOTTOM_SPACE || view.getHeight() + this.mImgPos[1] > 0 && this.mImgPos[1] <= 0;
            if (in && imageInfo.isRecycle) {
                imageInfo.isRecycle = false;
                String src = component.getDomObject().attr.getImageSrc();
                this.setImage(src, component, true);
                continue;
            }
            if (in || imageInfo.isRecycle) continue;
            imageInfo.isRecycle = true;
            this.setImage(null, component, false);
        }
    }

    private void setImage(Object url, WXComponent component, boolean isVisibleOnScreen) {
        try {
            if (component == null || component.getDomObject() == null || component.getDomObject().attr == null) {
                return;
            }
            if (isVisibleOnScreen) {
                WXImageStrategy waImageStrategy = new WXImageStrategy();
                waImageStrategy.isClipping = true;
                WXDomObject element = component.getDomObject();
                WXImageSharpen waImageSharpen = element.attr.getImageSharpen();
                waImageStrategy.isSharpen = waImageSharpen == WXImageSharpen.SHARPEN;
                this.mInstance.getImgLoaderAdapter().setImage(url == null ? null : url.toString(), (ImageView)component.getView(), element.attr.getImageQuality(), waImageStrategy);
            } else {
                this.mInstance.getImgLoaderAdapter().setImage(null, (ImageView)component.getView(), null, null);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("[WXRecycleImageManager] setImage error: " + WXLogUtils.getStackTrace(e));
        }
    }

    public void destroy() {
        if (this.mAllImages != null) {
            this.mAllImages.clear();
        }
        this.mAllImages = null;
        this.mInstance = null;
    }

    public static class ImageInfo {
        public WXComponent image;
        public boolean isRecycle;
    }
}

