/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.PointF;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class WXListComponent
extends WXVContainer
implements IRecyclerAdapterListener<ListBaseViewHolder>,
IOnLoadMoreListener {
    private String TAG = "WXListComponent";
    private RecyclerViewBaseAdapter recyclerViewBaseAdapter;
    private HashMap<String, Integer> typeList = new HashMap();
    private ArrayList<Integer> indoreCells;
    private int listCellCount = 0;

    public WXListComponent(WXSDKInstance instance, WXDomObject node, WXVContainer parent, String instanceId, boolean lazy) {
        super(instance, node, parent, instanceId, lazy);
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight();
        int weexH = WXViewUtils.getWeexHeight(this.mInstanceId);
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.mAbsoluteY : height;
        return super.measure(width, outHeight);
    }

    @Override
    protected void initView() {
        this.mHost = new WXRecyclerView(this.mContext);
        this.recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        this.getView().initView(this.mContext, 1);
        this.getView().setAdapter(this.recyclerViewBaseAdapter);
        this.getView().clearOnScrollListeners();
        this.getView().addOnScrollListener(new WXRecyclerViewOnScrollListener(this));
    }

    public WXRecyclerView getView() {
        return (WXRecyclerView)super.getView();
    }

    @Override
    public void addChild(WXComponent child) {
        super.addChild(child);
        int index = this.mChildren.indexOf(child);
        this.recyclerViewBaseAdapter.notifyItemInserted(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "addChild child at " + index);
        }
    }

    @Override
    public void addChild(WXComponent child, int index) {
        super.addChild(child, index);
        int adapterPosition = index == -1 ? this.recyclerViewBaseAdapter.getItemCount() - 1 : index;
        this.recyclerViewBaseAdapter.notifyItemInserted(adapterPosition);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "addChild child at " + index);
        }
    }

    @Override
    protected void addSubView(View child, int index) {
    }

    @Override
    public void remove(WXComponent child) {
        int index = this.mChildren.indexOf(child);
        try {
            child.detachViewAndClearPreInfo();
        }
        catch (WXException e) {
            throw new WXRuntimeException("Customize components that will be used in RecyclerView must implement IWXRecyclerViewChild interface");
        }
        super.remove(child);
        this.recyclerViewBaseAdapter.notifyItemRemoved(index);
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "removeChild child at " + index);
        }
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        WXRecyclerView view = this.getView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    public void onViewRecycled(ListBaseViewHolder holder) {
        for (WXComponent child : this.mChildren) {
            if (child.getRealView() != holder.getView()) continue;
            try {
                child.detachViewAndClearPreInfo();
            }
            catch (WXException e) {
                throw new WXRuntimeException("Customize components that will be used in RecyclerView must implement IWXRecyclerViewChild interface");
            }
        }
    }

    @Override
    public void onBindViewHolder(ListBaseViewHolder holder, int position) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(this.TAG, "OnBindViewHolder position:" + position);
        }
        if (holder != null) {
            if (this.indoreCells != null && this.indoreCells.contains(position)) {
                return;
            }
            if (this.getChild(position) instanceof WXCell) {
                WXCell wxCell = (WXCell)this.getChild(position);
                try {
                    wxCell.detachViewAndClearPreInfo();
                }
                catch (WXException e) {
                    throw new WXRuntimeException("Customize components that will be used in RecyclerView must implement IWXRecyclerViewChild interface");
                }
                wxCell.lazy(false);
                wxCell.bind(holder.getView());
                wxCell.flushView();
            }
        }
    }

    @Override
    public ListBaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.indoreCells != null && this.indoreCells.contains(viewType)) {
            FrameLayout view = new FrameLayout(this.mContext);
            view.setBackgroundColor(-16776961);
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(1, 1));
            return new ListBaseViewHolder((View)view);
        }
        if (this.mChildren != null) {
            int count = this.childCount();
            for (int i = 0; i < count; ++i) {
                WXComponent wxComponent = this.getChild(i);
                if (wxComponent == null || this.getItemViewType(i) != viewType) continue;
                if (wxComponent instanceof WXCell) {
                    if (wxComponent.getView() == null) {
                        wxComponent.lazy(false);
                        wxComponent.createView(this, -1);
                        try {
                            View view = wxComponent.detachViewAndClearPreInfo();
                            if (WXEnvironment.isApkDebugable()) {
                                WXLogUtils.d(this.TAG, "OnCreateViewHolder viewType: " + viewType);
                            }
                            return new ListBaseViewHolder(view);
                        }
                        catch (WXException e) {
                            throw new WXRuntimeException("Customize components that will be used in RecyclerView must implement IWXRecyclerViewChild interface");
                        }
                    }
                    return new ListBaseViewHolder(this.getChild(i).getView());
                }
                if (this.getChild(i).getView() == null) continue;
                WXComponent wxCell = this.getChild(i);
                wxCell.bind(wxCell.getView());
                wxCell.flushView();
                return new ListBaseViewHolder(wxCell.getView());
            }
            throw new WXRuntimeException("Not find required WXComponent");
        }
        throw new NullPointerException("mChildren is null");
    }

    @Override
    public int getItemViewType(int position) {
        try {
            String type = ((WXComponent)this.mChildren.get((int)position)).getDomObject().attr.getScope();
            if (((WXComponent)this.mChildren.get(position)).getDomObject().isFixed()) {
                if (this.indoreCells == null) {
                    this.indoreCells = new ArrayList();
                }
                if (!this.indoreCells.contains(position)) {
                    this.indoreCells.add(position);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)type)) {
                if (!this.typeList.containsKey(type)) {
                    this.typeList.put(type, position);
                }
                return this.typeList.get(type);
            }
        }
        catch (Exception e) {
            WXLogUtils.e(this.TAG, "getItemViewType:" + WXLogUtils.getStackTrace(e));
        }
        return position;
    }

    @Override
    public int getItemCount() {
        if (this.mChildren != null) {
            return this.mChildren.size();
        }
        return 0;
    }

    @Override
    public boolean onFailedToRecycleView(ListBaseViewHolder holder) {
        return false;
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            String offset = this.mDomObj.attr.getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                return;
            }
            if (offScreenY < Integer.parseInt(offset)) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d(this.TAG, "offScreenY :" + offScreenY);
                }
                if (this.listCellCount != this.mChildren.size()) {
                    WXSDKManager.getInstance().fireEvent(this.mInstanceId, this.mDomObj.ref, "loadmore");
                    this.listCellCount = this.mChildren.size();
                }
            }
        }
        catch (Exception e) {
            WXLogUtils.d(this.TAG, "onLoadMore :" + WXLogUtils.getStackTrace(e));
        }
    }
}

