/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentPropCache;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WXComponentRegistry {
    private static Map<String, Class<? extends WXComponent>> sComponent = new HashMap<String, Class<? extends WXComponent>>();

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz, boolean appendTree) throws WXException {
        if (clazz == null || TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (sComponent.containsKey(type)) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXException("Exist duplicate component :" + type);
            }
            WXLogUtils.e("WXComponentRegistry Exist duplicate component: " + type);
            return false;
        }
        WXComponentPropCache.getMethods(clazz);
        HashMap<String, String> componentInfo = new HashMap<String, String>();
        componentInfo.put("type", type);
        if (appendTree) {
            componentInfo.put("append", "tree");
        }
        return WXComponentRegistry.registerNativeComponent(type, clazz) && WXComponentRegistry.registerJSComponent(componentInfo);
    }

    public static boolean registerNativeComponent(String type, Class<? extends WXComponent> clazz) throws WXException {
        sComponent.put(type, clazz);
        return true;
    }

    private static boolean registerJSComponent(Map<String, String> componentInfo) throws WXException {
        ArrayList<Map<String, String>> coms = new ArrayList<Map<String, String>>();
        coms.add(componentInfo);
        WXSDKManager.getInstance().registerComponents(coms);
        return true;
    }

    public static boolean registerComponent(Map<String, String> componentInfo, Class<? extends WXComponent> clazz) throws WXException {
        if (componentInfo == null || clazz == null) {
            return false;
        }
        String type = componentInfo.get("style");
        if (type == null) {
            return false;
        }
        if (sComponent.containsKey(type)) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXException("Exist duplicate component:" + type);
            }
            WXLogUtils.e("WXComponentRegistry Exist duplicate component: " + type);
            return false;
        }
        WXComponentPropCache.getMethods(clazz);
        return WXComponentRegistry.registerNativeComponent(type, clazz) && WXComponentRegistry.registerJSComponent(componentInfo);
    }

    public static Class<? extends WXComponent> getComponent(String type) {
        return sComponent.get(type);
    }
}

