/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WXStateRecord {
    private RecordList<Info> mExceptionHistory = new RecordList(5);
    private RecordList<Info> mActionHistory = new RecordList(10);
    private RecordList<Info> mJsfmInitHistory = new RecordList(3);
    private RecordList<Info> mJscCrashHistory = new RecordList(3);
    private RecordList<Info> mJscReloadHistory = new RecordList(5);

    public static WXStateRecord getInstance() {
        return SingleTonHolder.S_INSTANCE;
    }

    private WXStateRecord() {
    }

    public void recordException(String instanceId, String exception) {
        String shortException = exception.length() > 200 ? exception.substring(0, 200) : exception;
        this.mExceptionHistory.add(new Info(WXUtils.getFixUnixTime(), instanceId, shortException));
    }

    public void recordAction(String instanceId, String action) {
        this.mActionHistory.add(new Info(WXUtils.getFixUnixTime(), instanceId, action));
    }

    public void onJSFMInit() {
        this.mJsfmInitHistory.add(new Info(WXUtils.getFixUnixTime(), "JSFM", "onJsfmInit"));
    }

    public void onJSEngineReload() {
        this.mJscReloadHistory.add(new Info(WXUtils.getFixUnixTime(), "", "onJSEngineReload"));
    }

    public void onJSCCrash() {
        this.mJscCrashHistory.add(new Info(WXUtils.getFixUnixTime(), "", "onJSCCrash"));
    }

    public Map<String, String> getStateInfo() {
        HashMap<String, String> stateInfo = new HashMap<String, String>(5);
        stateInfo.put("exceptionHistory", this.mExceptionHistory.toString());
        stateInfo.put("actionHistory", this.mActionHistory.toString());
        stateInfo.put("jsfmInitHistory", this.mJsfmInitHistory.toString());
        stateInfo.put("jscCrashHistory", this.mJscCrashHistory.toString());
        stateInfo.put("jscReloadHistory", this.mJscReloadHistory.toString());
        return stateInfo;
    }

    private static class Info {
        private long time;
        private String instanceId;
        private String msg;

        public Info(long time, String instance, String msg) {
            this.time = time;
            this.instanceId = instance;
            this.msg = msg;
        }

        public String toString() {
            return this.instanceId + ',' + this.time + ',' + this.msg;
        }
    }

    private static class RecordList<E>
    extends ArrayList<E> {
        private int maxSize;

        public RecordList(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public boolean add(E e) {
            if (this.size() > 0 && this.size() >= this.maxSize) {
                this.remove(this.size() - 1);
            }
            return super.add(e);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                builder.append('[').append(this.get(i).toString()).append(']').append("->");
            }
            return builder.toString();
        }
    }

    private static class SingleTonHolder {
        private static final WXStateRecord S_INSTANCE = new WXStateRecord();

        private SingleTonHolder() {
        }
    }
}

