/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taobao.weex.utils.WXLogUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class WXSQLiteOpenHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "WXStorage";
    private static final int DATABASE_VERSION = 2;
    static final String TAG_STORAGE = "weex_storage";
    private long mMaximumDatabaseSize = 0x3200000L;
    static SimpleDateFormat sDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private Context mContext;
    private SQLiteDatabase mDb;
    static final String TABLE_STORAGE = "default_wx_storage";
    static final String COLUMN_KEY = "key";
    static final String COLUMN_VALUE = "value";
    static final String COLUMN_TIMESTAMP = "timestamp";
    static final String COLUMN_PERSISTENT = "persistent";
    private static final int SLEEP_TIME_MS = 30;
    private static final String STATEMENT_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS default_wx_storage (key TEXT PRIMARY KEY,value TEXT NOT NULL,timestamp TEXT NOT NULL,persistent INTEGER DEFAULT 0)";

    public WXSQLiteOpenHelper(Context context) {
        super(context, DATABASE_NAME, null, 2);
        this.mContext = context;
    }

    @Nullable
    public SQLiteDatabase getDatabase() {
        this.ensureDatabase();
        return this.mDb;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(STATEMENT_CREATE_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion != newVersion) {
            if (newVersion == 2 && oldVersion == 1) {
                WXLogUtils.d(TAG_STORAGE, "storage is updating from version " + oldVersion + " to version " + newVersion);
                boolean updateResult = true;
                try {
                    long start = System.currentTimeMillis();
                    db.beginTransaction();
                    String SQL_ADD_COLUMN_TIMESTAMP = "ALTER TABLE default_wx_storage ADD COLUMN timestamp TEXT;";
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + SQL_ADD_COLUMN_TIMESTAMP);
                    db.execSQL(SQL_ADD_COLUMN_TIMESTAMP);
                    String SQL_ADD_COLUMN_PERSISTENT = "ALTER TABLE default_wx_storage ADD COLUMN persistent INTEGER;";
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + SQL_ADD_COLUMN_PERSISTENT);
                    db.execSQL(SQL_ADD_COLUMN_PERSISTENT);
                    String SQL_UPDATE_TABLE = "UPDATE default_wx_storage SET timestamp = '" + sDateFormatter.format(new Date()) + "' , " + COLUMN_PERSISTENT + " = 0";
                    WXLogUtils.d(TAG_STORAGE, "exec sql : " + SQL_UPDATE_TABLE);
                    db.execSQL(SQL_UPDATE_TABLE);
                    db.setTransactionSuccessful();
                    long time = System.currentTimeMillis() - start;
                    WXLogUtils.d(TAG_STORAGE, "storage updated success (" + time + "ms)");
                }
                catch (Exception e) {
                    WXLogUtils.d(TAG_STORAGE, "storage updated failed from version " + oldVersion + " to version " + newVersion + "," + e.getMessage());
                    updateResult = false;
                }
                finally {
                    db.endTransaction();
                }
                if (!updateResult) {
                    WXLogUtils.d(TAG_STORAGE, "storage is rollback,all data will be removed");
                    this.deleteDB();
                    this.onCreate(db);
                }
            } else {
                this.deleteDB();
                this.onCreate(db);
            }
        }
    }

    synchronized void ensureDatabase() {
        if (this.mDb != null && this.mDb.isOpen()) {
            return;
        }
        try {
            for (int tries = 0; tries < 2; ++tries) {
                try {
                    if (tries > 0) {
                        this.deleteDB();
                    }
                    this.mDb = this.getWritableDatabase();
                    break;
                }
                catch (SQLiteException e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
            }
            if (this.mDb == null) {
                return;
            }
            this.createTableIfNotExists(this.mDb);
            this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
        }
        catch (Throwable e) {
            this.mDb = null;
            WXLogUtils.d(TAG_STORAGE, "ensureDatabase failed, throwable = " + e.getMessage());
        }
    }

    public synchronized void setMaximumSize(long size) {
        this.mMaximumDatabaseSize = size;
        if (this.mDb != null) {
            this.mDb.setMaximumSize(this.mMaximumDatabaseSize);
        }
    }

    private boolean deleteDB() {
        this.closeDatabase();
        return this.mContext.deleteDatabase(DATABASE_NAME);
    }

    public synchronized void closeDatabase() {
        if (this.mDb != null && this.mDb.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableIfNotExists(@NonNull SQLiteDatabase db) {
        try (Cursor cursor = null;){
            cursor = db.rawQuery("SELECT DISTINCT tbl_name FROM sqlite_master WHERE tbl_name = 'default_wx_storage'", null);
            if (cursor != null && cursor.getCount() > 0) {
                return;
            }
            db.execSQL(STATEMENT_CREATE_TABLE);
        }
    }
}

