/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.adapter.IWXSoLoaderAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class WXSoInstallMgrSdk {
    static final String LOGTAG = "INIT_SO";
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    private static final String STARTUPSO = "/libweexjsb.so";
    private static final String STARTUPSOANDROID15 = "/libweexjst.so";
    static Context mContext = null;
    private static IWXSoLoaderAdapter mSoLoader = null;
    private static IWXStatisticsListener mStatisticsListener = null;

    public static void init(Context c, IWXSoLoaderAdapter loader, IWXStatisticsListener listener) {
        mContext = c;
        mSoLoader = loader;
        mStatisticsListener = listener;
    }

    public static boolean isX86() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return cpuType.equalsIgnoreCase(X86);
    }

    public static boolean isCPUSupport() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return !cpuType.equalsIgnoreCase(MIPS);
    }

    public static boolean initSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        if (cpuType.equalsIgnoreCase(MIPS)) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is MIPS", null);
            return false;
        }
        WXSoInstallMgrSdk.copyStartUpSo();
        boolean InitSuc = false;
        try {
            if (mSoLoader != null) {
                mSoLoader.doLoadLibrary(libName);
            } else {
                System.loadLibrary(libName);
            }
            InitSuc = true;
        }
        catch (Error | Exception e2) {
            if (cpuType.contains(ARMEABI) || cpuType.contains(X86)) {
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is " + cpuType + "\n Detail Error is: " + e2.getMessage(), null);
            }
            InitSuc = false;
        }
        try {
            if (!InitSuc) {
                if (WXSoInstallMgrSdk.isExist(libName, version)) {
                    boolean res = WXSoInstallMgrSdk._loadUnzipSo(libName, version, utAdapter);
                    if (res) {
                        return res;
                    }
                    WXSoInstallMgrSdk.removeSoIfExit(libName, version);
                }
                if (cpuType.equalsIgnoreCase(MIPS)) {
                    return false;
                }
                try {
                    InitSuc = WXSoInstallMgrSdk.unZipSelectedFiles(libName, version, utAdapter);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Error | Exception e) {
            InitSuc = false;
            e.printStackTrace();
        }
        return InitSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStartUpSo() {
        block22: {
            try {
                String soName;
                File oldfile;
                File newfile;
                boolean installOnSdcard = true;
                String pkgName = WXEnvironment.getApplication().getPackageName();
                if (!installOnSdcard) break block22;
                String cacheFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
                boolean pieSupport = true;
                if (Build.VERSION.SDK_INT < 16) {
                    pieSupport = false;
                    newfile = new File(cacheFile + STARTUPSOANDROID15);
                } else {
                    newfile = new File(cacheFile + STARTUPSO);
                }
                String jsbVersionFile = "jsb.version";
                File versionFile = new File(cacheFile, jsbVersionFile);
                Closeable r = null;
                if (newfile.exists() && versionFile.exists()) {
                    try {
                        boolean same;
                        FileReader fileReader = new FileReader(versionFile);
                        r = fileReader;
                        BufferedReader br = new BufferedReader(fileReader);
                        String s = br.readLine();
                        if (!TextUtils.isEmpty((CharSequence)s) && (same = String.valueOf(1).equals(s.trim()))) {
                            return;
                        }
                    }
                    catch (FileNotFoundException fileReader) {
                    }
                    finally {
                        if (r != null) {
                            r.close();
                        }
                    }
                }
                String path = "/data/data/" + pkgName + "/lib";
                if (cacheFile != null && cacheFile.indexOf("/cache") > 0) {
                    path = cacheFile.replace("/cache", "/lib");
                }
                if ((oldfile = new File(soName = pieSupport ? path + STARTUPSO : path + STARTUPSOANDROID15)).exists()) {
                    WXFileUtils.copyFile(oldfile, newfile);
                } else {
                    WXEnvironment.extractSo();
                }
                try (Closeable w = null;){
                    if (!versionFile.exists()) {
                        versionFile.createNewFile();
                    }
                    FileWriter fileWriter = new FileWriter(versionFile);
                    w = fileWriter;
                    fileWriter.write(String.valueOf(1));
                    fileWriter.flush();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static String _getFieldReflectively(Build build, String fieldName) {
        try {
            Field field = Build.class.getField(fieldName);
            return field.get(build).toString();
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        String abi;
        try {
            abi = Build.CPU_ABI;
        }
        catch (Exception e) {
            e.printStackTrace();
            abi = ARMEABI;
        }
        if (TextUtils.isEmpty((CharSequence)abi)) {
            abi = ARMEABI;
        }
        abi = abi.toLowerCase();
        return abi;
    }

    static boolean checkSoIsValid(String libName, long size) {
        Context context = mContext;
        if (null == context) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            if (WXSoInstallMgrSdk.class.getClassLoader() instanceof PathClassLoader) {
                String path = ((PathClassLoader)WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(libName);
                if (TextUtils.isEmpty((CharSequence)path)) {
                    return false;
                }
                File file = new File(path);
                if (!file.exists() || size == file.length()) {
                    WXLogUtils.w("weex so size check path :" + path + "   " + (System.currentTimeMillis() - start));
                    return true;
                }
                return false;
            }
        }
        catch (Throwable e) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "checkSoIsValid", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for weex so size check fail exception :" + e.getMessage(), null);
            WXLogUtils.e("weex so size check fail exception :" + e.getMessage());
        }
        return true;
    }

    static String _targetSoFile(String libName, int version) {
        Context context = mContext;
        if (null == context) {
            return "";
        }
        String path = "/data/data/" + context.getPackageName() + "/files";
        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libName + "bk" + version + ".so";
    }

    static void removeSoIfExit(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }
    }

    static boolean isExist(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        return a.exists();
    }

    static boolean _loadUnzipSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        boolean initSuc = false;
        try {
            if (WXSoInstallMgrSdk.isExist(libName, version)) {
                if (mSoLoader != null) {
                    mSoLoader.doLoad(WXSoInstallMgrSdk._targetSoFile(libName, version));
                } else {
                    System.load(WXSoInstallMgrSdk._targetSoFile(libName, version));
                }
            }
            initSuc = true;
        }
        catch (Throwable e) {
            initSuc = false;
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "_loadUnzipSo", "[WX_KEY_EXCEPTION_SDK_INIT_WX_ERR_COPY_FROM_APK] \n Detail Msg is : " + e.getMessage(), null);
            WXLogUtils.e("", e);
        }
        return initSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String libName, int version, IWXUserTrackAdapter utAdapter) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libName + ".so";
        String zipPath = "";
        Context context = mContext;
        if (context == null) {
            return false;
        }
        ApplicationInfo aInfo = context.getApplicationInfo();
        if (null != aInfo) {
            zipPath = aInfo.sourceDir;
        }
        ZipFile zf = new ZipFile(zipPath);
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(sourcePath)) continue;
                InputStream in = null;
                FileOutputStream os = null;
                AbstractInterruptibleChannel channel = null;
                int total = 0;
                try {
                    int realLength;
                    WXSoInstallMgrSdk.removeSoIfExit(libName, version);
                    in = zf.getInputStream(entry);
                    os = context.openFileOutput("lib" + libName + "bk" + version + ".so", 0);
                    channel = os.getChannel();
                    byte[] buffers = new byte[1024];
                    while ((realLength = in.read(buffers)) > 0) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(buffers, 0, realLength));
                        total += realLength;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (zf != null) {
                        zf.close();
                        zf = null;
                    }
                }
                if (total > 0) {
                    boolean bl = WXSoInstallMgrSdk._loadUnzipSo(libName, version, utAdapter);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "unZipSelectedFiles", "[WX_KEY_EXCEPTION_SDK_INIT_unZipSelectedFiles] \n Detail msg is: " + e.getMessage(), null);
        }
        finally {
            if (zf != null) {
                zf.close();
                zf = null;
            }
        }
        return false;
    }
}

