/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.net.Uri;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXHttpListener;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.base.CalledByNative;
import com.taobao.weex.common.WXRequest;
import com.taobao.weex.common.WXResponse;
import com.taobao.weex.http.WXHttpUtil;
import java.util.HashMap;

public class RequestHandler {
    native void nativeInvokeOnSuccess(long var1, String var3);

    native void nativeInvokeOnFailed(long var1);

    @CalledByNative
    public static RequestHandler create() {
        return new RequestHandler();
    }

    @CalledByNative
    public void send(String instanceId, String url, long nativeCallback) {
        if (TextUtils.isEmpty((CharSequence)instanceId) || TextUtils.isEmpty((CharSequence)url) || nativeCallback == 0L || !WXSDKManager.getInstance().getAllInstanceMap().containsKey(instanceId)) {
            return;
        }
        WXSDKManager manager = WXSDKManager.getInstance();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance == null) {
            return;
        }
        IWXHttpAdapter adapter = WXSDKManager.getInstance().getIWXHttpAdapter();
        WXRequest wxRequest = new WXRequest();
        wxRequest.url = manager.getURIAdapter().rewrite(instance, "bundle", Uri.parse((String)url)).toString();
        if (wxRequest.paramMap == null) {
            wxRequest.paramMap = new HashMap<String, String>();
        }
        wxRequest.paramMap.put("user-agent", WXHttpUtil.assembleUserAgent(instance.getContext(), WXEnvironment.getConfig()));
        wxRequest.paramMap.put("isBundleRequest", "true");
        adapter.sendRequest(wxRequest, new OnHttpListenerInner(instance, nativeCallback, url));
    }

    class OnHttpListenerInner
    extends WXHttpListener {
        private long sNativeCallback;

        OnHttpListenerInner(WXSDKInstance instance, long nativeCallback, String bundlUrl) {
            super(instance, bundlUrl);
            this.sNativeCallback = nativeCallback;
        }

        @Override
        public void onSuccess(WXResponse response) {
            String script = new String(response.originalData);
            RequestHandler.this.nativeInvokeOnSuccess(this.sNativeCallback, script);
        }

        @Override
        public void onFail(WXResponse response) {
            RequestHandler.this.nativeInvokeOnFailed(this.sNativeCallback);
        }
    }
}

