/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.pickers;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.pickers.DatePickerImpl;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WXPickersModule
extends WXModule {
    private static final String SUCCESS = "success";
    private static final String CANCEL = "cancel";
    private static final String ERROR = "error";
    private static final String RESULT = "result";
    private static final String DATA = "data";
    private static final String KEY_VALUE = "value";
    private static final String KEY_INDEX = "index";
    private static final String KEY_TITLE = "title";
    private static final String KEY_MAX = "max";
    private static final String KEY_MIN = "min";
    private static final String KEY_ITEMS = "items";
    private static final String KEY_TITLE_COLOR = "titleColor";
    private static final String KEY_CANCEL_TITLE_COLOR = "cancelTitleColor";
    private static final String KEY_CONFIRM_TITLE = "confirmTitle";
    private static final String KEY_CANCEL_TITLE = "cancelTitle";
    private static final String KEY_CONFIRM_TITLE_COLOR = "confirmTitleColor";
    private static final String KEY_TITLE_BACKGROUND_COLOR = "titleBackgroundColor";
    private static final String KEY_TEXT_COLOR = "textColor";
    private static final String KEY_SELECTION_COLOR = "selectionColor";
    private int selected;

    @JSMethod
    public void pick(Map<String, Object> options, JSCallback callback) {
        List<String> items = this.safeConvert(this.getOption(options, KEY_ITEMS, new ArrayList()));
        try {
            this.performSinglePick(items, options, callback);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @JSMethod
    public void pickDate(Map<String, Object> options, JSCallback callback) {
        this.performPickDate(options, callback);
    }

    @JSMethod
    public void pickTime(Map<String, Object> options, JSCallback callback) {
        this.performPickTime(options, callback);
    }

    private List<String> safeConvert(List src) {
        ArrayList<String> result = new ArrayList<String>(src.size());
        for (Object obj : src) {
            result.add(String.valueOf(obj));
        }
        return result;
    }

    private <T> T getOption(Map<String, Object> options, String key, T defValue) {
        Object value = options.get(key);
        if (value == null) {
            return defValue;
        }
        try {
            return (T)value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    private int getColor(Map<String, Object> options, String key, int defValue) {
        Object value = this.getOption(options, key, null);
        if (value == null) {
            return defValue;
        }
        return WXResourceUtils.getColor(value.toString(), defValue);
    }

    private void performPickTime(Map<String, Object> options, final JSCallback callback) {
        String value = this.getOption(options, KEY_VALUE, "");
        DatePickerImpl.pickTime(this.mWXSDKInstance.getContext(), value, new DatePickerImpl.OnPickListener(){

            @Override
            public void onPick(boolean set, @Nullable String result) {
                if (set) {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                    ret.put(WXPickersModule.DATA, result);
                    callback.invoke(ret);
                } else {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                    ret.put(WXPickersModule.DATA, null);
                    callback.invoke(ret);
                }
            }
        }, options);
    }

    private void performPickDate(Map<String, Object> options, final JSCallback callback) {
        String value = this.getOption(options, KEY_VALUE, "");
        String max = this.getOption(options, KEY_MAX, "");
        String min = this.getOption(options, KEY_MIN, "");
        DatePickerImpl.pickDate(this.mWXSDKInstance.getContext(), value, max, min, new DatePickerImpl.OnPickListener(){

            @Override
            public void onPick(boolean set, @Nullable String result) {
                if (set) {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                    ret.put(WXPickersModule.DATA, result);
                    callback.invoke(ret);
                } else {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                    ret.put(WXPickersModule.DATA, null);
                    callback.invoke(ret);
                }
            }
        }, options);
    }

    private void performSinglePick(List<String> items, final Map<String, Object> options, final JSCallback callback) {
        this.selected = this.getOption(options, KEY_INDEX, 0);
        final int textColor = this.getColor(options, KEY_TEXT_COLOR, 0);
        final int selectionColor = this.getColor(options, KEY_SELECTION_COLOR, 0);
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this.mWXSDKInstance.getContext(), 17367055, items){

            @NonNull
            public View getView(int position, View convertView, @Nullable ViewGroup parent) {
                View itemView = super.getView(position, convertView, parent);
                if (itemView != null && itemView instanceof Checkable) {
                    boolean needSelected = position == WXPickersModule.this.selected;
                    ((Checkable)itemView).setChecked(needSelected);
                    if (needSelected) {
                        itemView.setBackgroundColor(selectionColor);
                    } else {
                        itemView.setBackgroundColor(0);
                    }
                }
                if (itemView instanceof TextView && textColor != 0) {
                    ((TextView)itemView).setTextColor(textColor);
                }
                return itemView;
            }
        };
        final AlertDialog dialog = new AlertDialog.Builder(this.mWXSDKInstance.getContext()).setAdapter((ListAdapter)adapter, null).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HashMap<String, Object> ret = new HashMap<String, Object>(2);
                ret.put(WXPickersModule.RESULT, WXPickersModule.SUCCESS);
                ret.put(WXPickersModule.DATA, WXPickersModule.this.selected);
                callback.invoke(ret);
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HashMap<String, Object> ret = new HashMap<String, Object>(2);
                ret.put(WXPickersModule.RESULT, WXPickersModule.CANCEL);
                ret.put(WXPickersModule.DATA, -1);
                callback.invoke(ret);
            }
        }).setCustomTitle((View)this.makeTitleView(this.mWXSDKInstance.getContext(), options)).create();
        if (Build.VERSION.SDK_INT >= 21) {
            dialog.create();
        }
        ListView listView = dialog.getListView();
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener((ArrayAdapter)adapter){
            final /* synthetic */ ArrayAdapter val$adapter;
            {
                this.val$adapter = arrayAdapter;
            }

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                WXPickersModule.this.selected = position;
                this.val$adapter.notifyDataSetChanged();
            }
        });
        dialog.getWindow().getDecorView().post(WXThread.secure(new Runnable(){

            @Override
            public void run() {
                Button confirm = dialog.getButton(-1);
                Button cancel = dialog.getButton(-2);
                if (confirm != null) {
                    String confirmTitle = (String)WXPickersModule.this.getOption(options, WXPickersModule.KEY_CONFIRM_TITLE, null);
                    int confirmColor = WXPickersModule.this.getColor(options, WXPickersModule.KEY_CONFIRM_TITLE_COLOR, 0);
                    if (confirmTitle != null) {
                        confirm.setText((CharSequence)confirmTitle);
                        confirm.setAllCaps(false);
                    }
                    if (confirmColor != 0) {
                        confirm.setTextColor(confirmColor);
                        confirm.setAllCaps(false);
                    }
                }
                if (cancel != null) {
                    String cancelTitle = (String)WXPickersModule.this.getOption(options, WXPickersModule.KEY_CANCEL_TITLE, null);
                    int cancelColor = WXPickersModule.this.getColor(options, WXPickersModule.KEY_CANCEL_TITLE_COLOR, 0);
                    if (cancelTitle != null) {
                        cancel.setText((CharSequence)cancelTitle);
                    }
                    if (cancelColor != 0) {
                        cancel.setTextColor(cancelColor);
                    }
                }
            }
        }));
        dialog.show();
    }

    private TextView makeTitleView(Context context, Map<String, Object> options) {
        String text = this.getOption(options, KEY_TITLE, null);
        if (text == null) {
            return null;
        }
        TextView textView = new TextView(context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        textView.setTextSize(2, 20.0f);
        int padding = WXViewUtils.dip2px(12.0f);
        textView.setPadding(padding, padding, padding, padding);
        textView.getPaint().setFakeBoldText(true);
        textView.setBackgroundColor(this.getColor(options, KEY_TITLE_BACKGROUND_COLOR, 0));
        textView.setTextColor(this.getColor(options, KEY_TITLE_COLOR, -16777216));
        textView.setText((CharSequence)text);
        return textView;
    }
}

