/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import java.util.ArrayList;
import java.util.List;

public class WXHorizontalScrollView
extends HorizontalScrollView
implements IWXScroller,
WXGestureObservable {
    private WXGesture wxGesture;
    private ScrollViewListener mScrollViewListener;
    private List<ScrollViewListener> mScrollViewListeners;
    private boolean scrollable = true;

    public WXHorizontalScrollView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setOverScrollMode(2);
    }

    public WXHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mScrollViewListener != null) {
            this.mScrollViewListener.onScrollChanged(this, l, t, oldl, oldt);
        }
        if (this.mScrollViewListeners != null) {
            for (ScrollViewListener listener : this.mScrollViewListeners) {
                listener.onScrollChanged(this, l, t, oldl, oldt);
            }
        }
    }

    public void setScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListener = scrollViewListener;
    }

    @Override
    public void destroy() {
    }

    public void addScrollViewListener(ScrollViewListener scrollViewListener) {
        if (this.mScrollViewListeners == null) {
            this.mScrollViewListeners = new ArrayList<ScrollViewListener>();
        }
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
        }
    }

    public void removeScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.scrollable) {
            return true;
        }
        return super.onTouchEvent(ev);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public Rect getContentFrame() {
        return new Rect(0, 0, this.computeHorizontalScrollRange(), this.computeVerticalScrollRange());
    }

    public static interface ScrollViewListener {
        public void onScrollChanged(WXHorizontalScrollView var1, int var2, int var3, int var4, int var5);
    }
}

