/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class WXFrameLayout
extends FrameLayout
implements WXGestureObservable,
IRenderStatus<WXDiv>,
IRenderResult<WXDiv> {
    private WXGesture wxGesture;
    private WeakReference<WXDiv> mWeakReference;
    private List<Widget> mWidgets;

    public WXFrameLayout(Context context) {
        super(context);
    }

    @Override
    public void registerGestureListener(WXGesture wxGesture) {
        this.wxGesture = wxGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        boolean result = super.dispatchTouchEvent(event);
        if (this.wxGesture != null) {
            result |= this.wxGesture.onTouch((View)this, event);
        }
        return result;
    }

    @Override
    public void holdComponent(WXDiv component) {
        this.mWeakReference = new WeakReference<WXDiv>(component);
    }

    @Override
    @Nullable
    public WXDiv getComponent() {
        return null != this.mWeakReference ? (WXDiv)this.mWeakReference.get() : null;
    }

    public void mountFlatGUI(List<Widget> widgets) {
        this.mWidgets = widgets;
        if (this.mWidgets != null) {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public void unmountFlatGUI() {
        this.mWidgets = null;
        this.setWillNotDraw(false);
        this.invalidate();
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return this.mWidgets != null || super.verifyDrawable(who);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            this.dispatchDrawInterval(canvas);
        }
        catch (Throwable e) {
            if (this.getComponent() != null) {
                this.notifyLayerOverFlow();
                this.reportLayerOverFlowError();
            }
            WXLogUtils.e("Layer overflow limit error", WXLogUtils.getStackTrace(e));
        }
    }

    private int reportLayerOverFlowError() {
        int deep = this.calLayerDeep((View)this, 0);
        if (this.getComponent() != null) {
            WXExceptionUtils.commitCriticalExceptionRT(this.getComponent().getInstanceId(), WXErrorCode.WX_RENDER_ERR_LAYER_OVERFLOW, "draw android view", WXErrorCode.WX_RENDER_ERR_LAYER_OVERFLOW.getErrorMsg() + "Layer overflow limit error: " + deep + " layers!", null);
        }
        return deep;
    }

    private void dispatchDrawInterval(Canvas canvas) {
        if (this.mWidgets != null) {
            canvas.save();
            canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            for (Widget widget : this.mWidgets) {
                widget.draw(canvas);
            }
            canvas.restore();
        } else {
            WXViewUtils.clipCanvasWithinBorderBox((View)this, canvas);
            super.dispatchDraw(canvas);
        }
    }

    private int calLayerDeep(View view, int deep) {
        ++deep;
        if (view.getParent() != null && view.getParent() instanceof View) {
            return this.calLayerDeep((View)view.getParent(), deep);
        }
        return deep;
    }

    public void notifyLayerOverFlow() {
        if (this.getComponent() == null) {
            return;
        }
        WXSDKInstance instance = this.getComponent().getInstance();
        if (instance == null) {
            return;
        }
        if (instance.getLayerOverFlowListeners() == null) {
            return;
        }
        for (String ref : instance.getLayerOverFlowListeners()) {
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(instance.getInstanceId(), ref);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ref", ref);
            params.put("instanceid", component.getInstanceId());
            component.fireEvent("layeroverflow", params);
        }
    }
}

