/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.performance;

import android.text.TextUtils;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXJSExceptionInfo;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class WXInstanceExceptionRecord {
    public static int sErrorMsgSizeLimit = 5;
    public static final String KEY_EXP_STAGE_LIST = "wxStageList";
    private final Map<String, Long> mStageMap;
    public final List<String> errorList;
    public final String instanceId;
    public final AtomicBoolean hasAddView;
    public final AtomicBoolean hasDegrade;
    private boolean mHasReportScreenEmpty = false;
    private boolean mBeginRender = false;
    public boolean isDownLoadBundleFailed = false;
    public static boolean isReportWriteScreen = false;

    public WXInstanceExceptionRecord(String instanceId) {
        this.instanceId = instanceId;
        this.mStageMap = new ConcurrentHashMap<String, Long>();
        this.errorList = new CopyOnWriteArrayList<String>();
        this.hasAddView = new AtomicBoolean(false);
        this.hasDegrade = new AtomicBoolean(false);
    }

    public void recordErrorMsg(WXJSExceptionInfo exceptionInfo) {
        if (isReportWriteScreen) {
            return;
        }
        if (null == exceptionInfo) {
            return;
        }
        if (exceptionInfo.getErrCode().getErrorType() == WXErrorCode.ErrorType.RENDER_ERROR) {
            this.mHasReportScreenEmpty = true;
            return;
        }
        this.recordReportErrorMsg(exceptionInfo.toString());
    }

    public void recordReportErrorMsg(String appendStr) {
        if (!isReportWriteScreen) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)appendStr) || this.hasAddView.get() || this.hasDegrade.get()) {
            return;
        }
        if (this.errorList.size() > sErrorMsgSizeLimit) {
            this.errorList.remove(0);
        }
        this.errorList.add("time " + System.currentTimeMillis() + ",msg " + appendStr);
    }

    public void recordStage(String stage, long time) {
        if ("wxRenderTimeOrigin".equals(stage) || "wxStartDownLoadBundle".equals(stage) || "wxEndLoadBundle".equals(stage)) {
            this.setBeginRender(true);
        }
        this.mStageMap.put(stage, time);
    }

    public void setBeginRender(boolean isBegin) {
        this.mBeginRender = true;
    }

    public String convertStageToStr() {
        if (this.mStageMap.isEmpty()) {
            return "noStageRecord";
        }
        ArrayList<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(this.mStageMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return (int)(o1.getValue() - o2.getValue());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : list) {
            builder.append((String)entry.getKey()).append(':').append(entry.getValue()).append("->");
        }
        return builder.toString();
    }

    private String convertExceptionListToString() {
        if (this.errorList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String info : this.errorList) {
            builder.append("error_").append(i).append(": ").append(info).append("--->");
        }
        return builder.toString();
    }

    public void checkEmptyScreenAndReport() {
        if (!isReportWriteScreen) {
            return;
        }
        if (this.isDownLoadBundleFailed || !this.mBeginRender || this.mHasReportScreenEmpty || this.hasAddView.get() || this.hasDegrade.get()) {
            return;
        }
        if (!this.mStageMap.containsKey("wxJSBundleCreateFinish")) {
            return;
        }
        Long startExecJsTime = this.mStageMap.get("wxEndLoadBundle");
        if (null == startExecJsTime) {
            return;
        }
        long currentTime = WXUtils.getFixUnixTime();
        long jsExecTime = currentTime - startExecJsTime;
        if (jsExecTime <= 4000L) {
            return;
        }
        if (this.errorList.isEmpty()) {
            String errorMsg = "whiteScreen :never add view until page destroy,(js has execute > 4s,has createFinish)";
        } else {
            String errorMsg = "whiteScreen :history exception :" + this.convertExceptionListToString();
        }
        HashMap<String, String> flagMap = new HashMap<String, String>(4);
        flagMap.put("wxBeginRender", String.valueOf(this.mBeginRender));
        flagMap.put("wxHasAddView", String.valueOf(this.hasAddView.get()));
        flagMap.put("wxHasDegrade", String.valueOf(this.hasDegrade.get()));
        flagMap.put("wxHasReportScreenEmpty", String.valueOf(this.mHasReportScreenEmpty));
        flagMap.put("wxJSExecTime", String.valueOf(jsExecTime));
    }

    public Long getStageTime(String key) {
        return this.mStageMap.get(key);
    }

    public String toString() {
        return super.toString() + "wxStageList :" + this.convertStageToStr() + "wxErrorList :" + this.convertExceptionListToString();
    }
}

