/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.base.CalledByNative;
import com.taobao.weex.bridge.ResultCallback;
import com.taobao.weex.bridge.ResultCallbackManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXWsonJSONSwitch;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class WXBridge
implements IWXBridge {
    public static final boolean MULTIPROCESS = true;
    public static final String TAG = "WXBridge";

    private native int nativeInitFrameworkEnv(String var1, WXParams var2, String var3, boolean var4);

    private native int nativeInitFramework(String var1, WXParams var2);

    private native void nativeRefreshInstance(String var1, String var2, String var3, WXJSObject[] var4);

    private native int nativeExecJS(String var1, String var2, String var3, WXJSObject[] var4);

    private native int nativeExecJSService(String var1);

    public native byte[] nativeExecJSWithResult(String var1, String var2, String var3, WXJSObject[] var4);

    public native void nativeExecJSWithCallback(String var1, String var2, String var3, WXJSObject[] var4, long var5);

    public native int nativeCreateInstanceContext(String var1, String var2, String var3, WXJSObject[] var4);

    public native int nativeDestoryInstance(String var1, String var2, String var3, WXJSObject[] var4);

    public native String nativeExecJSOnInstance(String var1, String var2, int var3);

    public native void nativeFireEventOnDataRenderNode(String var1, String var2, String var3, String var4);

    public native void nativeRegisterModuleOnDataRenderNode(String var1);

    private native void nativeTakeHeapSnapshot(String var1);

    private native void nativeBindMeasurementToRenderObject(long var1);

    private native void nativeSetRenderContainerWrapContent(boolean var1, String var2);

    public native long[] nativeGetFirstScreenRenderTime(String var1);

    public native long[] nativeGetRenderFinishTime(String var1);

    private native void nativeSetDefaultHeightAndWidthIntoRootDom(String var1, float var2, float var3, boolean var4, boolean var5);

    private native void nativeOnInstanceClose(String var1);

    private native void nativeForceLayout(String var1);

    private native boolean nativeNotifyLayout(String var1);

    private native void nativeSetStyleWidth(String var1, String var2, float var3);

    private native void nativeSetStyleHeight(String var1, String var2, float var3);

    private native void nativeSetMargin(String var1, String var2, int var3, float var4);

    private native void nativeSetPadding(String var1, String var2, int var3, float var4);

    private native void nativeSetPosition(String var1, String var2, int var3, float var4);

    private native void nativeMarkDirty(String var1, String var2, boolean var3);

    private native void nativeRegisterCoreEnv(String var1, String var2);

    private native void nativeResetWXBridge(Object var1, String var2);

    public native void nativeUpdateGlobalConfig(String var1);

    @Override
    public int initFramework(String framework, WXParams params) {
        return this.nativeInitFramework(framework, params);
    }

    @Override
    public int initFrameworkEnv(String framework, WXParams params, String cacheDir, boolean pieSupport) {
        return this.nativeInitFrameworkEnv(framework, params, cacheDir, pieSupport);
    }

    @Override
    public void refreshInstance(String instanceId, String namespace, String function, WXJSObject[] args) {
        this.nativeRefreshInstance(instanceId, namespace, function, args);
    }

    @Override
    public int execJS(String instanceId, String namespace, String function, WXJSObject[] args) {
        return this.nativeExecJS(instanceId, namespace, function, args);
    }

    @Override
    public void execJSWithCallback(String instanceId, String namespace, String function, WXJSObject[] args, ResultCallback callback) {
        if (callback == null) {
            this.execJS(instanceId, namespace, function, args);
        }
        this.nativeExecJSWithCallback(instanceId, namespace, function, args, ResultCallbackManager.generateCallbackId(callback));
    }

    @CalledByNative
    public void onReceivedResult(long callbackId, byte[] result) {
        ResultCallback callback = ResultCallbackManager.removeCallbackById(callbackId);
        if (callback != null) {
            callback.onReceiveResult(result);
        }
    }

    @Override
    public int execJSService(String javascript) {
        return this.nativeExecJSService(javascript);
    }

    @Override
    public void takeHeapSnapshot(String filename) {
        this.nativeTakeHeapSnapshot(filename);
    }

    @Override
    public int createInstanceContext(String instanceId, String name, String function, WXJSObject[] args) {
        return this.nativeCreateInstanceContext(instanceId, name, function, args);
    }

    @Override
    public int destoryInstance(String instanceId, String name, String function, WXJSObject[] args) {
        return this.nativeDestoryInstance(instanceId, name, function, args);
    }

    @Override
    public String execJSOnInstance(String instanceId, String script, int type) {
        return this.nativeExecJSOnInstance(instanceId, script, type);
    }

    @Override
    @CalledByNative
    public int callNative(String instanceId, byte[] tasks, String callback) {
        return this.callNative(instanceId, JSON.parseArray((String)new String(tasks)), callback);
    }

    @Override
    public int callNative(String instanceId, String tasks, String callback) {
        try {
            return this.callNative(instanceId, JSONArray.parseArray((String)tasks), callback);
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, "callNative throw exception: " + e.getMessage());
            return 1;
        }
    }

    private int callNative(String instanceId, JSONArray tasks, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callNative(instanceId, tasks, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callNative throw exception:" + e.getMessage());
        }
        if (WXEnvironment.isApkDebugable() && errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public void reportJSException(String instanceId, String func, String exception) {
        WXBridgeManager.getInstance().reportJSException(instanceId, func, exception);
    }

    @Override
    @CalledByNative
    public Object callNativeModule(String instanceId, String module, String method, byte[] arguments, byte[] options) {
        try {
            WXSDKInstance sdkInstance;
            long start = WXUtils.getFixUnixTime();
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            JSONArray argArray = null;
            if (arguments != null) {
                argArray = instance != null && (instance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER || instance.getRenderStrategy() == WXRenderStrategy.DATA_RENDER_BINARY) ? (JSONArray)JSON.parse((String)new String(arguments, "UTF-8")) : (JSONArray)WXWsonJSONSwitch.parseWsonOrJSON(arguments);
            }
            JSONObject optionsObj = null;
            if (options != null) {
                optionsObj = (JSONObject)WXWsonJSONSwitch.parseWsonOrJSON(options);
            } else if (argArray != null && (sdkInstance = WXSDKManager.getInstance().getSDKInstance(instanceId)) != null && WXBridgeManager.BundType.Rax.equals((Object)sdkInstance.bundleType)) {
                Object weex_options__ = null;
                for (Object object : argArray) {
                    if (!(object instanceof JSONObject) || !((JSONObject)object).containsKey((Object)"__weex_options__")) continue;
                    weex_options__ = ((JSONObject)object).get((Object)"__weex_options__");
                }
                if (weex_options__ instanceof JSONObject) {
                    optionsObj = (JSONObject)weex_options__;
                }
            }
            Object object = WXBridgeManager.getInstance().callNativeModule(instanceId, module, method, argArray, optionsObj);
            if (null != instance) {
                instance.getApmForInstance().updateFSDiffStats("wxFSCallNativeTotalNum", 1.0);
                instance.getApmForInstance().updateFSDiffStats("wxFSCallNativeTotalTime", WXUtils.getFixUnixTime() - start);
            }
            return WXWsonJSONSwitch.toWsonOrJsonWXJSObject(object);
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
            return new WXJSObject(null);
        }
    }

    @Override
    @CalledByNative
    public void callNativeComponent(String instanceId, String ref, String method, byte[] arguments, byte[] optionsData) {
        try {
            JSONArray argArray = (JSONArray)WXWsonJSONSwitch.parseWsonOrJSON(arguments);
            Object options = WXWsonJSONSwitch.parseWsonOrJSON(optionsData);
            WXBridgeManager.getInstance().callNativeComponent(instanceId, ref, method, argArray, options);
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
        }
    }

    @Override
    @CalledByNative
    public void setTimeoutNative(String callbackId, String time) {
        WXBridgeManager.getInstance().setTimeout(callbackId, time);
    }

    @Override
    @CalledByNative
    public void setJSFrmVersion(String version) {
        if (version != null) {
            WXEnvironment.JS_LIB_SDK_VERSION = version;
        }
    }

    @Override
    public void resetWXBridge(boolean remoteDebug) {
        String className = this.getClass().getName().replace('.', '/');
        this.nativeResetWXBridge(this, className);
    }

    @Override
    @CalledByNative
    public int callUpdateFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callRefreshFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRefreshFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public void reportServerCrash(String instanceId, String crashFile) {
        block2: {
            WXLogUtils.e(TAG, "reportServerCrash instanceId:" + instanceId + " crashFile: " + crashFile);
            int errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callReportCrashReloadPage(instanceId, crashFile);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "reloadPageNative throw exception:" + e.getMessage());
            }
        }
    }

    @Override
    @CalledByNative
    public int callCreateBody(String instanceId, String componentType, String ref, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callCreateBody(instanceId, componentType, ref, styles, attributes, events, margins, paddings, borders);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callAddElement(String instanceId, String componentType, String ref, int index, String parentRef, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders, boolean willLayout) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callAddElement(instanceId, componentType, ref, index, parentRef, styles, attributes, events, margins, paddings, borders, willLayout);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                e.printStackTrace();
                WXLogUtils.e(TAG, "callAddElement throw error:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callRemoveElement(String instanceId, String ref) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveElement(instanceId, ref);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callRemoveElement throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callMoveElement(String instanceId, String ref, String parentref, int index) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callMoveElement(instanceId, ref, parentref, index);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callMoveElement throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callAddEvent(String instanceId, String ref, String event) {
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callAddEvent(instanceId, ref, event);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callAddEvent throw exception:" + e.getMessage());
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callRemoveEvent(String instanceId, String ref, String event) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveEvent(instanceId, ref, event);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callRemoveEvent throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callUpdateStyle(String instanceId, String ref, HashMap<String, Object> styles, HashMap<String, String> paddings, HashMap<String, String> margins, HashMap<String, String> borders) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateStyle(instanceId, ref, styles, paddings, margins, borders);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callUpdateStyle throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callUpdateAttrs(String instanceId, String ref, HashMap<String, String> attrs) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateAttrs(instanceId, ref, attrs);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callUpdateAttr throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callLayout(String instanceId, String ref, int top, int bottom, int left, int right, int height, int width, boolean isRTL, int index) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callLayout(instanceId, ref, top, bottom, left, right, height, width, isRTL, index);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callLayout throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callCreateFinish(String instanceId) {
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callCreateFinish(instanceId);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callRenderSuccess(String instanceId) {
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callRenderSuccess(instanceId);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callAppendTreeCreateFinish(String instanceId, String ref) {
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callAppendTreeCreateFinish(instanceId, ref);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callAppendTreeCreateFinish throw exception:" + e.getMessage());
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public int callHasTransitionPros(String instanceId, String ref, HashMap<String, String> styles) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callHasTransitionPros(instanceId, ref, styles);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callHasTransitionPros throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    @CalledByNative
    public ContentBoxMeasurement getMeasurementFunc(String instanceId, long renderObjectPtr) {
        ContentBoxMeasurement obj;
        block2: {
            obj = null;
            try {
                obj = WXBridgeManager.getInstance().getMeasurementFunc(instanceId, renderObjectPtr);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "getMeasurementFunc throw exception:" + e.getMessage());
            }
        }
        return obj;
    }

    @Override
    public void bindMeasurementToRenderObject(long ptr) {
        this.nativeBindMeasurementToRenderObject(ptr);
    }

    @Override
    public void setRenderContainerWrapContent(boolean wrap, String instanceId) {
        this.nativeSetRenderContainerWrapContent(wrap, instanceId);
    }

    @Override
    public long[] getFirstScreenRenderTime(String instanceId) {
        return this.nativeGetFirstScreenRenderTime(instanceId);
    }

    @Override
    public long[] getRenderFinishTime(String instanceId) {
        return this.nativeGetRenderFinishTime(instanceId);
    }

    @Override
    public void setDefaultHeightAndWidthIntoRootDom(String instanceId, float defaultWidth, float defaultHeight, boolean isWidthWrapContent, boolean isHeightWrapContent) {
        this.nativeSetDefaultHeightAndWidthIntoRootDom(instanceId, defaultWidth, defaultHeight, isWidthWrapContent, isHeightWrapContent);
    }

    @Override
    public void onInstanceClose(String instanceId) {
        this.nativeOnInstanceClose(instanceId);
    }

    @Override
    public void forceLayout(String instanceId) {
        this.nativeForceLayout(instanceId);
    }

    @Override
    public boolean notifyLayout(String instanceId) {
        return this.nativeNotifyLayout(instanceId);
    }

    @Override
    public void setStyleWidth(String instanceId, String ref, float value) {
        this.nativeSetStyleWidth(instanceId, ref, value);
    }

    @Override
    public void setMargin(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetMargin(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void setPadding(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetPadding(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void setPosition(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetPosition(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void markDirty(String instanceId, String ref, boolean dirty) {
        this.nativeMarkDirty(instanceId, ref, dirty);
    }

    @Override
    public void setStyleHeight(String instanceId, String ref, float value) {
        this.nativeSetStyleHeight(instanceId, ref, value);
    }

    @Override
    public void registerCoreEnv(String key, String value) {
        this.nativeRegisterCoreEnv(key, value);
    }

    @Override
    @CalledByNative
    public void reportNativeInitStatus(String statusCode, String errorMsg) {
        if (WXErrorCode.WX_JS_FRAMEWORK_INIT_SINGLE_PROCESS_SUCCESS.getErrorCode().equals(statusCode) || WXErrorCode.WX_JS_FRAMEWORK_INIT_FAILED.getErrorCode().equals(statusCode)) {
            IWXUserTrackAdapter userTrackAdapter = WXSDKManager.getInstance().getIWXUserTrackAdapter();
            if (userTrackAdapter != null) {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>(3);
                params.put("errCode", (Serializable)((Object)statusCode));
                params.put("arg", (Serializable)((Object)"InitFrameworkNativeError"));
                params.put("errMsg", (Serializable)((Object)errorMsg));
                Log.e((String)"Dyy", (String)("reportNativeInitStatus is running and errorCode is " + statusCode + " And errorMsg is " + errorMsg));
                userTrackAdapter.commit(null, null, "initFramework", null, params);
            }
            return;
        }
        if (WXErrorCode.WX_JS_FRAMEWORK_INIT_FAILED_PARAMS_NULL.getErrorCode().equals(statusCode)) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_JS_FRAMEWORK_INIT_FAILED_PARAMS_NULL, "WeexProxy::initFromParam()", WXErrorCode.WX_JS_FRAMEWORK_INIT_FAILED_PARAMS_NULL.getErrorMsg() + ": " + errorMsg, null);
            return;
        }
        for (WXErrorCode e : WXErrorCode.values()) {
            if (!e.getErrorType().equals((Object)WXErrorCode.ErrorType.NATIVE_ERROR) || !e.getErrorCode().equals(statusCode)) continue;
            WXExceptionUtils.commitCriticalExceptionRT(null, e, "initFramework", errorMsg, null);
            break;
        }
    }

    @Override
    public void fireEventOnDataRenderNode(String instanceId, String ref, String type, String data) {
        this.nativeFireEventOnDataRenderNode(instanceId, ref, type, data);
    }

    public void registerModuleOnDataRenderNode(String data) {
        this.nativeRegisterModuleOnDataRenderNode(data);
    }
}

