/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import com.alibaba.fastjson.JSON;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.wson.Wson;
import com.taobao.weex.wson.WsonUtils;

public class WXWsonJSONSwitch {
    private static final String TAG = "WXSwitch";
    public static boolean USE_WSON = true;
    public static final String WSON_OFF = "wson_off";

    public static final byte[] convertJSONToWsonIfUseWson(byte[] json) {
        if (!USE_WSON) {
            return json;
        }
        if (json == null) {
            return null;
        }
        String str = new String(json);
        if (str.startsWith("[")) {
            return WsonUtils.toWson(JSON.parseArray((String)str));
        }
        return WsonUtils.toWson(JSON.parse((String)str));
    }

    public static final Object parseWsonOrJSON(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (USE_WSON) {
                return Wson.parse(data);
            }
            return JSON.parse((String)new String(data, "UTF-8"));
        }
        catch (Exception e) {
            WXLogUtils.e(TAG, e);
            if (USE_WSON) {
                return JSON.parse((String)new String(data));
            }
            return Wson.parse(data);
        }
    }

    public static final WXJSObject toWsonOrJsonWXJSObject(Object tasks) {
        if (tasks == null) {
            return new WXJSObject(null);
        }
        if (tasks.getClass() == WXJSObject.class) {
            return (WXJSObject)tasks;
        }
        if (USE_WSON) {
            return new WXJSObject(4, Wson.toWson(tasks));
        }
        return new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(tasks));
    }

    public static final Object convertWXJSObjectDataToJSON(WXJSObject object) {
        if (object.type == 4) {
            return JSON.parse((String)Wson.parse((byte[])object.data).toString());
        }
        return JSON.parse((String)object.data.toString());
    }
}

