/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.template.CellDataManager;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.utils.WXLogUtils;

public class UpdateComponentDataAction
extends BasicGraphicAction {
    private String virtualComponentId;
    private JSONObject data;
    private String callback;

    public UpdateComponentDataAction(String pageId, String virtualComponentId, JSONObject data, String callback) {
        super(pageId, CellDataManager.getListRef(virtualComponentId));
        this.virtualComponentId = virtualComponentId;
        this.data = data;
        this.callback = callback;
    }

    @Override
    public void executeAction() {
        if (TextUtils.isEmpty((CharSequence)this.getRef())) {
            WXLogUtils.e("wrong virtualComponentId split error " + this.virtualComponentId);
            return;
        }
        WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
        if (component instanceof WXRecyclerTemplateList) {
            WXRecyclerTemplateList templateList = (WXRecyclerTemplateList)component;
            templateList.getCellDataManager().updateVirtualComponentData(this.virtualComponentId, this.data);
            templateList.notifyUpdateList();
            SimpleJSCallback jsCallback = new SimpleJSCallback(component.getInstanceId(), this.callback);
            jsCallback.invoke(true);
        } else {
            WXLogUtils.e("recycler-list wrong virtualComponentId " + this.virtualComponentId);
        }
    }
}

