/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.el.parse;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.el.parse.Block;
import com.taobao.weex.el.parse.Operator;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.el.parse.Symbol;
import com.taobao.weex.el.parse.Token;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;

public class Parser {
    private String code;
    private int position;
    private ArrayStack<Token> stacks;
    private ArrayStack<Symbol> operators;

    public Parser(String code) {
        this.code = code;
        this.position = 0;
        this.stacks = new ArrayStack();
        this.operators = new ArrayStack();
    }

    public final Token parse() {
        while (this.hasNextToken()) {
            this.scanNextToken();
        }
        while (!this.operators.isEmpty()) {
            Symbol op = this.operators.pop();
            this.doOperator(op);
        }
        if (this.stacks.size() == 1) {
            return this.stacks.pop();
        }
        Block block = new Block(this.stacks.getList(), 6);
        return block;
    }

    public static Token parse(String code) {
        try {
            Parser parser = new Parser(code);
            return parser.parse();
        }
        catch (Exception e) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("code " + code, e);
            }
            return new Block(null, 6);
        }
    }

    final char scanNextToken() {
        char ch = this.nextToken();
        if (ch == '$') {
            ++this.position;
            return ch;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            this.scanIdentifier();
        } else if (ch == '(' || ch == '{') {
            this.scanBracket();
        } else if (ch == '[') {
            this.scanArray();
        } else if (ch == '\"' || ch == '\'') {
            this.scanString();
        } else if (ch == '.' && Character.isDigit(this.code.charAt(this.position + 1)) || Character.isDigit(ch)) {
            this.scanNumber();
        } else if (ch == '?') {
            this.scanIf();
        } else {
            if (ch == ':' || ch == ')' || ch == '}' || ch == ' ' || ch == ']') {
                ++this.position;
                return ch;
            }
            this.scanOperator();
        }
        return ch;
    }

    final void scanArray() {
        char token;
        int stackSize = this.stacks.size();
        int opSize = this.operators.size();
        int type = 0;
        if (this.position - 1 < 0 || !Character.isJavaIdentifierPart(this.code.charAt(this.position - 1))) {
            type = 7;
        }
        this.operators.push(new Symbol("[", this.stacks.size()));
        ++this.position;
        while (this.hasNextToken() && (token = this.scanNextToken()) != ']') {
        }
        if (this.stacks.size() <= stackSize) {
            while (this.operators.size() > opSize) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > opSize) {
            Symbol op = this.operators.pop();
            if (this.stacks.size() <= stackSize) continue;
            this.doOperator(op);
        }
        ArrayList<Token> tokens = new ArrayList<Token>(4);
        for (int i = stackSize; i < this.stacks.size(); ++i) {
            tokens.add(this.stacks.get(i));
        }
        while (this.stacks.size() > stackSize) {
            this.stacks.pop();
        }
        if (type == 7 || this.stacks.size() == 0) {
            Block block = new Block(tokens, 7);
            this.stacks.push(block);
            return;
        }
        Token identifer = this.stacks.pop();
        Token second = null;
        second = tokens.size() == 1 ? (Token)tokens.get(0) : new Block(tokens, 6);
        Operator operator = new Operator(".", type);
        operator.first = identifer;
        operator.second = second;
        this.stacks.push(operator);
    }

    void scanBracket() {
        int stackSize = this.stacks.size();
        int opSize = this.operators.size();
        if (this.code.charAt(this.position) == '{') {
            this.operators.push(new Symbol("{", this.stacks.size()));
            ++this.position;
            while (this.hasNextToken() && this.scanNextToken() != '}') {
            }
        } else {
            this.operators.push(new Symbol("(", this.stacks.size()));
            ++this.position;
            while (this.hasNextToken() && this.scanNextToken() != ')') {
            }
        }
        if (this.stacks.size() <= stackSize) {
            while (this.operators.size() > opSize) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > opSize) {
            Symbol op = this.operators.pop();
            if (this.stacks.size() <= stackSize) continue;
            this.doOperator(op);
        }
        ArrayList<Token> tokens = new ArrayList<Token>(4);
        for (int i = stackSize; i < this.stacks.size(); ++i) {
            tokens.add(this.stacks.get(i));
        }
        while (this.stacks.size() > stackSize) {
            this.stacks.pop();
        }
        if (tokens.size() == 1) {
            this.stacks.push((Token)tokens.get(0));
        } else {
            Block block = new Block(tokens, 6);
            this.stacks.push(block);
        }
    }

    void scanOperator() {
        String preOp;
        int start = this.position;
        int length = Math.min(this.position + 3, this.code.length());
        String operator = this.code.substring(this.position, length);
        if (operator.length() >= 3 && !Operators.OPERATORS_PRIORITY.containsKey(operator)) {
            operator = operator.substring(0, 2);
        }
        if (operator.length() >= 2 && !Operators.OPERATORS_PRIORITY.containsKey(operator)) {
            operator = operator.substring(0, 1);
        }
        if (!Operators.OPERATORS_PRIORITY.containsKey(operator)) {
            int illegalChar = Math.min(start + 1, this.code.length());
            WXLogUtils.e("weex", new IllegalArgumentException(this.code.substring(0, illegalChar) + " illegal code operator" + operator));
            this.position += operator.length();
            return;
        }
        if (!this.operators.isEmpty() && this.operators.peek() != null && Operators.OPERATORS_PRIORITY.get(preOp = this.operators.peek().op) >= Operators.OPERATORS_PRIORITY.get(operator)) {
            Symbol op = this.operators.pop();
            this.doOperator(op);
        }
        if (!Operators.isOpEnd(operator)) {
            this.operators.push(new Symbol(operator, this.stacks.size()));
        }
        this.position += operator.length();
    }

    void doOperator(Symbol symbol) {
        String op = symbol.op;
        if ("(".equals(symbol.op) || "{".equals(symbol.op) || "[".equals(symbol.op) || "$".equals(symbol.op)) {
            return;
        }
        if ("{".equals(symbol.op)) {
            return;
        }
        int second = symbol.pos;
        int first = Math.max(symbol.pos - 1, 0);
        if (!this.operators.isEmpty()) {
            first = Math.max(first, this.operators.peek().pos);
        }
        Operator operator = new Operator(op, 5);
        if ("!".equals(op)) {
            if (this.stacks.size() > second) {
                Token token;
                operator.self = token = this.stacks.remove(second);
                this.stacks.add(second, operator);
                return;
            }
            return;
        }
        if (this.stacks.size() <= second) {
            return;
        }
        operator.second = this.stacks.remove(second);
        if (this.stacks.size() > first) {
            operator.first = this.stacks.remove(first);
        } else if (operator.second == null) {
            return;
        }
        this.stacks.add(first, operator);
    }

    void scanIf() {
        Operator operator = new Operator("?", 5);
        int selfIndex = 0;
        this.doStackOperators(0);
        if (this.operators.size() > 0) {
            selfIndex = Math.max(this.operators.peek().pos, selfIndex);
        }
        if (this.stacks.size() > selfIndex) {
            operator.self = this.stacks.pop();
        }
        int stackSize = this.stacks.size();
        int leftOperatorSize = this.operators.size();
        ++this.position;
        while (this.hasNextToken() && this.scanNextToken() != ':') {
        }
        while (this.operators.size() > leftOperatorSize) {
            Symbol symbol = this.operators.pop();
            this.doOperator(symbol);
        }
        while (this.stacks.size() > stackSize) {
            operator.first = this.stacks.pop();
        }
        int rightOperatorsSize = this.operators.size();
        while (this.hasNextToken()) {
            this.scanNextToken();
            if (this.hasNextToken()) {
                this.scanNextToken();
            }
            if (this.operators.size() > rightOperatorsSize) continue;
        }
        this.doStackOperators(rightOperatorsSize);
        while (this.stacks.size() > stackSize) {
            operator.second = this.stacks.pop();
        }
        this.stacks.push(operator);
    }

    private final void doStackOperators(int operatorSize) {
        while (this.operators.size() > operatorSize) {
            Symbol symbol = this.operators.pop();
            this.doOperator(symbol);
        }
    }

    final void scanNumber() {
        char ch;
        boolean isInt = true;
        int start = this.position;
        if (this.code.charAt(this.position) == 'e' || this.code.charAt(this.position) == '.') {
            isInt = false;
        }
        ++this.position;
        while (this.hasNext() && (Character.isDigit(ch = this.code.charAt(this.position)) || ch == '.' || ch == 'e')) {
            if (ch == 'e' || ch == '.') {
                isInt = false;
            }
            ++this.position;
        }
        String number = this.code.substring(start, this.position);
        if (".".equals(number)) {
            return;
        }
        Token stack = null;
        stack = isInt ? new Token(number, 1) : new Token(number, 2);
        this.stacks.push(stack);
    }

    final void scanString() {
        int start = this.position;
        ArrayStack<Character> operator = new ArrayStack<Character>();
        char quote = this.code.charAt(start);
        operator.push(Character.valueOf(quote));
        StringBuilder builder = new StringBuilder();
        this.position = start + 1;
        while (this.position < this.code.length()) {
            char ch = this.code.charAt(this.position);
            if (ch == quote) {
                if (this.code.charAt(this.position - 1) != '\\') {
                    operator.pop();
                    if (operator.size() == 0) {
                        ++this.position;
                        break;
                    }
                } else {
                    builder.deleteCharAt(builder.length() - 1);
                    builder.append(ch);
                }
            } else {
                builder.append(ch);
            }
            ++this.position;
        }
        String string2 = builder.toString();
        Token token = new Token(string2, 3);
        this.stacks.push(token);
    }

    final void scanIdentifier() {
        char ch;
        int start = this.position++;
        while (this.hasNext() && Character.isJavaIdentifierPart(ch = this.code.charAt(this.position))) {
            ++this.position;
        }
        String el = this.code.substring(start, this.position);
        if (el.startsWith("$")) {
            if (el.length() == "$".length()) {
                return;
            }
            el = el.substring("$".length());
        }
        int type = 0;
        if (Operators.KEYWORDS.containsKey(el) && (this.operators.isEmpty() || !Operators.isDot(this.operators.peek().op))) {
            type = 4;
        }
        Token token = new Token(el, type);
        this.stacks.push(token);
    }

    final boolean hasNext() {
        return this.position < this.code.length();
    }

    final boolean hasNextToken() {
        while (this.hasNext()) {
            char ch = this.code.charAt(this.position);
            if (ch == ' ') {
                ++this.position;
                continue;
            }
            return true;
        }
        return false;
    }

    final char nextToken() {
        char ch = this.code.charAt(this.position);
        while (ch == ' ') {
            ++this.position;
            if (this.code.length() >= this.position) break;
            this.code.charAt(this.position);
        }
        return ch;
    }
}

