/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import java.util.Arrays;

public class CSSShorthand<T extends Enum<? extends CSSProperty>>
implements Cloneable {
    private float[] values;

    public CSSShorthand(float[] values) {
        this.replace(values);
    }

    public CSSShorthand() {
        this(false);
    }

    CSSShorthand(boolean fillWithNaN) {
        this.values = new float[Math.max(EDGE.values().length, CORNER.values().length)];
        if (fillWithNaN) {
            Arrays.fill(this.values, Float.NaN);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void set(@NonNull EDGE edge, float value) {
        this.setInternal(edge, value);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void set(@NonNull CORNER edge, float value) {
        this.setInternal(edge, value);
    }

    public float get(@NonNull EDGE edge) {
        return this.getInternal(edge);
    }

    public float get(@NonNull CORNER edge) {
        return this.getInternal(edge);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void replace(float[] values) {
        this.values = values;
    }

    public CSSShorthand clone() throws CloneNotSupportedException {
        return (CSSShorthand)super.clone();
    }

    private void setInternal(@NonNull Enum<? extends CSSProperty> edge, float value) {
        if (edge == EDGE.ALL || edge == CORNER.ALL) {
            Arrays.fill(this.values, value);
        } else {
            this.values[edge.ordinal()] = value;
        }
    }

    private float getInternal(@NonNull Enum<? extends CSSProperty> edge) {
        return edge == EDGE.ALL || edge == CORNER.ALL ? 0.0f : this.values[edge.ordinal()];
    }

    public static enum TYPE {
        MARGIN,
        PADDING,
        BORDER;

    }

    public static enum CORNER implements CSSProperty
    {
        BORDER_TOP_LEFT,
        BORDER_TOP_RIGHT,
        BORDER_BOTTOM_RIGHT,
        BORDER_BOTTOM_LEFT,
        ALL;

    }

    public static enum EDGE implements CSSProperty
    {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        ALL;

    }

    static interface CSSProperty {
    }
}

