/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.base;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.taobao.weex.base.CalledByNative;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SystemMessageHandler
extends Handler
implements Serializable {
    private static final String TAG = "SystemMessageHandler";
    private static final int SCHEDULED_WORK = 1;
    private long mMessagePumpDelegateNative = 0L;
    private boolean mIsRunning = false;
    private Method mMessageMethodSetAsynchronous;

    private native void nativeRunWork(long var1);

    private SystemMessageHandler(long messagePumpDelegateNative) {
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
        try {
            Class<?> messageClass = Class.forName("android.os.Message");
            this.mMessageMethodSetAsynchronous = messageClass.getMethod("setAsynchronous", Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Failed to find android.os.Message class:" + e));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("Failed to load Message.setAsynchronous method:" + e));
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Exception while loading Message.setAsynchronous method: " + e));
        }
        this.mIsRunning = true;
    }

    @CalledByNative
    public static SystemMessageHandler create(long messagePumpDelegateNative) {
        return new SystemMessageHandler(messagePumpDelegateNative);
    }

    @CalledByNative
    private void scheduleWork() {
        this.sendMessage(this.obtainAsyncMessage(1));
    }

    @CalledByNative
    private void stop() {
        this.mIsRunning = false;
    }

    private Message obtainAsyncMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        if (this.mMessageMethodSetAsynchronous != null) {
            try {
                this.mMessageMethodSetAsynchronous.invoke((Object)msg, true);
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)"Illegal access to asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Illegal argument for asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)"Invocation exception during asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Runtime exception during asynchronous message creation, disabling.");
                this.mMessageMethodSetAsynchronous = null;
            }
        }
        return msg;
    }

    public void handleMessage(Message msg) {
        if (this.mIsRunning) {
            this.nativeRunWork(this.mMessagePumpDelegateNative);
        }
    }
}

