/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.utils.FontDO;
import com.taobao.weex.utils.LogLevel;
import com.taobao.weex.utils.TypefaceUtil;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXSoInstallMgrSdk;
import com.taobao.weex.utils.WXUtils;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WXEnvironment {
    public static final String OS = "android";
    public static String SYS_VERSION = Build.VERSION.RELEASE;
    public static final String SYS_MODEL;
    public static final String ENVIRONMENT = "environment";
    public static final String WEEX_CURRENT_KEY = "wx_current_url";
    public static String JS_LIB_SDK_VERSION;
    public static String WXSDK_VERSION;
    public static Application sApplication;
    public static final String DEV_Id;
    @Deprecated
    public static int sDefaultWidth;
    public static volatile boolean JsFrameworkInit;
    public static final String SETTING_EXCLUDE_X86SUPPORT = "env_exclude_x86";
    public static boolean SETTING_FORCE_VERTICAL_SCREEN;
    public static boolean sDebugMode;
    public static final boolean sForceEnableDevTool = false;
    public static String sDebugWsUrl;
    public static boolean sDebugServerConnectable;
    public static boolean sRemoteDebugMode;
    public static String sRemoteDebugProxyUrl;
    public static boolean sDebugNetworkEventReporterEnable;
    public static long sJSLibInitTime;
    public static long sSDKInitStart;
    public static long sSDKInitInvokeTime;
    public static long sSDKInitExecuteTime;
    public static long sSDKInitTime;
    public static long sComponentsAndModulesReadyTime;
    public static LogLevel sLogLevel;
    private static boolean isApkDebug;
    public static boolean isPerf;
    private static boolean openDebugLog;
    private static String sGlobalFontFamily;
    public static final String CORE_SO_NAME = "weexcore";
    public static final String CORE_JSS_SO_NAME = "weexjss";
    private static String CORE_JSS_SO_PATH;
    private static Map<String, String> options;
    public static boolean sDynamicMode;
    public static String sDynamicUrl;

    public static Map<String, String> getConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("os", OS);
        configs.put("appVersion", WXEnvironment.getAppVersionName());
        configs.put("cacheDir", WXEnvironment.getAppCacheFile());
        configs.put("devId", DEV_Id);
        configs.put("sysVersion", SYS_VERSION);
        configs.put("sysModel", SYS_MODEL);
        configs.put("weexVersion", String.valueOf(WXSDK_VERSION));
        configs.put("logLevel", sLogLevel.getName());
        try {
            if (WXEnvironment.isApkDebugable()) {
                options.put("debugMode", "true");
            }
            options.put("scale", Float.toString(WXEnvironment.sApplication.getResources().getDisplayMetrics().density));
        }
        catch (NullPointerException e) {
            WXLogUtils.e("WXEnvironment scale Exception: ", e);
        }
        configs.putAll(options);
        if (configs != null && configs.get("appName") == null && sApplication != null) {
            configs.put("appName", sApplication.getPackageName());
        }
        return configs;
    }

    private static String getAppVersionName() {
        String versionName = "";
        PackageInfo info = null;
        try {
            PackageManager manager = sApplication.getPackageManager();
            info = manager.getPackageInfo(sApplication.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppVersionName Exception: ", e);
        }
        return versionName;
    }

    private static String getAppCacheFile() {
        String cache = "";
        try {
            cache = sApplication.getApplicationContext().getCacheDir().getPath();
        }
        catch (Exception e) {
            WXLogUtils.e("WXEnvironment getAppCacheFile Exception: ", e);
        }
        return cache;
    }

    public static Map<String, String> getCustomOptions() {
        return options;
    }

    public static void addCustomOptions(String key, String value) {
        options.put(key, value);
    }

    @Deprecated
    public static boolean isSupport() {
        boolean isInitialized = WXSDKEngine.isInitialized();
        if (!isInitialized) {
            WXLogUtils.e("WXSDKEngine.isInitialized():" + isInitialized);
        }
        return WXEnvironment.isHardwareSupport() && isInitialized;
    }

    @Deprecated
    public static boolean isHardwareSupport() {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("isTableDevice:" + WXUtils.isTabletDevice());
        }
        return WXEnvironment.isCPUSupport() && !WXUtils.isTabletDevice();
    }

    public static boolean isCPUSupport() {
        boolean isCPUSupport;
        boolean excludeX86 = "true".equals(options.get(SETTING_EXCLUDE_X86SUPPORT));
        boolean isX86AndExcluded = WXSoInstallMgrSdk.isX86() && excludeX86;
        boolean bl = isCPUSupport = WXSoInstallMgrSdk.isCPUSupport() && !isX86AndExcluded;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("WXEnvironment.sSupport:" + isCPUSupport + "isX86AndExclueded: " + isX86AndExcluded);
        }
        return isCPUSupport;
    }

    public static boolean isApkDebugable() {
        if (sApplication == null) {
            return false;
        }
        if (isPerf) {
            return false;
        }
        if (!isApkDebug) {
            return false;
        }
        try {
            ApplicationInfo info = sApplication.getApplicationInfo();
            isApkDebug = (info.flags & 2) != 0;
            return isApkDebug;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPerf() {
        return isPerf;
    }

    private static String getDevId() {
        return sApplication == null ? "" : ((TelephonyManager)sApplication.getSystemService("phone")).getDeviceId();
    }

    public static Application getApplication() {
        return sApplication;
    }

    public void initMetrics() {
        if (sApplication == null) {
            return;
        }
    }

    public static String getDiskCacheDir(Context context) {
        if (context == null) {
            return null;
        }
        String cachePath = null;
        try {
            cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cachePath;
    }

    public static String getFilesDir(Context context) {
        if (context == null) {
            return "";
        }
        File filesDir = context.getFilesDir();
        String path = "";
        if (filesDir != null) {
            path = filesDir.getPath();
        } else {
            path = WXEnvironment.getApplication().getApplicationInfo().dataDir;
            path = path + File.separator;
            path = path + "files";
        }
        return path;
    }

    public static String getGlobalFontFamilyName() {
        return sGlobalFontFamily;
    }

    public static void setGlobalFontFamily(String fontFamilyName, Typeface typeface) {
        WXLogUtils.d("GlobalFontFamily", "Set global font family: " + fontFamilyName);
        sGlobalFontFamily = fontFamilyName;
        if (!TextUtils.isEmpty((CharSequence)fontFamilyName)) {
            if (typeface == null) {
                TypefaceUtil.removeFontDO(fontFamilyName);
            } else {
                FontDO nativeFontDO = new FontDO(fontFamilyName, typeface);
                TypefaceUtil.putFontDO(nativeFontDO);
                WXLogUtils.d("TypefaceUtil", "Add new font: " + fontFamilyName);
            }
        }
    }

    public static boolean isOpenDebugLog() {
        return openDebugLog;
    }

    public static void setOpenDebugLog(boolean openDebugLog) {
        WXEnvironment.openDebugLog = openDebugLog;
    }

    public static void setApkDebugable(boolean debugable) {
        isApkDebug = debugable;
        if (!isApkDebug) {
            openDebugLog = false;
        }
    }

    public static String findSoPath(String libName) {
        String libPath = ((PathClassLoader)WXEnvironment.class.getClassLoader()).findLibrary(libName);
        WXLogUtils.e(libName + "'s Path is" + libPath);
        return libPath;
    }

    public static String getCacheDir() {
        Application application = WXEnvironment.getApplication();
        if (application == null || application.getApplicationContext() == null) {
            return null;
        }
        return application.getApplicationContext().getCacheDir().getPath();
    }

    public static boolean extractSo() {
        File sourceFile = new File(WXEnvironment.getApplication().getApplicationContext().getApplicationInfo().sourceDir);
        String cacheDir = WXEnvironment.getCacheDir();
        if (sourceFile.exists() && !TextUtils.isEmpty((CharSequence)cacheDir)) {
            try {
                WXFileUtils.extractSo(sourceFile.getAbsolutePath(), cacheDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    private static String findLibJssRealPath() {
        File soFile;
        String soPath = WXEnvironment.findSoPath(CORE_JSS_SO_NAME);
        String realName = "libweexjss.so";
        if (TextUtils.isEmpty((CharSequence)soPath)) {
            String cacheDir = WXEnvironment.getCacheDir();
            if (TextUtils.isEmpty((CharSequence)cacheDir)) {
                return "";
            }
            if (cacheDir.indexOf("/cache") > 0) {
                soPath = new File(cacheDir.replace("/cache", "/lib"), realName).getAbsolutePath();
            }
        }
        if ((soFile = new File(soPath)).exists()) {
            return soPath;
        }
        boolean success = WXEnvironment.extractSo();
        if (success) {
            return new File(WXEnvironment.getCacheDir(), realName).getAbsolutePath();
        }
        return "";
    }

    public static String getLibJssRealPath() {
        if (TextUtils.isEmpty((CharSequence)CORE_JSS_SO_PATH)) {
            CORE_JSS_SO_PATH = WXEnvironment.findLibJssRealPath();
            WXLogUtils.e("findLibJssRealPath " + CORE_JSS_SO_PATH);
        }
        return CORE_JSS_SO_PATH;
    }

    static {
        if (SYS_VERSION != null && SYS_VERSION.toUpperCase().equals("P")) {
            SYS_VERSION = "9.0.0";
        }
        SYS_MODEL = Build.MODEL;
        JS_LIB_SDK_VERSION = "null";
        WXSDK_VERSION = "0.19.0.7";
        DEV_Id = WXEnvironment.getDevId();
        sDefaultWidth = 750;
        JsFrameworkInit = false;
        SETTING_FORCE_VERTICAL_SCREEN = false;
        sDebugMode = false;
        sDebugWsUrl = "";
        sDebugServerConnectable = false;
        sRemoteDebugMode = false;
        sRemoteDebugProxyUrl = "";
        sDebugNetworkEventReporterEnable = false;
        sJSLibInitTime = 0L;
        sSDKInitStart = 0L;
        sSDKInitInvokeTime = 0L;
        sSDKInitExecuteTime = 0L;
        sSDKInitTime = 0L;
        sComponentsAndModulesReadyTime = 0L;
        sLogLevel = LogLevel.DEBUG;
        isApkDebug = true;
        isPerf = false;
        openDebugLog = false;
        CORE_JSS_SO_PATH = null;
        options = new HashMap<String, String>();
        options.put("os", OS);
        options.put("osName", OS);
        sDynamicMode = false;
        sDynamicUrl = "";
    }
}

