/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.PropertyValuesHolder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import com.taobao.weex.ui.animation.CameraDistanceProperty;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jacoco.agent.rt.internal_b0d6a23.Offline;

public class WXAnimationBean {
    public static final String LINEAR = "linear";
    public static final String EASE_IN_OUT = "ease-in-out";
    public static final String EASE_IN = "ease-in";
    public static final String EASE_OUT = "ease-out";
    public static final String CUBIC_BEZIER = "cubic-bezier";
    public static final int NUM_CUBIC_PARAM = 4;
    public long delay;
    public long duration;
    public String timingFunction;
    @Nullable
    public Style styles;
    public boolean needLayout;
    private static final transient /* synthetic */ boolean[] $jacocoData;

    public WXAnimationBean() {
        boolean[] blArray = WXAnimationBean.$jacocoInit();
        blArray[0] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-1770307046242285436L, (String)"com/taobao/weex/ui/animation/WXAnimationBean", (int)1);
        }
        return blArray;
    }

    public static class Style {
        public static final String WX_TRANSLATE = "translate";
        public static final String WX_TRANSLATE_X = "translateX";
        public static final String WX_TRANSLATE_Y = "translateY";
        public static final String WX_ROTATE = "rotate";
        public static final String WX_SCALE_X = "scaleX";
        public static final String WX_SCALE_Y = "scaleY";
        public static final String WX_SCALE = "scale";
        public static final String WX_ROTATE_X = "rotateX";
        public static final String WX_ROTATE_Y = "rotateY";
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String TOP = "top";
        public static final String BOTTOM = "bottom";
        public static final String RIGHT = "right";
        public static final String LEFT = "left";
        public static final String CENTER = "center";
        private static final String HALF = "50%";
        private static final String FULL = "100%";
        private static final String ZERO = "0%";
        private static final String PX = "px";
        private static final String DEG = "deg";
        public static Map<String, List<Property<View, Float>>> wxToAndroidMap;
        private static Map<Property<View, Float>, Float> defaultMap;
        public String opacity;
        public String backgroundColor;
        public String width;
        public String height;
        public String transform;
        public String transformOrigin;
        private Map<Property<View, Float>, Float> transformMap;
        private Pair<Float, Float> pivot;
        private List<PropertyValuesHolder> holders;
        private float cameraDistance;
        private static final transient /* synthetic */ boolean[] $jacocoData;

        public Style() {
            boolean[] blArray = Style.$jacocoInit();
            blArray[0] = true;
            this.transformMap = new LinkedHashMap<Property<View, Float>, Float>();
            blArray[1] = true;
            this.holders = new LinkedList<PropertyValuesHolder>();
            this.cameraDistance = Float.MAX_VALUE;
            blArray[2] = true;
        }

        /*
         * WARNING - void declaration
         */
        private static Map<Property<View, Float>, Float> parseTransForm(@Nullable String string, int n, int n2, int n3) {
            void viewportW;
            void height;
            void width;
            String rawTransform;
            boolean[] blArray = Style.$jacocoInit();
            blArray[3] = true;
            return TransformParser.parseTransForm(rawTransform, (int)width, (int)height, (int)viewportW);
        }

        /*
         * WARNING - void declaration
         */
        private static Pair<Float, Float> parsePivot(@Nullable String string, int n, int n2, int n3) {
            String transformOrigin;
            boolean[] blArray = Style.$jacocoInit();
            if (TextUtils.isEmpty((CharSequence)transformOrigin)) {
                blArray[4] = true;
            } else {
                blArray[5] = true;
                int firstSpace = transformOrigin.indexOf(32);
                if (firstSpace == -1) {
                    blArray[6] = true;
                } else {
                    void i;
                    int n4 = firstSpace;
                    blArray[7] = true;
                    while (true) {
                        if (i >= transformOrigin.length()) {
                            blArray[8] = true;
                            break;
                        }
                        blArray[9] = true;
                        if (transformOrigin.charAt((int)i) != ' ') {
                            blArray[10] = true;
                            break;
                        }
                        ++i;
                        blArray[11] = true;
                    }
                    if (i >= transformOrigin.length()) {
                        blArray[12] = true;
                    } else if (transformOrigin.charAt((int)i) == ' ') {
                        blArray[13] = true;
                    } else {
                        void viewportW;
                        void height;
                        void width;
                        void list;
                        blArray[14] = true;
                        ArrayList arrayList = new ArrayList(2);
                        blArray[15] = true;
                        list.add(transformOrigin.substring(0, firstSpace).trim());
                        blArray[16] = true;
                        list.add(transformOrigin.substring((int)i, transformOrigin.length()).trim());
                        blArray[17] = true;
                        blArray[18] = true;
                        return Style.parsePivot((List<String>)list, (int)width, (int)height, (int)viewportW);
                    }
                }
            }
            blArray[19] = true;
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private static Pair<Float, Float> parsePivot(@NonNull List<String> list, int n, int n2, int n3) {
            void height;
            void viewportW;
            void width;
            List<String> list2;
            boolean[] blArray = Style.$jacocoInit();
            blArray[20] = true;
            blArray[21] = true;
            return new Pair((Object)Float.valueOf(Style.parsePivotX(list2.get(0), (int)width, (int)viewportW)), (Object)Float.valueOf(Style.parsePivotY(list2.get(1), (int)height, (int)viewportW)));
        }

        /*
         * WARNING - void declaration
         */
        private static float parsePivotX(String string, int n, int n2) {
            void viewportW;
            void width;
            String value;
            String x;
            boolean[] blArray = Style.$jacocoInit();
            String string2 = x;
            blArray[22] = true;
            if (LEFT.equals(x)) {
                value = ZERO;
                blArray[23] = true;
            } else if (RIGHT.equals(x)) {
                value = FULL;
                blArray[24] = true;
            } else if (!CENTER.equals(x)) {
                blArray[25] = true;
            } else {
                value = HALF;
                blArray[26] = true;
            }
            blArray[27] = true;
            return Style.parsePercentOrPx(value, (int)width, (int)viewportW);
        }

        /*
         * WARNING - void declaration
         */
        private static float parsePivotY(String string, int n, int n2) {
            void viewportW;
            void height;
            String value;
            String y;
            boolean[] blArray = Style.$jacocoInit();
            String string2 = y;
            blArray[28] = true;
            if (TOP.equals(y)) {
                value = ZERO;
                blArray[29] = true;
            } else if (BOTTOM.equals(y)) {
                value = FULL;
                blArray[30] = true;
            } else if (!CENTER.equals(y)) {
                blArray[31] = true;
            } else {
                value = HALF;
                blArray[32] = true;
            }
            blArray[33] = true;
            return Style.parsePercentOrPx(value, (int)height, (int)viewportW);
        }

        /*
         * WARNING - void declaration
         */
        private static float parsePercentOrPx(String string, int n, int n2) {
            void viewportW;
            String raw;
            boolean[] blArray = Style.$jacocoInit();
            boolean bl = true;
            blArray[34] = true;
            int suffix = raw.lastIndexOf(37);
            if (suffix != -1) {
                void unit;
                blArray[35] = true;
                blArray[36] = true;
                return Style.parsePercent(raw.substring(0, suffix), (int)unit, 1);
            }
            suffix = raw.lastIndexOf(PX);
            if (suffix != -1) {
                blArray[37] = true;
                blArray[38] = true;
                return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(raw.substring(0, suffix), 1), (int)viewportW);
            }
            blArray[39] = true;
            return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(raw, 1), (int)viewportW);
        }

        /*
         * WARNING - void declaration
         */
        private static float parsePercent(String string, int n, int n2) {
            void unit;
            void precision;
            String percent;
            boolean[] blArray = Style.$jacocoInit();
            blArray[40] = true;
            return WXUtils.fastGetFloat(percent, (int)precision) / 100.0f * (float)unit;
        }

        /*
         * WARNING - void declaration
         */
        private void resetToDefaultIfAbsent() {
            boolean[] blArray = Style.$jacocoInit();
            Iterator<Map.Entry<Property<View, Float>, Float>> iterator = defaultMap.entrySet().iterator();
            blArray[41] = true;
            while (iterator.hasNext()) {
                void entry;
                Map.Entry<Property<View, Float>, Float> entry2 = iterator.next();
                blArray[42] = true;
                if (this.transformMap.containsKey(entry.getKey())) {
                    blArray[43] = true;
                } else {
                    blArray[44] = true;
                    this.transformMap.put((Property<View, Float>)entry.getKey(), (Float)entry.getValue());
                    blArray[45] = true;
                }
                blArray[46] = true;
            }
            blArray[47] = true;
        }

        @Nullable
        public Pair<Float, Float> getPivot() {
            boolean[] blArray = Style.$jacocoInit();
            blArray[48] = true;
            return this.pivot;
        }

        /*
         * WARNING - void declaration
         */
        public void init(@Nullable String string, @Nullable String string2, int n, int n2, int n3) {
            void rawTransform;
            void viewportW;
            void height;
            void width;
            void transformOrigin;
            boolean[] blArray = Style.$jacocoInit();
            this.pivot = Style.parsePivot((String)transformOrigin, (int)width, (int)height, (int)viewportW);
            blArray[49] = true;
            this.transformMap.putAll(Style.parseTransForm((String)rawTransform, (int)width, (int)height, (int)viewportW));
            blArray[50] = true;
            this.resetToDefaultIfAbsent();
            blArray[51] = true;
            if (!this.transformMap.containsKey(CameraDistanceProperty.getInstance())) {
                blArray[52] = true;
            } else {
                blArray[53] = true;
                this.cameraDistance = this.transformMap.remove(CameraDistanceProperty.getInstance()).floatValue();
                blArray[54] = true;
            }
            this.initHolders();
            blArray[55] = true;
        }

        /*
         * WARNING - void declaration
         */
        public void init(@NonNull Map<Property<View, Float>, Pair<Float, Float>> map) {
            void styles;
            boolean[] blArray = Style.$jacocoInit();
            Iterator iterator = styles.entrySet().iterator();
            blArray[56] = true;
            while (iterator.hasNext()) {
                void entry;
                Map.Entry entry2 = iterator.next();
                blArray[57] = true;
                this.holders.add(PropertyValuesHolder.ofFloat((Property)((Property)entry.getKey()), (float[])new float[]{((Float)((Pair)entry.getValue()).first).floatValue(), ((Float)((Pair)entry.getValue()).second).floatValue()}));
                blArray[58] = true;
            }
            blArray[59] = true;
        }

        /*
         * WARNING - void declaration
         */
        private void initHolders() {
            boolean[] blArray = Style.$jacocoInit();
            Iterator<Map.Entry<Property<View, Float>, Float>> iterator = this.transformMap.entrySet().iterator();
            blArray[60] = true;
            while (iterator.hasNext()) {
                void entry;
                Map.Entry<Property<View, Float>, Float> entry2 = iterator.next();
                blArray[61] = true;
                this.holders.add(PropertyValuesHolder.ofFloat((Property)((Property)entry.getKey()), (float[])new float[]{((Float)entry.getValue()).floatValue()}));
                blArray[62] = true;
            }
            if (TextUtils.isEmpty((CharSequence)this.opacity)) {
                blArray[63] = true;
            } else {
                blArray[64] = true;
                this.holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{WXUtils.fastGetFloat(this.opacity, 3)}));
                blArray[65] = true;
            }
            blArray[66] = true;
        }

        public List<PropertyValuesHolder> getHolders() {
            boolean[] blArray = Style.$jacocoInit();
            blArray[67] = true;
            return this.holders;
        }

        public float getCameraDistance() {
            boolean[] blArray = Style.$jacocoInit();
            blArray[68] = true;
            return this.cameraDistance;
        }

        static {
            boolean[] blArray = Style.$jacocoInit();
            wxToAndroidMap = new ArrayMap();
            blArray[69] = true;
            defaultMap = new ArrayMap();
            blArray[70] = true;
            blArray[71] = true;
            wxToAndroidMap.put(WX_TRANSLATE, Arrays.asList(View.TRANSLATION_X, View.TRANSLATION_Y));
            blArray[72] = true;
            wxToAndroidMap.put(WX_TRANSLATE_X, Collections.singletonList(View.TRANSLATION_X));
            blArray[73] = true;
            wxToAndroidMap.put(WX_TRANSLATE_Y, Collections.singletonList(View.TRANSLATION_Y));
            blArray[74] = true;
            wxToAndroidMap.put(WX_ROTATE, Collections.singletonList(View.ROTATION));
            blArray[75] = true;
            wxToAndroidMap.put(WX_ROTATE_X, Collections.singletonList(View.ROTATION_X));
            blArray[76] = true;
            wxToAndroidMap.put(WX_ROTATE_Y, Collections.singletonList(View.ROTATION_Y));
            blArray[77] = true;
            wxToAndroidMap.put(WX_SCALE, Arrays.asList(View.SCALE_X, View.SCALE_Y));
            blArray[78] = true;
            wxToAndroidMap.put(WX_SCALE_X, Collections.singletonList(View.SCALE_X));
            blArray[79] = true;
            wxToAndroidMap.put(WX_SCALE_Y, Collections.singletonList(View.SCALE_Y));
            blArray[80] = true;
            wxToAndroidMap.put("perspective", Collections.singletonList(CameraDistanceProperty.getInstance()));
            blArray[81] = true;
            wxToAndroidMap = Collections.unmodifiableMap(wxToAndroidMap);
            blArray[82] = true;
            defaultMap.put((Property<View, Float>)View.TRANSLATION_X, Float.valueOf(0.0f));
            blArray[83] = true;
            defaultMap.put((Property<View, Float>)View.TRANSLATION_Y, Float.valueOf(0.0f));
            blArray[84] = true;
            defaultMap.put((Property<View, Float>)View.SCALE_X, Float.valueOf(1.0f));
            blArray[85] = true;
            defaultMap.put((Property<View, Float>)View.SCALE_Y, Float.valueOf(1.0f));
            blArray[86] = true;
            defaultMap.put((Property<View, Float>)View.ROTATION, Float.valueOf(0.0f));
            blArray[87] = true;
            defaultMap.put((Property<View, Float>)View.ROTATION_X, Float.valueOf(0.0f));
            blArray[88] = true;
            defaultMap.put((Property<View, Float>)View.ROTATION_Y, Float.valueOf(0.0f));
            blArray[89] = true;
        }

        private static /* synthetic */ boolean[] $jacocoInit() {
            boolean[] blArray = $jacocoData;
            if ($jacocoData == null) {
                blArray = $jacocoData = Offline.getProbes((long)-7882179283535214202L, (String)"com/taobao/weex/ui/animation/WXAnimationBean$Style", (int)90);
            }
            return blArray;
        }
    }
}

