/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.taobao.weex.utils.WXLogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class WXFileUtils {
    public static String loadFileOrAsset(String path, Context context) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File file = new File(path);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    return WXFileUtils.readStreamToString(fis);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                return WXFileUtils.loadAsset(path, context);
            }
        }
        return "";
    }

    public static String loadAsset(String path, Context context) {
        if (context == null || TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(path);
            return WXFileUtils.readStreamToString(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            StringBuilder builder = new StringBuilder(inputStream.available() + 10);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] data = new char[4096];
            int len = -1;
            while ((len = bufferedReader.read(data)) > 0) {
                builder.append(data, 0, len);
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            WXLogUtils.e("", e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                WXLogUtils.e("WXFileUtils loadAsset: ", e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(String path, byte[] content, Context context) {
        if (TextUtils.isEmpty((CharSequence)path) || content == null || context == null) {
            return false;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            outStream.write(content);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            WXLogUtils.e("WXFileUtils saveFile: " + WXLogUtils.getStackTrace(e));
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String md5(String template) {
        try {
            if (template == null) {
                return "";
            }
            return WXFileUtils.md5(template.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String md5(byte[] bts) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bts);
            BigInteger bigInt = new BigInteger(1, digest.digest());
            return bigInt.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }

    public static String base64Md5(String template) {
        try {
            if (template == null) {
                return "";
            }
            return WXFileUtils.base64Md5(template.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String base64Md5(byte[] bts) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(bts);
            return Base64.encodeToString((byte[])digest.digest(), (int)2);
        }
        catch (NoSuchAlgorithmException e) {
            return "";
        }
    }
}

