/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.listview;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.MotionEvent;
import android.view.View;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.ui.view.listview.ExtendedLinearLayoutManager;
import com.taobao.weex.ui.view.listview.ExtendedStaggeredGridLayoutManager;

public class WXRecyclerView
extends RecyclerView
implements WXGestureObservable {
    public static final int TYPE_LINEAR_LAYOUT = 1;
    public static final int TYPE_GRID_LAYOUT = 2;
    public static final int TYPE_STAGGERED_GRID_LAYOUT = 3;
    private WXGesture mGesture;
    private boolean scrollable = true;
    private boolean hasTouch = false;

    public WXRecyclerView(Context context) {
        super(context);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
    }

    public void initView(Context context, int type, int orientation) {
        this.initView(context, type, 1, 32.0f, orientation);
    }

    @TargetApi(value=16)
    public void initView(Context context, int type, int columnCount, float columnGap, int orientation) {
        if (type == 2) {
            this.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, columnCount, orientation, false));
        } else if (type == 3) {
            this.setLayoutManager((RecyclerView.LayoutManager)new ExtendedStaggeredGridLayoutManager(columnCount, orientation));
        } else if (type == 1) {
            this.setLayoutManager((RecyclerView.LayoutManager)new ExtendedLinearLayoutManager(context, orientation, false));
        }
    }

    @Override
    public void registerGestureListener(@Nullable WXGesture wxGesture) {
        this.mGesture = wxGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.scrollable) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.hasTouch = true;
        boolean result = super.dispatchTouchEvent(event);
        if (this.mGesture != null) {
            result |= this.mGesture.onTouch((View)this, event);
        }
        return result;
    }

    public void scrollTo(boolean smooth, int position, final int offset, final int orientation) {
        if (!smooth) {
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(position, -offset);
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                ((StaggeredGridLayoutManager)layoutManager).scrollToPositionWithOffset(position, -offset);
            }
        } else {
            this.smoothScrollToPosition(position);
            if (offset != 0) {
                this.setOnSmoothScrollEndListener(new ExtendedLinearLayoutManager.OnSmoothScrollEndListener(){

                    @Override
                    public void onStop() {
                        WXRecyclerView.this.post(WXThread.secure(new Runnable(){

                            @Override
                            public void run() {
                                if (orientation == 1) {
                                    WXRecyclerView.this.smoothScrollBy(0, offset);
                                } else {
                                    WXRecyclerView.this.smoothScrollBy(offset, 0);
                                }
                            }
                        }));
                    }
                });
            }
        }
    }

    public void setOnSmoothScrollEndListener(final ExtendedLinearLayoutManager.OnSmoothScrollEndListener onSmoothScrollEndListener) {
        this.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                    if (onSmoothScrollEndListener != null) {
                        onSmoothScrollEndListener.onStop();
                    }
                }
            }
        });
    }
}

