/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class BottomRightCorner
extends BorderCorner {
    BottomRightCorner() {
    }

    void set(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        this.set(cornerRadius, preBorderWidth, postBorderWidth, borderBox, 45.0f);
    }

    @Override
    protected void prepareOval() {
        if (this.hasInnerCorner()) {
            this.setOvalLeft(this.getBorderBox().width() - (2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f));
            this.setOvalTop(this.getBorderBox().height() - (2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f));
            this.setOvalRight(this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f);
            this.setOvalBottom(this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f);
        } else {
            this.setOvalLeft(this.getBorderBox().width() - 1.5f * this.getOuterCornerRadius());
            this.setOvalTop(this.getBorderBox().height() - 1.5f * this.getOuterCornerRadius());
            this.setOvalRight(this.getBorderBox().width() - this.getOuterCornerRadius() / 2.0f);
            this.setOvalBottom(this.getBorderBox().height() - this.getOuterCornerRadius() / 2.0f);
        }
    }

    @Override
    protected void prepareRoundCorner() {
        if (this.hasOuterCorner()) {
            this.setRoundCornerStartX(this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f);
            this.setRoundCornerStartY(this.getBorderBox().height() - this.getOuterCornerRadius());
            this.setRoundCornerEndX(this.getBorderBox().width() - this.getOuterCornerRadius());
            this.setRoundCornerEndY(this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f);
        } else {
            float x = this.getBorderBox().width() - this.getPreBorderWidth() / 2.0f;
            float y = this.getBorderBox().height() - this.getPostBorderWidth() / 2.0f;
            this.setRoundCornerStartX(x);
            this.setRoundCornerStartY(y);
            this.setRoundCornerEndX(x);
            this.setRoundCornerEndY(y);
        }
    }
}

