/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.support.annotation.Nullable;
import com.taobao.weex.dom.CSSShorthand;

enum BorderStyle {
    SOLID,
    DASHED,
    DOTTED;


    @Nullable
    Shader getLineShader(float borderWidth, int borderColor, CSSShorthand.EDGE edge) {
        switch (this) {
            case DOTTED: {
                if (edge == CSSShorthand.EDGE.LEFT || edge == CSSShorthand.EDGE.RIGHT) {
                    return new LinearGradient(0.0f, 0.0f, 0.0f, borderWidth * 2.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
                if (edge == CSSShorthand.EDGE.TOP || edge == CSSShorthand.EDGE.BOTTOM) {
                    return new LinearGradient(0.0f, 0.0f, borderWidth * 2.0f, 0.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
            }
            case DASHED: {
                if (edge == CSSShorthand.EDGE.LEFT || edge == CSSShorthand.EDGE.RIGHT) {
                    return new LinearGradient(0.0f, 0.0f, 0.0f, borderWidth * 6.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
                }
                if (edge != CSSShorthand.EDGE.TOP && edge != CSSShorthand.EDGE.BOTTOM) break;
                return new LinearGradient(0.0f, 0.0f, borderWidth * 6.0f, 0.0f, new int[]{borderColor, 0}, new float[]{0.5f, 0.5f}, Shader.TileMode.REPEAT);
            }
        }
        return null;
    }
}

