/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.ui.action.ActionAddRule;
import com.taobao.weex.ui.action.ActionGetComponentRect;
import com.taobao.weex.ui.action.ActionInvokeMethod;
import com.taobao.weex.ui.action.GraphicActionScrollToElement;
import com.taobao.weex.utils.WXLogUtils;

public final class WXDomModule
extends WXModule {
    public static final String SCROLL_TO_ELEMENT = "scrollToElement";
    public static final String ADD_RULE = "addRule";
    public static final String GET_COMPONENT_RECT = "getComponentRect";
    public static final String WXDOM = "dom";
    public static final String INVOKE_METHOD = "invokeMethod";
    public static final String[] METHODS = new String[]{"scrollToElement", "addRule", "getComponentRect", "invokeMethod"};

    public WXDomModule(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
    }

    public void callDomMethod(JSONObject task, long ... parseNanos) {
        if (task == null) {
            return;
        }
        String method = (String)task.get((Object)"method");
        JSONArray args = (JSONArray)task.get((Object)"args");
        this.callDomMethod(method, args, parseNanos);
    }

    public Object callDomMethod(String method, JSONArray args, long ... parseNanos) {
        if (method == null) {
            return null;
        }
        try {
            switch (method) {
                case "scrollToElement": {
                    if (args == null) {
                        return null;
                    }
                    String ref = args.size() >= 1 ? args.getString(0) : null;
                    JSONObject options = args.size() >= 2 ? args.getJSONObject(1) : null;
                    new GraphicActionScrollToElement(this.mWXSDKInstance.getInstanceId(), ref, options).executeActionOnRender();
                    break;
                }
                case "addRule": {
                    if (args == null) {
                        return null;
                    }
                    new ActionAddRule(this.mWXSDKInstance.getInstanceId(), args.getString(0), args.getJSONObject(1)).executeAction();
                    break;
                }
                case "getComponentRect": {
                    if (args == null) {
                        return null;
                    }
                    new ActionGetComponentRect(this.mWXSDKInstance.getInstanceId(), args.getString(0), args.getString(1)).executeActionOnRender();
                    break;
                }
                case "invokeMethod": {
                    if (args == null) {
                        return null;
                    }
                    new ActionInvokeMethod(this.mWXSDKInstance.getInstanceId(), args.getString(0), args.getString(1), args.getJSONArray(2)).executeAction();
                    break;
                }
                default: {
                    WXLogUtils.e("Unknown dom action.");
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            WXLogUtils.e("Dom module call miss arguments.");
        }
        catch (ClassCastException cce) {
            WXLogUtils.e("Dom module call arguments format error!!");
        }
        return null;
    }

    public void invokeMethod(String ref, String method, JSONArray args) {
        if (ref == null || method == null) {
            return;
        }
        new ActionInvokeMethod(this.mWXSDKInstance.getInstanceId(), ref, method, args).executeAction();
    }
}

