/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.config;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.ui.config.ConfigComponentHolder;
import com.taobao.weex.ui.config.ConfigModuleFactory;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.IOException;

public class AutoScanConfigRegister {
    public static final String TAG = "WeexScanConfigRegister";

    public static void doScanConfig() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                AutoScanConfigRegister.doScanConfigSync();
            }
        });
        thread.setName("AutoScanConfigRegister");
        thread.start();
    }

    private static void doScanConfigSync() {
        if (WXEnvironment.sApplication == null) {
            return;
        }
        try {
            AssetManager assetManager = WXEnvironment.sApplication.getApplicationContext().getAssets();
            String[] configFiles = new String[]{};
            try {
                configFiles = assetManager.list("");
            }
            catch (IOException e) {
                WXLogUtils.e(TAG, e);
            }
            if (configFiles == null || configFiles.length == 0) {
                return;
            }
            for (String configFile : configFiles) {
                if (TextUtils.isEmpty((CharSequence)configFile) || !configFile.startsWith("weex_config_") || !configFile.endsWith(".json")) continue;
                String name = configFile;
                if (TextUtils.isEmpty((CharSequence)name)) {
                    return;
                }
                try {
                    int i;
                    JSONArray array;
                    JSONObject object;
                    String config = WXFileUtils.loadAsset(name, (Context)WXEnvironment.getApplication());
                    if (TextUtils.isEmpty((CharSequence)config)) continue;
                    if (WXEnvironment.isApkDebugable()) {
                        WXLogUtils.d(TAG, configFile + " find config " + config);
                    }
                    if ((object = JSON.parseObject((String)config)).containsKey((Object)"modules")) {
                        array = object.getJSONArray("modules");
                        for (i = 0; i < array.size(); ++i) {
                            ConfigModuleFactory configModuleFactory = ConfigModuleFactory.fromConfig(array.getJSONObject(i));
                            if (configModuleFactory == null) continue;
                            WXSDKEngine.registerModule(configModuleFactory.getName(), configModuleFactory, false);
                        }
                    }
                    if (!object.containsKey((Object)"components")) continue;
                    array = object.getJSONArray("components");
                    for (i = 0; i < array.size(); ++i) {
                        ConfigComponentHolder configComponentHolder = ConfigComponentHolder.fromConfig(array.getJSONObject(i));
                        if (configComponentHolder == null) {
                            return;
                        }
                        WXSDKEngine.registerComponent(configComponentHolder, configComponentHolder.isAppendTree(), configComponentHolder.getType());
                    }
                }
                catch (Exception e) {
                    WXLogUtils.e(TAG, e);
                }
            }
        }
        catch (Exception eout) {
            WXLogUtils.e(TAG, eout);
        }
    }
}

