/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list.template;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.ComponentUtils;
import com.taobao.weex.ui.component.Scrollable;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.binding.Layouts;
import com.taobao.weex.ui.component.binding.Statements;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.component.list.RecyclerTransform;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.template.AsyncCellLoadTask;
import com.taobao.weex.ui.component.list.template.CellDataManager;
import com.taobao.weex.ui.component.list.template.CellRenderContext;
import com.taobao.weex.ui.component.list.template.CellRenderState;
import com.taobao.weex.ui.component.list.template.PositionRef;
import com.taobao.weex.ui.component.list.template.TemplateCache;
import com.taobao.weex.ui.component.list.template.TemplateStickyHelper;
import com.taobao.weex.ui.component.list.template.TemplateViewHolder;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.listview.adapter.IOnLoadMoreListener;
import com.taobao.weex.ui.view.listview.adapter.IRecyclerAdapterListener;
import com.taobao.weex.ui.view.listview.adapter.RecyclerViewBaseAdapter;
import com.taobao.weex.ui.view.listview.adapter.WXRecyclerViewOnScrollListener;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Component(lazyload=false)
public class WXRecyclerTemplateList
extends WXVContainer<BounceRecyclerView>
implements IRecyclerAdapterListener<TemplateViewHolder>,
IOnLoadMoreListener,
Scrollable {
    public static final boolean ENABLE_TRACE_LOG = false;
    public static final String TAG = "WXRecyclerTemplateList";
    private static final String EMPTY_HOLDER_TEMPLATE_KEY = "";
    private static final String NAME_HAS_FIXED_SIZE = "hasFixedSize";
    private static final String NAME_ITEM_VIEW_CACHE_SIZE = "itemViewCacheSize";
    private static final String NAME_TEMPLATE_CACHE_SIZE = "templateCacheSize";
    protected int mLayoutType = 1;
    protected int mColumnCount = 1;
    protected float mColumnGap = 0.0f;
    protected float mColumnWidth = 0.0f;
    private float mPaddingLeft;
    private float mPaddingRight;
    private WXRecyclerViewOnScrollListener mViewOnScrollListener = new WXRecyclerViewOnScrollListener(this);
    private int mListCellCount = 0;
    private boolean mForceLoadmoreNextTime = false;
    private RecyclerView.ItemAnimator mItemAnimator;
    private int orientation = 1;
    private boolean isScrollable = true;
    private int mOffsetAccuracy = 10;
    private Point mLastReport = new Point(-1, -1);
    private boolean mHasAddScrollEvent = false;
    private CellDataManager cellDataManager;
    private String listDataKey = "listData";
    private String listDataItemKey = null;
    private String listDataIndexKey = null;
    private ArrayMap<String, Integer> mTemplateViewTypes;
    private Map<String, WXCell> mTemplateSources;
    private String listDataTemplateKey = "case";
    private Runnable listUpdateRunnable;
    private ConcurrentHashMap<String, TemplateCache> mTemplatesCache;
    private int templateCacheSize = 2;
    private WXCell defaultTemplateCell;
    private String defaultTemplateKey = "@default_template_cell";
    private ScrollStartEndHelper mScrollStartEndHelper;
    private TemplateStickyHelper mStickyHelper;
    private ArrayMap<Integer, List<AppearanceHelper>> mAppearHelpers = new ArrayMap();
    private ArrayMap<Integer, Map<String, Map<Integer, List<Object>>>> mDisAppearWatchList = new ArrayMap();
    private CellRenderContext cellRenderContext = new CellRenderContext();

    public WXRecyclerTemplateList(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
        this.initRecyclerTemplateList(instance, parent);
    }

    private void initRecyclerTemplateList(WXSDKInstance instance, WXVContainer parent) {
        JSONArray array;
        this.updateRecyclerAttr();
        this.mTemplateViewTypes = new ArrayMap();
        this.mTemplateViewTypes.put((Object)EMPTY_HOLDER_TEMPLATE_KEY, (Object)0);
        this.mTemplateSources = new HashMap<String, WXCell>();
        this.mTemplatesCache = new ConcurrentHashMap();
        this.mStickyHelper = new TemplateStickyHelper(this);
        this.listDataTemplateKey = WXUtils.getString(this.getAttrs().get("switch"), "case");
        this.listDataItemKey = WXUtils.getString(this.getAttrs().get("alias"), this.listDataItemKey);
        this.listDataIndexKey = WXUtils.getString(this.getAttrs().get("index"), this.listDataIndexKey);
        this.cellDataManager = new CellDataManager(this);
        if (this.getAttrs().get("listData") instanceof JSONArray && (array = (JSONArray)this.getAttrs().get("listData")).size() > 0) {
            this.cellDataManager.listData = array;
        }
    }

    @Override
    protected BounceRecyclerView initComponentHostView(@NonNull Context context) {
        BounceRecyclerView bounceRecyclerView = new BounceRecyclerView(context, this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        WXAttr attrs = this.getAttrs();
        String transforms = (String)attrs.get("transform");
        if (transforms != null) {
            ((WXRecyclerView)bounceRecyclerView.getInnerView()).addItemDecoration(RecyclerTransform.parseTransforms(this.getOrientation(), transforms));
        }
        this.mItemAnimator = ((WXRecyclerView)bounceRecyclerView.getInnerView()).getItemAnimator();
        if (attrs.get(NAME_TEMPLATE_CACHE_SIZE) != null) {
            this.templateCacheSize = WXUtils.getInteger(attrs.get(NAME_TEMPLATE_CACHE_SIZE), this.templateCacheSize);
        }
        boolean hasFixedSize = false;
        int itemViewCacheSize = 2;
        if (attrs.get(NAME_ITEM_VIEW_CACHE_SIZE) != null) {
            itemViewCacheSize = WXUtils.getNumberInt(this.getAttrs().get(NAME_ITEM_VIEW_CACHE_SIZE), itemViewCacheSize);
        }
        if (attrs.get(NAME_HAS_FIXED_SIZE) != null) {
            hasFixedSize = WXUtils.getBoolean(attrs.get(NAME_HAS_FIXED_SIZE), hasFixedSize);
        }
        RecyclerViewBaseAdapter recyclerViewBaseAdapter = new RecyclerViewBaseAdapter(this);
        recyclerViewBaseAdapter.setHasStableIds(true);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).setItemAnimator(null);
        if (itemViewCacheSize != 2) {
            ((WXRecyclerView)bounceRecyclerView.getInnerView()).setItemViewCacheSize(itemViewCacheSize);
        }
        if (bounceRecyclerView.getSwipeLayout() != null && WXUtils.getBoolean(this.getAttrs().get("nestedScrollingEnabled"), false).booleanValue()) {
            bounceRecyclerView.getSwipeLayout().setNestedScrollingEnabled(true);
        }
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).setHasFixedSize(hasFixedSize);
        bounceRecyclerView.setRecyclerViewBaseAdapter(recyclerViewBaseAdapter);
        bounceRecyclerView.setOverScrollMode(2);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).clearOnScrollListeners();
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).addOnScrollListener(this.mViewOnScrollListener);
        ((WXRecyclerView)bounceRecyclerView.getInnerView()).addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                List<OnWXScrollListener> listeners = WXRecyclerTemplateList.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    for (OnWXScrollListener listener : listeners) {
                        View topView;
                        if (listener == null || (topView = recyclerView.getChildAt(0)) == null) continue;
                        int y = topView.getTop();
                        listener.onScrollStateChanged((View)recyclerView, 0, y, newState);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                List<OnWXScrollListener> listeners = WXRecyclerTemplateList.this.getInstance().getWXScrollListeners();
                if (listeners != null && listeners.size() > 0) {
                    try {
                        for (OnWXScrollListener listener : listeners) {
                            if (listener == null) continue;
                            if (listener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)listener)).isNeedScroller(WXRecyclerTemplateList.this.getRef(), null)) continue;
                                listener.onScrolled((View)recyclerView, dx, dy);
                                continue;
                            }
                            listener.onScrolled((View)recyclerView, dx, dy);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        bounceRecyclerView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                BounceRecyclerView view = (BounceRecyclerView)WXRecyclerTemplateList.this.getHostView();
                if (view == null) {
                    return;
                }
                WXRecyclerTemplateList.this.mViewOnScrollListener.onScrolled((RecyclerView)view.getInnerView(), 0, 0);
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.listUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                if (WXRecyclerTemplateList.this.mStickyHelper != null && WXRecyclerTemplateList.this.mStickyHelper.getStickyTypes().size() > 0) {
                    WXRecyclerTemplateList.this.mStickyHelper.getStickyPositions().clear();
                    if (((WXRecyclerTemplateList)WXRecyclerTemplateList.this).cellDataManager.listData != null) {
                        for (int i = 0; i < ((WXRecyclerTemplateList)WXRecyclerTemplateList.this).cellDataManager.listData.size(); ++i) {
                            WXCell cell = WXRecyclerTemplateList.this.getSourceTemplate(i);
                            if (cell == null || !cell.isSticky()) continue;
                            WXRecyclerTemplateList.this.mStickyHelper.getStickyPositions().add(i);
                        }
                    }
                }
                if (WXRecyclerTemplateList.this.getHostView() != null && ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).getRecyclerViewBaseAdapter() != null) {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).getRecyclerViewBaseAdapter().notifyDataSetChanged();
                }
                if (WXEnvironment.isOpenDebugLog()) {
                    // empty if block
                }
            }
        };
        return bounceRecyclerView;
    }

    @Override
    protected void onHostViewInitialized(BounceRecyclerView host) {
        super.onHostViewInitialized(host);
        WXRecyclerView recyclerView = (WXRecyclerView)host.getInnerView();
        if (recyclerView == null || recyclerView.getAdapter() == null) {
            WXLogUtils.e(TAG, "RecyclerView is not found or Adapter is not bound");
            return;
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int width, int height) {
        int screenH = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int weexH = WXViewUtils.getWeexHeight(this.getInstanceId());
        int outHeight = height > (weexH >= screenH ? screenH : weexH) ? weexH - this.getAbsoluteY() : height;
        return super.measure((int)((float)width + this.mColumnGap), outHeight);
    }

    @Override
    public void bindStickStyle(WXComponent component) {
        WXComponent template = this.findParentType(component, WXCell.class);
        if (template == null) {
            return;
        }
        if (this.cellDataManager.listData == null || this.mStickyHelper == null) {
            return;
        }
        if (!this.mStickyHelper.getStickyTypes().contains(template.getRef())) {
            this.mStickyHelper.getStickyTypes().add(template.getRef());
            this.notifyUpdateList();
        }
    }

    @Override
    public void unbindStickStyle(WXComponent component) {
        WXComponent template = this.findParentType(component, WXCell.class);
        if (template == null || this.cellDataManager.listData == null || this.mStickyHelper == null) {
            return;
        }
        if (this.mStickyHelper.getStickyTypes().contains(template.getRef())) {
            this.mStickyHelper.getStickyTypes().remove(template.getRef());
            this.notifyUpdateList();
        }
    }

    @Nullable
    private WXCell findCell(WXComponent component) {
        WXVContainer parent;
        if (component instanceof WXCell) {
            return (WXCell)component;
        }
        if (component == null || (parent = component.getParent()) == null) {
            return null;
        }
        return this.findCell(parent);
    }

    private void setAppearanceWatch(WXComponent component, int event, boolean enable) {
        if (this.cellDataManager.listData == null || this.mAppearHelpers == null || TextUtils.isEmpty((CharSequence)component.getRef())) {
            return;
        }
        WXCell cell = this.findCell(component);
        int type = this.getCellTemplateItemType(cell);
        if (type < 0) {
            return;
        }
        ArrayList<AppearanceHelper> mAppearListeners = (ArrayList<AppearanceHelper>)this.mAppearHelpers.get((Object)type);
        if (mAppearListeners == null) {
            mAppearListeners = new ArrayList<AppearanceHelper>();
            this.mAppearHelpers.put((Object)type, mAppearListeners);
        }
        AppearanceHelper item = null;
        for (AppearanceHelper mAppearListener : mAppearListeners) {
            if (!component.getRef().equals(mAppearListener.getAwareChild().getRef())) continue;
            item = mAppearListener;
            break;
        }
        if (item != null) {
            item.setWatchEvent(event, enable);
        } else {
            item = new AppearanceHelper(component, type);
            item.setWatchEvent(event, enable);
            mAppearListeners.add(item);
        }
    }

    @Override
    public void bindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, true);
    }

    @Override
    public void bindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 0, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent component) {
        this.setAppearanceWatch(component, 1, false);
    }

    @JSMethod
    public void scrollTo(int position, Map<String, Object> options) {
        if (position >= 0) {
            boolean smooth = true;
            if (options != null) {
                smooth = WXUtils.getBoolean(options.get("animated"), true);
            }
            int pos = position;
            BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
            if (bounceRecyclerView == null) {
                return;
            }
            WXRecyclerView view = (WXRecyclerView)bounceRecyclerView.getInnerView();
            view.scrollTo(smooth, pos, 0, this.getOrientation());
        }
    }

    @Override
    public void scrollTo(WXComponent component, Map<String, Object> options) {
        float offsetFloat = 0.0f;
        boolean smooth = true;
        int position = -1;
        int typeIndex = -1;
        if (options != null) {
            String offsetStr = options.get("offset") == null ? "0" : options.get("offset").toString();
            smooth = WXUtils.getBoolean(options.get("animated"), true);
            if (offsetStr != null) {
                try {
                    offsetFloat = WXViewUtils.getRealPxByWidth(Float.parseFloat(offsetStr), this.getInstance().getInstanceViewPortWidth());
                }
                catch (Exception e) {
                    WXLogUtils.e("Float parseFloat error :" + e.getMessage());
                }
            }
            position = WXUtils.getNumberInt(options.get("cellIndex"), -1);
            typeIndex = WXUtils.getNumberInt(options.get("typeIndex"), -1);
        }
        WXCell cell = this.findCell(component);
        if (typeIndex >= 0 && this.cellDataManager.listData != null && component.getRef() != null) {
            int typePosition = 0;
            for (int i = 0; i < this.cellDataManager.listData.size(); ++i) {
                WXCell template = this.getSourceTemplate(i);
                if (template == null) continue;
                if (cell.getRef().equals(template.getRef())) {
                    ++typePosition;
                }
                if (typePosition <= typeIndex) continue;
                position = i;
                break;
            }
            if (position < 0) {
                position = this.cellDataManager.listData.size() - 1;
            }
        }
        int offset = (int)offsetFloat;
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        if (bounceRecyclerView == null) {
            return;
        }
        if (position >= 0) {
            int pos = position;
            WXRecyclerView view = (WXRecyclerView)bounceRecyclerView.getInnerView();
            view.scrollTo(smooth, pos, offset, this.getOrientation());
        }
    }

    @Override
    public int getScrollY() {
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((WXRecyclerView)bounceRecyclerView.getInnerView()).getScrollY();
    }

    @Override
    public int getScrollX() {
        BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)this.getHostView();
        return bounceRecyclerView == null ? 0 : ((WXRecyclerView)bounceRecyclerView.getInnerView()).getScrollX();
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override
    public void addChild(WXComponent child) {
        this.addChild(child, -1);
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        return 0;
    }

    @Override
    public void addChild(WXComponent child, int index) {
        if (!(child instanceof WXCell)) {
            super.addChild(child, index);
        }
        if (child instanceof WXBaseRefresh) {
            return;
        }
        if (child instanceof WXCell) {
            if (child.getAttrs() != null) {
                Object templateId = child.getAttrs().get("case");
                String key = WXUtils.getString(templateId, null);
                if (this.getAttrs().containsKey("switch")) {
                    if (this.defaultTemplateCell == null) {
                        this.defaultTemplateCell = (WXCell)child;
                        if (!TextUtils.isEmpty((CharSequence)key)) {
                            this.defaultTemplateKey = key;
                        } else {
                            key = this.defaultTemplateKey;
                            child.getAttrs().put("case", (Object)key);
                        }
                    }
                } else if (this.defaultTemplateCell == null || child.getAttrs().containsKey("default")) {
                    this.defaultTemplateCell = (WXCell)child;
                    if (!TextUtils.isEmpty((CharSequence)key)) {
                        this.defaultTemplateKey = key;
                    } else {
                        key = this.defaultTemplateKey;
                        child.getAttrs().put("case", (Object)key);
                    }
                }
                if (key != null) {
                    this.mTemplateSources.put(key, (WXCell)child);
                    this.renderTemplateCellWithData((WXCell)child);
                    if (this.mTemplateViewTypes.get((Object)key) == null) {
                        this.mTemplateViewTypes.put((Object)key, (Object)this.mTemplateViewTypes.size());
                    }
                }
            }
            this.notifyUpdateList();
        }
    }

    @Override
    public void addSubView(View child, int index) {
    }

    @Override
    public void createChildViewAt(int index) {
        int indexToCreate = index;
        if (indexToCreate < 0 && (indexToCreate = this.childCount() - 1) < 0) {
            return;
        }
        WXComponent child = this.getChild(indexToCreate);
        if (child instanceof WXBaseRefresh) {
            child.createView();
            this.setRefreshOrLoading(child);
        }
    }

    @Override
    public void remove(WXComponent child, boolean destroy) {
        this.removeFooterOrHeader(child);
        super.remove(child, destroy);
    }

    @Override
    public void computeVisiblePointInViewCoordinate(PointF pointF) {
        RecyclerView view = (RecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        pointF.set((float)view.computeHorizontalScrollOffset(), (float)view.computeVerticalScrollOffset());
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "listData": {
                this.setListData(param);
                return true;
            }
            case "alias": {
                this.listDataItemKey = WXUtils.getString(param, this.listDataItemKey);
                return true;
            }
            case "index": {
                this.listDataIndexKey = WXUtils.getString(param, this.listDataIndexKey);
                return true;
            }
            case "switch": 
            case "case": {
                this.listDataTemplateKey = WXUtils.getString(param, "case");
                return true;
            }
            case "loadmoreoffset": {
                return true;
            }
            case "scrollable": {
                boolean scrollable = WXUtils.getBoolean(param, true);
                this.setScrollable(scrollable);
                return true;
            }
            case "scrollDirection": {
                if (param != null) {
                    this.setScrollDirection(param.toString());
                }
                return true;
            }
            case "showScrollbar": {
                Boolean result = WXUtils.getBoolean(param, null);
                if (result != null) {
                    this.setShowScrollbar(result);
                }
                return true;
            }
            case "itemViewCacheSize": {
                return true;
            }
            case "hasFixedSize": {
                return true;
            }
            case "offsetAccuracy": {
                int accuracy = WXUtils.getInteger(param, 10);
                this.setOffsetAccuracy(accuracy);
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int accuracy) {
        float real = WXViewUtils.getRealPxByWidth(accuracy, this.getInstance().getInstanceViewPortWidth());
        this.mOffsetAccuracy = (int)real;
    }

    private void updateRecyclerAttr() {
        this.mColumnCount = this.getAttrs().getColumnCount();
        this.mColumnGap = this.getAttrs().getColumnGap();
        this.mColumnWidth = this.getAttrs().getColumnWidth();
        this.mPaddingLeft = this.getPadding().get(CSSShorthand.EDGE.LEFT);
        this.mPaddingRight = this.getPadding().get(CSSShorthand.EDGE.RIGHT);
    }

    @WXComponentProp(name="scrollDirection")
    public void setScrollDirection(String direction) {
    }

    @WXComponentProp(name="columnWidth")
    public void setColumnWidth(int columnCount) {
        if (this.getAttrs().getColumnWidth() != this.mColumnWidth) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean show) {
        if (this.getHostView() == null || ((BounceRecyclerView)this.getHostView()).getInnerView() == null) {
            return;
        }
        if (this.getOrientation() == 1) {
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setVerticalScrollBarEnabled(show);
        } else {
            ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setHorizontalScrollBarEnabled(show);
        }
    }

    @WXComponentProp(name="columnCount")
    public void setColumnCount(int columnCount) {
        if (this.getAttrs().getColumnCount() != this.mColumnCount) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="columnGap")
    public void setColumnGap(float columnGap) throws InterruptedException {
        if (this.getAttrs().getColumnGap() != this.mColumnGap) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean scrollable) {
        WXRecyclerView inner = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        inner.setScrollable(scrollable);
    }

    @JSMethod
    public void setListData(Object param) {
        boolean update;
        boolean bl = update = this.cellDataManager.listData != param;
        if (param instanceof JSONArray && update) {
            this.cellDataManager.setListData((JSONArray)param);
            this.notifyUpdateList();
        }
    }

    @JSMethod
    public void appendData(JSONArray data) {
        int position;
        if (data == null || data.size() == 0) {
            return;
        }
        if (this.cellDataManager.listData == null) {
            this.cellDataManager.listData = new JSONArray();
        }
        if ((position = this.cellDataManager.listData.size()) < 0) {
            position = 0;
        }
        if (data instanceof JSONArray) {
            this.cellDataManager.listData.addAll((Collection)data);
        }
        ((BounceRecyclerView)this.getHostView()).getRecyclerViewBaseAdapter().notifyItemRangeInserted(position, data.size());
    }

    @JSMethod
    public void insertData(int index, Object data) {
        if (data == null) {
            return;
        }
        if (this.cellDataManager.listData == null || index > this.cellDataManager.listData.size()) {
            return;
        }
        boolean renderStateChanged = this.cellDataManager.insertData(index, data);
        if (renderStateChanged) {
            this.notifyUpdateList();
        } else {
            ((BounceRecyclerView)this.getHostView()).getRecyclerViewBaseAdapter().notifyItemInserted(index);
        }
    }

    @JSMethod
    public void appendRange(int index, JSONArray data) {
        this.insertRange(index, data);
    }

    @JSMethod
    public void insertRange(int index, JSONArray data) {
        if (data == null || data.size() == 0) {
            return;
        }
        if (this.cellDataManager.listData == null || index > this.cellDataManager.listData.size()) {
            return;
        }
        boolean renderStateChange = this.cellDataManager.insertRange(index, data);
        if (renderStateChange) {
            this.notifyUpdateList();
        } else {
            ((BounceRecyclerView)this.getHostView()).getRecyclerViewBaseAdapter().notifyItemRangeInserted(index, data.size());
        }
    }

    @JSMethod
    public void updateData(int index, Object data) {
        if (data == null) {
            return;
        }
        if (this.cellDataManager.listData == null || index >= this.cellDataManager.listData.size()) {
            return;
        }
        boolean onlyDataChange = this.cellDataManager.updateData(data, index);
        if (onlyDataChange) {
            ((BounceRecyclerView)this.getHostView()).getRecyclerViewBaseAdapter().notifyItemChanged(index, data);
        } else {
            this.notifyUpdateList();
        }
    }

    @JSMethod
    public void removeData(int index, int count) {
        if (this.cellDataManager.listData == null || index >= this.cellDataManager.listData.size()) {
            return;
        }
        if (count <= 0) {
            count = 1;
        }
        int removeCount = 0;
        while (count > 0 && index < this.cellDataManager.listData.size()) {
            this.cellDataManager.removeData(index);
            --count;
            ++removeCount;
        }
        if (removeCount > 0) {
            this.notifyUpdateList();
        }
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
        this.mListCellCount = 0;
    }

    @Override
    public void updateProperties(Map<String, Object> props) {
        super.updateProperties(props);
        if ((props.containsKey("padding") || props.containsKey("paddingLeft") || props.containsKey("paddingRight")) && (this.mPaddingLeft != this.getPadding().get(CSSShorthand.EDGE.LEFT) || this.mPaddingRight != this.getPadding().get(CSSShorthand.EDGE.RIGHT))) {
            this.updateRecyclerAttr();
            WXRecyclerView wxRecyclerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            wxRecyclerView.initView(this.getContext(), this.mLayoutType, this.mColumnCount, this.mColumnGap, this.getOrientation());
        }
    }

    @Override
    public void addEvent(String type) {
        super.addEvent(type);
        if (ScrollStartEndHelper.isScrollEvent(type) && this.getHostView() != null && ((BounceRecyclerView)this.getHostView()).getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            WXRecyclerView innerView = (WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
            innerView.addOnScrollListener(new RecyclerView.OnScrollListener(){
                private int offsetXCorrection;
                private int offsetYCorrection;
                private boolean mFirstEvent = true;

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                    if (!layoutManager.canScrollVertically()) {
                        return;
                    }
                    int offsetX = recyclerView.computeHorizontalScrollOffset();
                    int offsetY = recyclerView.computeVerticalScrollOffset();
                    if (dx == 0 && dy == 0) {
                        this.offsetXCorrection = offsetX;
                        this.offsetYCorrection = offsetY;
                        offsetX = 0;
                        offsetY = 0;
                    } else {
                        offsetX -= this.offsetXCorrection;
                        offsetY -= this.offsetYCorrection;
                    }
                    WXRecyclerTemplateList.this.getScrollStartEndHelper().onScrolled(offsetX, offsetY);
                    if (!WXRecyclerTemplateList.this.getEvents().contains("scroll")) {
                        return;
                    }
                    if (this.mFirstEvent) {
                        this.mFirstEvent = false;
                        return;
                    }
                    if (WXRecyclerTemplateList.this.shouldReport(offsetX, offsetY)) {
                        WXRecyclerTemplateList.this.fireScrollEvent(recyclerView, offsetX, offsetY);
                    }
                }
            });
        }
    }

    private void fireScrollEvent(RecyclerView recyclerView, int offsetX, int offsetY) {
        this.fireEvent("scroll", this.getScrollEvent(recyclerView, offsetX, offsetY));
    }

    public Map<String, Object> getScrollEvent(RecyclerView recyclerView, int offsetX, int offsetY) {
        offsetY = -this.calcContentOffset(recyclerView);
        int contentWidth = recyclerView.getMeasuredWidth() + recyclerView.computeHorizontalScrollRange();
        int contentHeight = this.calcContentSize();
        HashMap<String, Object> event = new HashMap<String, Object>(2);
        HashMap<String, Float> contentSize = new HashMap<String, Float>(2);
        HashMap<String, Float> contentOffset = new HashMap<String, Float>(2);
        contentSize.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(contentWidth, this.getInstance().getInstanceViewPortWidth())));
        contentSize.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(contentHeight, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("x", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetX, this.getInstance().getInstanceViewPortWidth())));
        contentOffset.put("y", Float.valueOf(-WXViewUtils.getWebPxByWidth(offsetY, this.getInstance().getInstanceViewPortWidth())));
        event.put("contentSize", contentSize);
        event.put("contentOffset", contentOffset);
        return event;
    }

    private boolean shouldReport(int offsetX, int offsetY) {
        if (this.mLastReport.x == -1 && this.mLastReport.y == -1) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        int gapX = Math.abs(this.mLastReport.x - offsetX);
        int gapY = Math.abs(this.mLastReport.y - offsetY);
        if (gapX >= this.mOffsetAccuracy || gapY >= this.mOffsetAccuracy) {
            this.mLastReport.x = offsetX;
            this.mLastReport.y = offsetY;
            return true;
        }
        return false;
    }

    private boolean setRefreshOrLoading(final WXComponent child) {
        if (child instanceof WXRefresh && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnRefreshListener((WXRefresh)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).setHeaderView(child);
                }
            }), 100L);
            return true;
        }
        if (child instanceof WXLoading && this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).setOnLoadingListener((WXLoading)child);
            ((BounceRecyclerView)this.getHostView()).postDelayed(WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BounceRecyclerView)WXRecyclerTemplateList.this.getHostView()).setFooterView(child);
                }
            }), 100L);
            return true;
        }
        return false;
    }

    private void removeFooterOrHeader(WXComponent child) {
        if (child instanceof WXLoading) {
            ((BounceRecyclerView)this.getHostView()).removeFooterView(child);
        } else if (child instanceof WXRefresh) {
            ((BounceRecyclerView)this.getHostView()).removeHeaderView(child);
        }
    }

    @Override
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent child, View hostView, int width, int height, int left, int right, int top, int bottom) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)hostView.getLayoutParams();
        if (child instanceof WXBaseRefresh && params == null) {
            params = new LinearLayout.LayoutParams(width, height);
        } else if (params == null) {
            params = new RecyclerView.LayoutParams(width, height);
        } else {
            params.width = width;
            params.height = height;
            params.setMargins(left, 0, right, 0);
        }
        return params;
    }

    @Override
    public void destroy() {
        if (this.getHostView() != null) {
            ((BounceRecyclerView)this.getHostView()).removeCallbacks(this.listUpdateRunnable);
            if (((BounceRecyclerView)this.getHostView()).getInnerView() != null) {
                ((WXRecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView()).setAdapter(null);
            }
        }
        if (this.cellDataManager.listData != null) {
            this.cellDataManager.setListData(null);
        }
        if (this.mStickyHelper != null) {
            this.mStickyHelper = null;
        }
        if (this.mTemplateViewTypes != null) {
            this.mTemplateViewTypes.clear();
        }
        if (this.mTemplateSources != null) {
            this.mTemplateSources.clear();
        }
        if (this.mAppearHelpers != null) {
            this.mAppearHelpers.clear();
        }
        if (this.mDisAppearWatchList != null) {
            this.mDisAppearWatchList.clear();
        }
        super.destroy();
    }

    @Override
    public void onViewRecycled(TemplateViewHolder holder) {
    }

    @Override
    public void onBindViewHolder(TemplateViewHolder templateViewHolder, int position) {
        if (templateViewHolder == null) {
            return;
        }
        WXCell component = templateViewHolder.getTemplate();
        if (component == null) {
            return;
        }
        long start = System.currentTimeMillis();
        templateViewHolder.setHolderPosition(position);
        Object data = this.cellDataManager.listData.get(position);
        CellRenderState cellRenderState = this.cellDataManager.getRenderState(position);
        if (!(component.getRenderData() != data || cellRenderState != null && cellRenderState.isDirty())) {
            if (WXEnvironment.isOpenDebugLog()) {
                // empty if block
            }
            return;
        }
        List<WXComponent> updates = this.doRenderTemplate(component, position);
        Statements.doInitCompontent(updates);
        component.setRenderData(data);
        Layouts.doLayoutAsync(templateViewHolder, true);
        if (WXEnvironment.isOpenDebugLog()) {
            // empty if block
        }
    }

    @Override
    public TemplateViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        String template = (String)this.mTemplateViewTypes.keyAt(viewType);
        WXCell source = this.mTemplateSources.get(template);
        if (source == null) {
            FrameLayout view = new FrameLayout(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
            return new TemplateViewHolder((View)view, viewType);
        }
        WXCell component = this.getCellTemplateFromCache(template);
        boolean cacheHit = true;
        if (component == null) {
            cacheHit = false;
            if (!source.isSourceUsed()) {
                source.setSourceUsed(true);
                this.renderTemplateCellWithData(source);
                component = source;
                if (WXEnvironment.isOpenDebugLog()) {
                    // empty if block
                }
            }
        }
        if (component == null) {
            long start = System.currentTimeMillis();
            component = (WXCell)this.copyComponentFromSourceCell(source);
            if (WXEnvironment.isOpenDebugLog()) {
                // empty if block
            }
        }
        if (component.isLazy()) {
            WXRecyclerTemplateList.doCreateCellViewBindData(component, template, false);
            if (WXEnvironment.isOpenDebugLog()) {
                // empty if block
            }
        } else if (WXEnvironment.isOpenDebugLog()) {
            // empty if block
        }
        TemplateViewHolder templateViewHolder = new TemplateViewHolder(component, viewType);
        return templateViewHolder;
    }

    public WXComponent copyComponentFromSourceCell(WXCell cell) {
        this.renderTemplateCellWithData(cell);
        WXCell component = (WXCell)Statements.copyComponentTree(cell);
        component.setRenderData(cell.getRenderData());
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void renderTemplateCellWithData(WXCell cell) {
        if (cell.getRenderData() == null && this.cellDataManager.listData != null && this.cellDataManager.listData.size() > 0) {
            WXRecyclerTemplateList wXRecyclerTemplateList = this;
            synchronized (wXRecyclerTemplateList) {
                if (cell.getRenderData() == null) {
                    for (int i = 0; i < this.cellDataManager.listData.size(); ++i) {
                        if (cell != this.getSourceTemplate(i)) continue;
                        Object data = this.cellDataManager.listData.get(i);
                        this.doRenderTemplate(cell, i);
                        Layouts.doSafeLayout(cell);
                        cell.setRenderData(data);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public int getItemViewType(int position) {
        String template = this.getTemplateKey(position);
        int type = this.mTemplateViewTypes.indexOfKey((Object)template);
        if (type < 0) {
            type = this.mTemplateViewTypes.indexOfKey((Object)EMPTY_HOLDER_TEMPLATE_KEY);
        }
        return type;
    }

    private List<WXComponent> doRenderTemplate(WXCell cell, int position) {
        CellRenderState cellRenderState;
        this.cellRenderContext.clear();
        Object item = this.cellDataManager.listData.get(position);
        this.cellRenderContext.renderState = cellRenderState = this.cellDataManager.getRenderState(position);
        this.cellRenderContext.templateList = this;
        this.cellRenderContext.position = position;
        ArrayStack stack = this.cellRenderContext.stack;
        Map map = this.cellRenderContext.map;
        if (this.cellDataManager.listData != null) {
            stack.push(map);
            map.put(this.listDataKey, this.cellDataManager.listData);
            if (!TextUtils.isEmpty((CharSequence)this.listDataIndexKey)) {
                map.put(this.listDataIndexKey, new PositionRef(cellRenderState));
            }
            if (!TextUtils.isEmpty((CharSequence)this.listDataItemKey)) {
                map.put(this.listDataItemKey, item);
            } else {
                stack.push(item);
            }
        }
        if (cellRenderState.itemId <= 0L) {
            this.getItemId(position);
        }
        List<WXComponent> updates = Statements.doRender(cell, this.cellRenderContext);
        if (cellRenderState.isDirty()) {
            cellRenderState.resetDirty();
        }
        return updates;
    }

    public ArrayStack copyStack(CellRenderContext context, ArrayStack stack) {
        ArrayStack onceStack = new ArrayStack();
        for (int index = 0; index < stack.size(); ++index) {
            Object value = stack.get(index);
            if (value instanceof Map) {
                value = new HashMap((Map)value);
            }
            onceStack.push(value);
        }
        return onceStack;
    }

    public String getTemplateKey(int position) {
        Object data = this.safeGetListData(position);
        return this.getTemplateKey(data);
    }

    public String getTemplateKey(Object data) {
        String template = null;
        if (data instanceof JSONObject) {
            template = ((JSONObject)data).getString(this.listDataTemplateKey);
        }
        if (TextUtils.isEmpty(template)) {
            template = this.defaultTemplateCell != null ? this.defaultTemplateKey : EMPTY_HOLDER_TEMPLATE_KEY;
        }
        return template;
    }

    public WXCell getSourceTemplate(int position) {
        String template = this.getTemplateKey(position);
        return this.mTemplateSources.get(template);
    }

    private int getCellTemplateItemType(WXCell cell) {
        if (cell == null) {
            return -1;
        }
        if (cell.getAttrs() != null) {
            int type;
            Object templateId = cell.getAttrs().get("case");
            String template = WXUtils.getString(templateId, null);
            if (cell == this.defaultTemplateCell) {
                template = this.defaultTemplateKey;
            }
            if ((type = this.mTemplateViewTypes.indexOfKey((Object)template)) < 0) {
                return -1;
            }
            return type;
        }
        return 0;
    }

    @Override
    public int getItemCount() {
        if (this.cellDataManager.listData == null) {
            return 0;
        }
        if (this.mTemplateViewTypes == null || this.mTemplateViewTypes.size() <= 1) {
            return 0;
        }
        if (this.mTemplateSources == null || this.mTemplateSources.size() == 0) {
            return 0;
        }
        return this.cellDataManager.listData.size();
    }

    @Override
    public boolean onFailedToRecycleView(TemplateViewHolder holder) {
        return false;
    }

    @Override
    public long getItemId(int position) {
        CellRenderState renderState = this.cellDataManager.getRenderState(position);
        if (renderState.itemId <= 0L) {
            String template = this.getTemplateKey(position);
            if (TextUtils.isEmpty((CharSequence)template)) {
                return -1L;
            }
            Object data = this.safeGetListData(position);
            if (data instanceof JSONObject && ((JSONObject)data).containsKey((Object)"keyItemId")) {
                renderState.itemId = ((JSONObject)data).getLongValue("keyItemId");
            } else {
                long itemId;
                long id = Math.abs(data.hashCode());
                renderState.itemId = itemId = (id << 24) + (long)position;
            }
        }
        return renderState.itemId;
    }

    @Override
    public void onBeforeScroll(int dx, int dy) {
        if (this.mStickyHelper != null) {
            this.mStickyHelper.onBeforeScroll(dx, dy);
        }
    }

    @Override
    public void onLoadMore(int offScreenY) {
        try {
            float offsetParsed;
            String offset = this.getAttrs().getLoadMoreOffset();
            if (TextUtils.isEmpty((CharSequence)offset)) {
                offset = "0";
            }
            if ((float)offScreenY <= (offsetParsed = WXViewUtils.getRealPxByWidth(Integer.parseInt(offset), this.getInstance().getInstanceViewPortWidth())) && this.cellDataManager.listData != null && (this.mListCellCount != this.cellDataManager.listData.size() || this.mForceLoadmoreNextTime)) {
                this.fireEvent("loadmore");
                this.mListCellCount = this.cellDataManager.listData.size();
                this.mForceLoadmoreNextTime = false;
            }
        }
        catch (Exception e) {
            WXLogUtils.d("WXRecyclerTemplateList onLoadMore : ", e);
        }
    }

    @Override
    public void notifyAppearStateChange(int firstVisible, int lastVisible, int directionX, int directionY) {
        String direction;
        if (this.mAppearHelpers == null || this.mAppearHelpers.size() <= 0) {
            return;
        }
        String string = directionY > 0 ? "up" : (direction = directionY < 0 ? "down" : null);
        if (this.getOrientation() == 0 && directionX != 0) {
            direction = directionX > 0 ? "left" : "right";
        }
        RecyclerView recyclerView = (RecyclerView)((BounceRecyclerView)this.getHostView()).getInnerView();
        block0: for (int position = firstVisible; position <= lastVisible; ++position) {
            int type = this.getItemViewType(position);
            List helpers = (List)this.mAppearHelpers.get((Object)type);
            if (helpers == null) continue;
            for (AppearanceHelper helper : helpers) {
                Map componentDisAppearList;
                List<WXComponent> childListeners;
                if (!helper.isWatch()) continue;
                TemplateViewHolder itemHolder = (TemplateViewHolder)recyclerView.findViewHolderForAdapterPosition(position);
                if (itemHolder == null || itemHolder.getComponent() == null || (childListeners = this.findChildListByRef(itemHolder.getComponent(), helper.getAwareChild().getRef())) == null || childListeners.size() == 0) continue block0;
                Map disAppearList = (Map)this.mDisAppearWatchList.get((Object)position);
                if (disAppearList == null) {
                    disAppearList = new ArrayMap();
                    this.mDisAppearWatchList.put((Object)position, (Object)disAppearList);
                }
                if ((componentDisAppearList = (Map)disAppearList.get(helper.getAwareChild().getRef())) == null) {
                    componentDisAppearList = new ArrayMap();
                    disAppearList.put(helper.getAwareChild().getRef(), componentDisAppearList);
                }
                for (int m = 0; m < childListeners.size(); ++m) {
                    WXComponent childLisener = childListeners.get(m);
                    if (childLisener.getHostView() == null) continue;
                    boolean appear = helper.isViewVisible((View)childLisener.getHostView());
                    int key = childLisener.getHostView().hashCode();
                    if (appear) {
                        if (componentDisAppearList.containsKey(key)) continue;
                        childLisener.notifyAppearStateChange("appear", direction);
                        List eventArgs = null;
                        if (childLisener.getEvents() != null && childLisener.getEvents().getEventBindingArgsValues() != null && childLisener.getEvents().getEventBindingArgsValues().get((Object)"disappear") != null) {
                            eventArgs = (List)childLisener.getEvents().getEventBindingArgsValues().get((Object)"disappear");
                        }
                        componentDisAppearList.put(key, eventArgs);
                        continue;
                    }
                    if (!componentDisAppearList.containsKey(key)) continue;
                    childLisener.notifyAppearStateChange("disappear", direction);
                    componentDisAppearList.remove(key);
                }
            }
        }
        int count = this.getItemCount();
        for (int position = 0; position < count; ++position) {
            if (position >= firstVisible && position <= lastVisible) {
                position = lastVisible + 1;
                continue;
            }
            Map map = (Map)this.mDisAppearWatchList.get((Object)position);
            if (map == null) continue;
            WXCell template = this.mTemplateSources.get(this.getTemplateKey(position));
            if (template == null) {
                return;
            }
            Set cellWatcherEntries = map.entrySet();
            for (Map.Entry cellWatcherEntry : cellWatcherEntries) {
                Map eventWatchers;
                String ref = (String)cellWatcherEntry.getKey();
                WXComponent component = this.findChildByRef(template, ref);
                if (component == null || (eventWatchers = (Map)cellWatcherEntry.getValue()) == null || eventWatchers.size() == 0) continue;
                WXEvent events = component.getEvents();
                Set eventWatcherEntries = eventWatchers.entrySet();
                for (Map.Entry eventWatcherEntry : eventWatcherEntries) {
                    events.putEventBindingArgsValue("disappear", (List)eventWatcherEntry.getValue());
                    component.notifyAppearStateChange("disappear", direction);
                }
                eventWatchers.clear();
            }
            this.mDisAppearWatchList.remove((Object)position);
        }
    }

    private Object safeGetListData(int position) {
        try {
            return this.cellDataManager.listData.get(position);
        }
        catch (Exception e) {
            return JSONObject.parseObject((String)"{}");
        }
    }

    public void notifyUpdateList() {
        if (this.getHostView() == null || ((BounceRecyclerView)this.getHostView()).getInnerView() == null || this.listUpdateRunnable == null) {
            return;
        }
        if (Looper.getMainLooper().getThread().getId() != Thread.currentThread().getId()) {
            ((BounceRecyclerView)this.getHostView()).removeCallbacks(this.listUpdateRunnable);
            ((BounceRecyclerView)this.getHostView()).post(this.listUpdateRunnable);
        } else {
            this.listUpdateRunnable.run();
        }
    }

    private int calcContentSize() {
        int totalHeight = 0;
        if (this.cellDataManager.listData == null) {
            return totalHeight;
        }
        for (int i = 0; i < this.cellDataManager.listData.size(); ++i) {
            WXCell child = this.getSourceTemplate(i);
            if (child == null) continue;
            totalHeight = (int)((float)totalHeight + child.getLayoutHeight());
        }
        return totalHeight;
    }

    public int calcContentOffset(RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            View firstVisibleView;
            int firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXCell cell = this.getSourceTemplate(i);
                if (cell == null) continue;
                offset = (int)((float)offset - cell.getLayoutHeight());
            }
            if (layoutManager instanceof GridLayoutManager) {
                int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
                offset /= spanCount;
            }
            if ((firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition)) != null) {
                offset += firstVisibleView.getTop();
            }
            return offset;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
            int firstVisibleItemPosition = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0];
            int offset = 0;
            for (int i = 0; i < firstVisibleItemPosition; ++i) {
                WXCell cell = this.getSourceTemplate(i);
                if (cell == null) continue;
                offset = (int)((float)offset - cell.getLayoutHeight());
            }
            offset /= spanCount;
            View firstVisibleView = layoutManager.findViewByPosition(firstVisibleItemPosition);
            if (firstVisibleView != null) {
                offset += firstVisibleView.getTop();
            }
            return offset;
        }
        return -1;
    }

    public WXComponent findParentType(WXComponent component, Class type) {
        if (component.getClass() == type) {
            return component;
        }
        if (component.getParent() != null) {
            this.findTypeParent(component.getParent(), type);
        }
        return null;
    }

    public WXComponent findChildByRef(WXComponent component, String ref) {
        if (ref.equals(component.getRef())) {
            return component;
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent child = this.findChildByRef(container.getChild(i), ref);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public List<WXComponent> findChildListByRef(WXComponent component, String ref) {
        WXComponent child = this.findChildByRef(component, ref);
        if (child == null) {
            return null;
        }
        ArrayList<WXComponent> componentList = new ArrayList<WXComponent>();
        WXVContainer container = child.getParent();
        if (container != null && !(container instanceof WXRecyclerTemplateList)) {
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent element = container.getChild(i);
                if (!ref.equals(element.getRef())) continue;
                componentList.add(element);
            }
        } else {
            componentList.add(child);
        }
        return componentList;
    }

    private WXCell getCellTemplateFromCache(String template) {
        TemplateCache cache = this.mTemplatesCache.get(template);
        WXCell component = null;
        if (cache != null && cache.cells != null && cache.cells.size() > 0) {
            component = cache.cells.poll();
        }
        if (cache == null || !cache.isLoadIng) {
            boolean allowPreload;
            if (cache == null) {
                cache = new TemplateCache();
                this.mTemplatesCache.put(template, cache);
            }
            cache.isLoadIng = true;
            WXCell source = this.mTemplateSources.get(template);
            if (source != null && (allowPreload = WXUtils.getBoolean(source.getAttrs().get("preload"), true).booleanValue())) {
                AsyncCellLoadTask asyncCellLoadTask = new AsyncCellLoadTask(template, source, this);
                asyncCellLoadTask.startTask();
            }
        }
        return component;
    }

    public static void doCreateCellViewBindData(WXCell component, String template, boolean inPreload) {
        if (component.isLazy()) {
            long start = System.currentTimeMillis();
            ComponentUtils.initLazyComponent(component, null);
            if (WXEnvironment.isOpenDebugLog()) {
                // empty if block
            }
        }
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            this.mScrollStartEndHelper = new ScrollStartEndHelper(this);
        }
        return this.mScrollStartEndHelper;
    }

    public int getTemplateCacheSize() {
        return this.templateCacheSize;
    }

    public ConcurrentHashMap<String, TemplateCache> getTemplatesCache() {
        if (this.mTemplatesCache == null) {
            this.mTemplatesCache = new ConcurrentHashMap();
        }
        return this.mTemplatesCache;
    }

    public CellDataManager getCellDataManager() {
        return this.cellDataManager;
    }
}

