/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.transition.WXTransition;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicActionAbstractAddElement;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;
import java.util.Set;

public class GraphicActionAddElement
extends GraphicActionAbstractAddElement {
    private WXVContainer parent;
    private WXComponent child;
    private GraphicPosition layoutPosition;
    private GraphicSize layoutSize;

    public GraphicActionAddElement(String pageId, String ref, String componentType, String parentRef, int index, Map<String, String> style, Map<String, String> attributes, Set<String> events, float[] margins, float[] paddings, float[] borders) {
        super(pageId, ref);
        this.mComponentType = componentType;
        this.mParentRef = parentRef;
        this.mIndex = index;
        this.mStyle = style;
        this.mAttributes = attributes;
        this.mEvents = events;
        this.mPaddings = paddings;
        this.mMargins = margins;
        this.mBorders = borders;
        WXSDKInstance instance = WXSDKManager.getInstance().getWXRenderManager().getWXSDKInstance(this.getPageId());
        if (instance == null || instance.getContext() == null) {
            return;
        }
        this.parent = (WXVContainer)WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.mParentRef);
        BasicComponentData basicComponentData = new BasicComponentData(ref, this.mComponentType, this.mParentRef);
        this.child = this.createComponent(instance, this.parent, basicComponentData);
        this.child.setTransition(WXTransition.fromMap(this.child.getStyles(), this.child));
        if (this.child == null || this.parent == null) {
            return;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setSize(GraphicSize graphicSize) {
        this.layoutSize = graphicSize;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setPosition(GraphicPosition position) {
        this.layoutPosition = position;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setIndex(int index) {
        this.mIndex = index;
    }

    @Override
    public void executeAction() {
        try {
            this.parent.addChild(this.child, this.mIndex);
            this.parent.createChildViewAt(this.mIndex);
            long start = System.currentTimeMillis();
            if (this.layoutPosition != null && this.layoutSize != null) {
                this.child.updateDemission(this.layoutSize, this.layoutPosition);
            }
            this.child.applyLayoutAndEvent(this.child);
            WXSDKManager.getInstance().getSDKInstance(this.getPageId()).callLayoutaAplyLayoutAndEventTime(System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            this.child.bindData(this.child);
            WXSDKManager.getInstance().getSDKInstance(this.getPageId()).callLayoutBindDataCoreTime(System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            WXLogUtils.e("add component failed.", e);
        }
    }
}

