/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.ui.action.IExecutable;
import com.taobao.weex.utils.WXLogUtils;

public abstract class BasicGraphicAction
implements IExecutable,
Runnable {
    private final String mPageId;
    private final String mRef;

    public BasicGraphicAction(String pageId, String ref) {
        this.mPageId = pageId;
        this.mRef = ref;
    }

    public final String getPageId() {
        return this.mPageId;
    }

    public final String getRef() {
        return this.mRef;
    }

    public void executeActionOnRender() {
        if (TextUtils.isEmpty((CharSequence)this.mPageId)) {
            WXLogUtils.e("[BasicGraphicAction] pageId can not be null");
            if (WXEnvironment.isApkDebugable()) {
                throw new RuntimeException("[" + this.getClass().getName() + "] pageId can not be null");
            }
            return;
        }
        WXSDKManager.getInstance().getWXRenderManager().postGraphicAction(this.mPageId, this);
    }

    @Override
    public void run() {
        try {
            this.executeAction();
        }
        catch (Throwable e) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("BasicGraphicAction", "SafeRunnable run throw expection:" + e.getMessage());
                throw e;
            }
            WXLogUtils.w("BasicGraphicAction", e);
        }
    }
}

