/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.support.annotation.NonNull;
import android.view.View;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.utils.WXUtils;
import java.util.Map;
import java.util.Set;

public class BasicComponentData<T extends View> {
    public String mRef;
    public String mComponentType;
    public String mParentRef;
    private WXStyle mStyles;
    private WXAttr mAttributes;
    private WXEvent mEvents;
    private CSSShorthand mMargins;
    private CSSShorthand mPaddings;
    private CSSShorthand mBorders;

    public BasicComponentData(String ref, String componentType, String parentRef) {
        this.mRef = ref;
        this.mComponentType = componentType;
        this.mParentRef = parentRef;
    }

    public void addStyle(Map<String, Object> styles) {
        this.addStyle(styles, false);
    }

    public final void addStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        if (this.mStyles == null) {
            this.mStyles = new WXStyle(styles);
        } else {
            this.mStyles.putAll(styles, byPesudo);
        }
    }

    public final void addAttr(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr(attrs, 0);
        } else {
            this.mAttributes.putAll((Map<? extends String, ?>)attrs);
        }
    }

    public final void addEvent(Set<String> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        this.mEvents.addAll(events);
    }

    public final void addShorthand(float[] shorthand, CSSShorthand.TYPE type) {
        if (shorthand.length == 4) {
            switch (type) {
                case MARGIN: {
                    if (this.mMargins == null) {
                        this.mMargins = new CSSShorthand(shorthand);
                        break;
                    }
                    this.mMargins.replace(shorthand);
                    break;
                }
                case PADDING: {
                    if (this.mPaddings == null) {
                        this.mPaddings = new CSSShorthand(shorthand);
                        break;
                    }
                    this.mPaddings.replace(shorthand);
                    break;
                }
                case BORDER: {
                    if (this.mBorders == null) {
                        this.mBorders = new CSSShorthand(shorthand);
                        break;
                    }
                    this.mBorders.replace(shorthand);
                }
            }
        }
    }

    public final void addShorthand(Map<String, String> shorthand) {
        if (shorthand != null && !shorthand.isEmpty()) {
            for (Map.Entry<String, String> item : shorthand.entrySet()) {
                String key;
                switch (key = item.getKey()) {
                    case "margin": {
                        this.addMargin(CSSShorthand.EDGE.ALL, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "marginLeft": {
                        this.addMargin(CSSShorthand.EDGE.LEFT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "marginTop": {
                        this.addMargin(CSSShorthand.EDGE.TOP, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "marginRight": {
                        this.addMargin(CSSShorthand.EDGE.RIGHT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "marginBottom": {
                        this.addMargin(CSSShorthand.EDGE.BOTTOM, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "borderWidth": {
                        this.addBorder(CSSShorthand.EDGE.ALL, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "borderTopWidth": {
                        this.addBorder(CSSShorthand.EDGE.TOP, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "borderRightWidth": {
                        this.addBorder(CSSShorthand.EDGE.RIGHT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "borderBottomWidth": {
                        this.addBorder(CSSShorthand.EDGE.BOTTOM, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "borderLeftWidth": {
                        this.addBorder(CSSShorthand.EDGE.LEFT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "padding": {
                        this.addPadding(CSSShorthand.EDGE.ALL, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "paddingLeft": {
                        this.addPadding(CSSShorthand.EDGE.LEFT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "paddingTop": {
                        this.addPadding(CSSShorthand.EDGE.TOP, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "paddingRight": {
                        this.addPadding(CSSShorthand.EDGE.RIGHT, WXUtils.fastGetFloat(shorthand.get(key)));
                        break;
                    }
                    case "paddingBottom": {
                        this.addPadding(CSSShorthand.EDGE.BOTTOM, WXUtils.fastGetFloat(shorthand.get(key)));
                    }
                }
            }
        }
    }

    private void addMargin(CSSShorthand.EDGE spacingType, float margin) {
        if (this.mMargins == null) {
            this.mMargins = new CSSShorthand();
        }
        this.mMargins.set(spacingType, margin);
    }

    private void addPadding(CSSShorthand.EDGE spacingType, float padding) {
        if (this.mPaddings == null) {
            this.mPaddings = new CSSShorthand();
        }
        this.mPaddings.set(spacingType, padding);
    }

    private void addBorder(CSSShorthand.EDGE spacingType, float border) {
        if (this.mBorders == null) {
            this.mBorders = new CSSShorthand();
        }
        this.mBorders.set(spacingType, border);
    }

    @NonNull
    public final WXStyle getStyles() {
        if (this.mStyles == null) {
            this.mStyles = new WXStyle();
        }
        return this.mStyles;
    }

    @NonNull
    public final WXAttr getAttrs() {
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr();
        }
        return this.mAttributes;
    }

    @NonNull
    public final WXEvent getEvents() {
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        return this.mEvents;
    }

    @NonNull
    public final CSSShorthand getMargin() {
        if (this.mMargins == null) {
            this.mMargins = new CSSShorthand();
        }
        return this.mMargins;
    }

    @NonNull
    public final CSSShorthand getPadding() {
        if (this.mPaddings == null) {
            this.mPaddings = new CSSShorthand();
        }
        return this.mPaddings;
    }

    @NonNull
    public CSSShorthand getBorder() {
        if (this.mBorders == null) {
            this.mBorders = new CSSShorthand();
        }
        return this.mBorders;
    }

    public final void setMargins(@NonNull CSSShorthand mMargins) {
        this.mMargins = mMargins;
    }

    public final void setPaddings(@NonNull CSSShorthand mPaddings) {
        this.mPaddings = mPaddings;
    }

    public final void setBorders(@NonNull CSSShorthand mBorders) {
        this.mBorders = mBorders;
    }
}

