/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.dom.RenderContext;
import com.taobao.weex.ui.RenderContextImpl;
import com.taobao.weex.ui.WXRenderHandler;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WXRenderManager {
    private ConcurrentHashMap<String, RenderContextImpl> mRenderContext = new ConcurrentHashMap();
    private WXRenderHandler mWXRenderHandler = new WXRenderHandler();

    public RenderContext getRenderContext(String instanceId) {
        return this.mRenderContext.get(instanceId);
    }

    @Nullable
    public WXComponent getWXComponent(String instanceId, String ref) {
        if (instanceId == null || TextUtils.isEmpty((CharSequence)ref)) {
            return null;
        }
        RenderContext stmt = this.getRenderContext(instanceId);
        return stmt == null ? null : stmt.getComponent(ref);
    }

    public WXSDKInstance getWXSDKInstance(String instanceId) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement == null) {
            return null;
        }
        return statement.getWXSDKInstance();
    }

    public void postOnUiThread(Runnable runnable, long delayMillis) {
        this.mWXRenderHandler.postDelayed(WXThread.secure(runnable), delayMillis);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void postOnUiThread(Runnable runnable) {
        this.mWXRenderHandler.post(WXThread.secure(runnable));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void removeTask(Runnable runnable) {
        this.mWXRenderHandler.removeCallbacks(runnable);
    }

    public void removeRenderStatement(String instanceId) {
        if (!WXUtils.isUiThread()) {
            throw new WXRuntimeException("[WXRenderManager] removeRenderStatement can only be called in main thread");
        }
        RenderContextImpl statement = this.mRenderContext.remove(instanceId);
        if (statement != null) {
            statement.destroy();
        }
        if (instanceId == null) {
            this.mWXRenderHandler.removeCallbacksAndMessages(null);
        } else {
            this.mWXRenderHandler.removeMessages(instanceId.hashCode());
        }
    }

    public void postGraphicAction(String instanceId, BasicGraphicAction action) {
        RenderContextImpl renderContext = this.mRenderContext.get(instanceId);
        if (renderContext == null) {
            return;
        }
        this.mWXRenderHandler.post(instanceId, action);
    }

    public void registerInstance(WXSDKInstance instance) {
        this.mRenderContext.put(instance.getInstanceId(), new RenderContextImpl(instance));
    }

    public List<WXSDKInstance> getAllInstances() {
        ArrayList<WXSDKInstance> instances = null;
        if (this.mRenderContext != null && !this.mRenderContext.isEmpty()) {
            instances = new ArrayList<WXSDKInstance>();
            for (Map.Entry<String, RenderContextImpl> entry : this.mRenderContext.entrySet()) {
                RenderContextImpl renderStatement = entry.getValue();
                if (renderStatement == null) continue;
                instances.add(renderStatement.getWXSDKInstance());
            }
        }
        return instances;
    }

    public void registerComponent(String instanceId, String ref, WXComponent comp) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            statement.registerComponent(ref, comp);
        }
    }

    public WXComponent unregisterComponent(String instanceId, String ref) {
        RenderContextImpl statement = this.mRenderContext.get(instanceId);
        if (statement != null) {
            return statement.unregisterComponent(ref);
        }
        return null;
    }
}

