/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.bridge;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.bridge.WXParams;
import com.taobao.weex.common.IWXBridge;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.HashSet;

public class WXBridge
implements IWXBridge {
    public static final boolean MULTIPROCESS = true;
    public static final String TAG = "WXBridge";

    private native int nativeInitFrameworkEnv(String var1, WXParams var2, String var3, boolean var4);

    private native int nativeInitFramework(String var1, WXParams var2);

    private native int nativeExecJS(String var1, String var2, String var3, WXJSObject[] var4);

    private native int nativeExecJSService(String var1);

    public native byte[] nativeExecJSWithResult(String var1, String var2, String var3, WXJSObject[] var4);

    public native int nativeCreateInstanceContext(String var1, String var2, String var3, WXJSObject[] var4);

    public native int nativeDestoryInstance(String var1, String var2, String var3, WXJSObject[] var4);

    public native String nativeExecJSOnInstance(String var1, String var2, int var3);

    private native void nativeTakeHeapSnapshot(String var1);

    private native void nativeBindMeasurementToWXCore(String var1, String var2, ContentBoxMeasurement var3);

    private native void nativeSetRenderContainerWrapContent(boolean var1, String var2);

    public native int nativePrintFirstScreenRenderTime(String var1);

    public native int nativePrintRenderFinishTime(String var1);

    private native void nativeSetDefaultHeightAndWidthIntoRootDom(String var1, float var2, float var3, boolean var4, boolean var5);

    private native void nativeOnInstanceClose(String var1);

    private native void nativeForceLayout(String var1);

    private native boolean nativeNotifyLayout(String var1);

    private native void nativeSetStyleWidth(String var1, String var2, float var3);

    private native void nativeSetStyleHeight(String var1, String var2, float var3);

    private native void nativeSetMargin(String var1, String var2, int var3, float var4);

    private native void nativeSetPadding(String var1, String var2, int var3, float var4);

    private native void nativeSetPosition(String var1, String var2, int var3, float var4);

    private native void nativeMarkDirty(String var1, String var2, boolean var3);

    private native void nativeRegisterCoreEnv(String var1, String var2);

    private native void nativeSetViewPortWidth(String var1, float var2);

    public native void nativeUpdateGlobalConfig(String var1);

    @Override
    public int initFramework(String framework, WXParams params) {
        return this.nativeInitFramework(framework, params);
    }

    @Override
    public int initFrameworkEnv(String framework, WXParams params, String cacheDir, boolean pieSupport) {
        return this.nativeInitFrameworkEnv(framework, params, cacheDir, pieSupport);
    }

    @Override
    public int execJS(String instanceId, String namespace, String function, WXJSObject[] args) {
        return this.nativeExecJS(instanceId, namespace, function, args);
    }

    @Override
    public byte[] execJSWithResult(String instanceId, String namespace, String function, WXJSObject[] args) {
        return this.nativeExecJSWithResult(instanceId, namespace, function, args);
    }

    @Override
    public int execJSService(String javascript) {
        return this.nativeExecJSService(javascript);
    }

    @Override
    public void takeHeapSnapshot(String filename) {
        this.nativeTakeHeapSnapshot(filename);
    }

    @Override
    public int createInstanceContext(String instanceId, String name, String function, WXJSObject[] args) {
        return this.nativeCreateInstanceContext(instanceId, name, function, args);
    }

    @Override
    public int destoryInstance(String instanceId, String name, String function, WXJSObject[] args) {
        return this.nativeDestoryInstance(instanceId, name, function, args);
    }

    @Override
    public String execJSOnInstance(String instanceId, String script, int type) {
        return this.nativeExecJSOnInstance(instanceId, script, type);
    }

    @Override
    public int callNative(String instanceId, byte[] tasks, String callback) {
        return this.callNative(instanceId, new String(tasks), callback);
    }

    @Override
    public int callNative(String instanceId, String tasks, String callback) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callNative(instanceId, tasks, callback);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callNative throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        if (WXEnvironment.isApkDebugable() && errorCode == -1) {
            WXLogUtils.w("destroyInstance :" + instanceId + " JSF must stop callNative");
        }
        return errorCode;
    }

    @Override
    public void reportJSException(String instanceId, String func, String exception) {
        WXBridgeManager.getInstance().reportJSException(instanceId, func, exception);
    }

    @Override
    public Object callNativeModule(String instanceId, String module, String method, byte[] arguments, byte[] options) {
        JSONArray argArray = JSON.parseArray((String)new String(arguments));
        JSONObject optionsObj = null;
        if (options != null) {
            optionsObj = JSON.parseObject((String)new String(options));
        }
        Object object = WXBridgeManager.getInstance().callNativeModule(instanceId, module, method, argArray, optionsObj);
        return new WXJSObject(object);
    }

    @Override
    public void callNativeComponent(String instanceId, String ref, String method, byte[] arguments, byte[] options) {
        JSONArray argArray = JSON.parseArray((String)new String(arguments));
        WXBridgeManager.getInstance().callNativeComponent(instanceId, ref, method, argArray, options);
    }

    public void setTimeoutNative(String callbackId, String time) {
        WXBridgeManager.getInstance().setTimeout(callbackId, time);
    }

    public void setJSFrmVersion(String version) {
        if (version != null) {
            WXEnvironment.JS_LIB_SDK_VERSION = version;
        }
    }

    @Override
    public int callUpdateFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callRefreshFinish(String instanceId, byte[] tasks, String callback) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRefreshFinish(instanceId, callback);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public void reportServerCrash(String instanceId, String crashFile) {
        block2: {
            WXLogUtils.e(TAG, "reportServerCrash instanceId:" + instanceId);
            int errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callReportCrashReloadPage(instanceId, crashFile);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "reloadPageNative throw exception:" + e.getMessage());
            }
        }
    }

    @Override
    public int callCreateBody(String instanceId, String componentType, String ref, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callCreateBody(instanceId, componentType, ref, styles, attributes, events, margins, paddings, borders);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callCreateBody throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public int callAddElement(String instanceId, String componentType, String ref, int index, String parentRef, HashMap<String, String> styles, HashMap<String, String> attributes, HashSet<String> events, float[] margins, float[] paddings, float[] borders) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callAddElement(instanceId, componentType, ref, index, parentRef, styles, attributes, events, margins, paddings, borders);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                e.printStackTrace();
                WXLogUtils.e(TAG, "callAddElement throw error:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public int callRemoveElement(String instanceId, String ref) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveElement(instanceId, ref);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callRemoveElement throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callMoveElement(String instanceId, String ref, String parentref, int index) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callMoveElement(instanceId, ref, parentref, index);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callMoveElement throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callAddEvent(String instanceId, String ref, String event) {
        long start = System.currentTimeMillis();
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
        if (instance != null) {
            instance.firstScreenCreateInstanceTime(start);
        }
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callAddEvent(instanceId, ref, event);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callAddEvent throw exception:" + e.getMessage());
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callRemoveEvent(String instanceId, String ref, String event) {
        int errorCode;
        WXSDKInstance instance;
        long start;
        block4: {
            start = System.currentTimeMillis();
            instance = WXSDKManager.getInstance().getSDKInstance(instanceId);
            if (instance != null) {
                instance.firstScreenCreateInstanceTime(start);
            }
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callRemoveEvent(instanceId, ref, event);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e(TAG, "callRemoveEvent throw exception:" + e.getMessage());
            }
        }
        if (instance != null) {
            instance.callNativeTime(System.currentTimeMillis() - start);
        }
        return errorCode;
    }

    @Override
    public int callUpdateStyle(String instanceId, String ref, HashMap<String, Object> styles, HashMap<String, String> paddings, HashMap<String, String> margins, HashMap<String, String> borders) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateStyle(instanceId, ref, styles, paddings, margins, borders);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callUpdateStyle throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public int callUpdateAttrs(String instanceId, String ref, HashMap<String, String> attrs) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callUpdateAttrs(instanceId, ref, attrs);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callUpdateAttr throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public int callLayout(String instanceId, String ref, int top, int bottom, int left, int right, int height, int width, int index) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callLayout(instanceId, ref, top, bottom, left, right, height, width, index);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callLayout throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public int callCreateFinish(String instanceId) {
        int errorCode = 1;
        try {
            errorCode = WXBridgeManager.getInstance().callCreateFinish(instanceId);
        }
        catch (Throwable e) {
            WXLogUtils.e(TAG, "callCreateFinish throw exception:" + e.getMessage());
        }
        return errorCode;
    }

    @Override
    public int callHasTransitionPros(String instanceId, String ref, HashMap<String, String> styles) {
        int errorCode;
        block2: {
            errorCode = 1;
            try {
                errorCode = WXBridgeManager.getInstance().callHasTransitionPros(instanceId, ref, styles);
            }
            catch (Throwable e) {
                if (!WXEnvironment.isApkDebugable()) break block2;
                WXLogUtils.e(TAG, "callHasTransitionPros throw exception:" + e.getMessage());
            }
        }
        return errorCode;
    }

    @Override
    public void bindMeasurementToWXCore(String instanceId, String ref, ContentBoxMeasurement contentBoxMeasurement) {
        this.nativeBindMeasurementToWXCore(instanceId, ref, contentBoxMeasurement);
    }

    @Override
    public void setRenderContainerWrapContent(boolean wrap, String instanceId) {
        this.nativeSetRenderContainerWrapContent(wrap, instanceId);
    }

    @Override
    public int printFirstScreenRenderTime(String instanceId) {
        return this.nativePrintFirstScreenRenderTime(instanceId);
    }

    @Override
    public int printRenderFinishTime(String instanceId) {
        return this.nativePrintRenderFinishTime(instanceId);
    }

    @Override
    public void setDefaultHeightAndWidthIntoRootDom(String instanceId, float defaultWidth, float defaultHeight, boolean isWidthWrapContent, boolean isHeightWrapContent) {
        this.nativeSetDefaultHeightAndWidthIntoRootDom(instanceId, defaultWidth, defaultHeight, isWidthWrapContent, isHeightWrapContent);
    }

    @Override
    public void onInstanceClose(String instanceId) {
        this.nativeOnInstanceClose(instanceId);
    }

    @Override
    public void forceLayout(String instanceId) {
        this.nativeForceLayout(instanceId);
    }

    @Override
    public boolean notifyLayout(String instanceId) {
        return this.nativeNotifyLayout(instanceId);
    }

    @Override
    public void setStyleWidth(String instanceId, String ref, float value) {
        this.nativeSetStyleWidth(instanceId, ref, value);
    }

    @Override
    public void setMargin(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetMargin(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void setPadding(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetPadding(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void setPosition(String instanceId, String ref, CSSShorthand.EDGE edge, float value) {
        this.nativeSetPosition(instanceId, ref, edge.ordinal(), value);
    }

    @Override
    public void markDirty(String instanceId, String ref, boolean dirty) {
        this.nativeMarkDirty(instanceId, ref, dirty);
    }

    @Override
    public void setStyleHeight(String instanceId, String ref, float value) {
        this.nativeSetStyleHeight(instanceId, ref, value);
    }

    @Override
    public void registerCoreEnv(String key, String value) {
        this.nativeRegisterCoreEnv(key, value);
    }

    @Override
    public void setViewPortWidth(String instanceId, float value) {
        this.nativeSetViewPortWidth(instanceId, value);
    }
}

