/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.View;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.flat.FlatComponent;
import com.taobao.weex.ui.flat.WidgetContainer;
import com.taobao.weex.ui.flat.widget.AndroidViewWidget;
import com.taobao.weex.ui.flat.widget.Widget;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class FlatGUIContext
implements Destroyable {
    private Map<WXComponent, WidgetContainer> mWidgetRegistry = new ArrayMap();
    private Map<WXComponent, AndroidViewWidget> mViewWidgetRegistry = new ArrayMap();
    private Map<Widget, WXComponent> widgetToComponent = new ArrayMap();

    public boolean isFlatUIEnabled(WXComponent component) {
        return component.isFlatUIEnabled();
    }

    public void register(@NonNull WXComponent descendant, @NonNull WidgetContainer ancestor) {
        if (!(ancestor instanceof FlatComponent) || ((FlatComponent)((Object)ancestor)).promoteToView(true)) {
            this.mWidgetRegistry.put(descendant, ancestor);
        }
    }

    public void register(@NonNull WXComponent component, @NonNull AndroidViewWidget viewWidget) {
        this.mViewWidgetRegistry.put(component, viewWidget);
    }

    public void register(@NonNull Widget widget, @NonNull WXComponent component) {
        this.widgetToComponent.put(widget, component);
    }

    @Nullable
    public WidgetContainer getFlatComponentAncestor(@NonNull WXComponent flatWidget) {
        return this.mWidgetRegistry.get(flatWidget);
    }

    @Nullable
    public AndroidViewWidget getAndroidViewWidget(@NonNull WXComponent component) {
        return this.mViewWidgetRegistry.get(component);
    }

    public boolean promoteToView(@NonNull WXComponent component, boolean checkAncestor, @NonNull Class<? extends WXComponent<?>> expectedClass) {
        return !this.isFlatUIEnabled(component) || !expectedClass.equals(component.getClass()) || TextUtils.equals((CharSequence)component.getRef(), (CharSequence)"_root") || checkAncestor && this.getFlatComponentAncestor(component) == null || this.checkComponent(component);
    }

    @Nullable
    public View getWidgetContainerView(Widget widget) {
        WidgetContainer ancestor;
        View ret = null;
        WXComponent component = this.getComponent(widget);
        if (component != null && (ancestor = this.getFlatComponentAncestor(component)) != null) {
            ret = (View)ancestor.getHostView();
        }
        return ret;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void destroy() {
        this.widgetToComponent.clear();
        for (Map.Entry<WXComponent, AndroidViewWidget> entry : this.mViewWidgetRegistry.entrySet()) {
            entry.getValue().destroy();
        }
        this.mViewWidgetRegistry.clear();
        for (Map.Entry<WXComponent, Object> entry : this.mWidgetRegistry.entrySet()) {
            ((WidgetContainer)entry.getValue()).unmountFlatGUI();
        }
        this.mWidgetRegistry.clear();
    }

    @Nullable
    private WXComponent getComponent(@NonNull Widget widget) {
        return this.widgetToComponent.get(widget);
    }

    private boolean checkComponent(@NonNull WXComponent component) {
        boolean ret = false;
        ImmutableDomObject domObject = component.getDomObject();
        if (domObject != null) {
            WXStyle style = domObject.getStyles();
            WXAttr attr = domObject.getAttrs();
            if (style.containsKey("opacity") || style.containsKey("transform") || style.containsKey("visibility") || attr.containsKey("elevation") || attr.containsKey("ariaHidden") || attr.containsKey("ariaLabel") || attr.containsKey("fixedSize") || attr.containsKey("disabled") || style.isFixed() || style.isSticky() || !style.getPesudoStyles().isEmpty() || domObject.getEvents().size() > 0) {
                ret = true;
            }
        }
        return ret;
    }
}

