/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list.template;

import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.ui.component.list.template.CellRenderState;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.utils.WXUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CellDataManager {
    private static final String VIRTUAL_COMPONENT_SEPRATOR = "@";
    public static final String SUB_COMPONENT_TEMPLATE_ID = "@templateId";
    public static final String VIRTUAL_COMPONENT_ID = "@virtualComponentId";
    JSONArray listData;
    public final WXRecyclerTemplateList templateList;
    private Map<Integer, CellRenderState> renderStates = new ArrayMap();
    private Map<String, CellRenderState> virtualComponentRenderStates;

    public CellDataManager(WXRecyclerTemplateList templateList) {
        this.templateList = templateList;
    }

    public CellRenderState getRenderState(int position) {
        CellRenderState renderState = this.renderStates.get(position);
        if (renderState == null) {
            renderState = new CellRenderState();
            renderState.position = position;
            this.renderStates.put(position, renderState);
        }
        if (position != renderState.position) {
            renderState.position = position;
            renderState.hasPositionChange = true;
        }
        return renderState;
    }

    public void updateVirtualComponentData(String virutalComponentId, Object data) {
        if (this.virtualComponentRenderStates != null) {
            CellRenderState cellRenderState = this.virtualComponentRenderStates.get(virutalComponentId);
            if (cellRenderState != null) {
                cellRenderState.getVirtualComponentDatas().put(virutalComponentId, data);
                cellRenderState.hasVirtualCompoentUpdate = true;
            } else if (WXEnvironment.isApkDebugable()) {
                throw new IllegalArgumentException("virtualComponentDatas illegal state empty render state" + virutalComponentId);
            }
        } else if (WXEnvironment.isApkDebugable()) {
            throw new IllegalArgumentException("virtualComponentDatas illegal state " + virutalComponentId);
        }
    }

    public void createVirtualComponentData(int position, String virutalComponentId, Object data) {
        if (this.virtualComponentRenderStates == null) {
            this.virtualComponentRenderStates = new HashMap<String, CellRenderState>(8);
        }
        CellRenderState renderState = this.renderStates.get(position);
        renderState.getVirtualComponentDatas().put(virutalComponentId, data);
        this.virtualComponentRenderStates.put(virutalComponentId, renderState);
    }

    public void setListData(JSONArray listData) {
        if (this.listData != listData) {
            if (this.listData != null && WXUtils.getBoolean(this.templateList.getDomObject().getAttrs().get("exitDetach"), true).booleanValue()) {
                for (int i = 0; i < this.listData.size(); ++i) {
                    this.cleanRenderState(this.renderStates.remove(i));
                }
            }
            this.listData = listData;
            this.renderStates.clear();
            if (this.virtualComponentRenderStates != null) {
                this.virtualComponentRenderStates.clear();
            }
        }
    }

    public boolean insertData(int index, Object data) {
        this.listData.add(index, data);
        boolean renderStateChange = false;
        for (int i = this.listData.size(); i >= index; --i) {
            CellRenderState state = this.renderStates.remove(i);
            if (state == null) continue;
            this.renderStates.put(i + 1, state);
            renderStateChange = true;
        }
        return renderStateChange;
    }

    public boolean insertRange(int index, JSONArray data) {
        this.listData.addAll(index, (Collection)data);
        boolean renderStateChange = false;
        for (int i = this.listData.size() - 1; i >= index; --i) {
            CellRenderState state = this.renderStates.remove(i);
            if (state == null) continue;
            this.renderStates.put(i + 1, state);
            renderStateChange = true;
        }
        return renderStateChange;
    }

    public boolean updateData(Object data, int index) {
        boolean onlyDataChange = TextUtils.equals((CharSequence)this.templateList.getTemplateKey(index), (CharSequence)this.templateList.getTemplateKey(data));
        this.listData.set(index, data);
        if (!onlyDataChange) {
            this.cleanRenderState(this.renderStates.remove(index));
        } else {
            CellRenderState renderState = this.renderStates.get(index);
            if (renderState != null) {
                renderState.hasDataUpdate = true;
            }
        }
        return onlyDataChange;
    }

    public void removeData(Integer index) {
        this.listData.remove(index.intValue());
        this.cleanRenderState(this.renderStates.remove(index));
        int count = this.listData.size() + 1;
        for (int i = index + 1; i < count; ++i) {
            CellRenderState state = this.renderStates.remove(i);
            if (state == null) continue;
            this.renderStates.put(i - 1, state);
        }
    }

    private void cleanRenderState(CellRenderState renderState) {
        if (renderState == null) {
            return;
        }
        if (renderState.hasVirtualComponents()) {
            Collection<String> virtualComponentIds = renderState.getVirtualComponentIds().values();
            for (String virtualComponentId : virtualComponentIds) {
                if (this.virtualComponentRenderStates != null) {
                    this.virtualComponentRenderStates.remove(virtualComponentId);
                }
                WXBridgeManager.getInstance().asyncCallJSEventVoidResult("componentHook", this.templateList.getInstanceId(), null, virtualComponentId, "lifecycle", "detach", null);
            }
        }
    }

    public static String createVirtualComponentId(String listRef, String viewTreeKey, long itemId) {
        return listRef + VIRTUAL_COMPONENT_SEPRATOR + viewTreeKey + VIRTUAL_COMPONENT_SEPRATOR + itemId;
    }

    public static String getListRef(String virtualComponentId) {
        if (virtualComponentId == null) {
            return null;
        }
        return virtualComponentId.split(VIRTUAL_COMPONENT_SEPRATOR)[0];
    }
}

